package com.cybelia.sandra.entities;

import com.cybelia.sandra.SandraEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class EleveurDAOAbstract<E extends Eleveur> extends LieuDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Eleveur.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.Eleveur;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<InfoAccess> list = getContext()
                                                    .getDAO(InfoAccess.class)
                                                    .findAllByProperties(InfoAccess.PROPERTY_ELEVEUR, entity);
                                            for (InfoAccess item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getEleveur())) {
                                                    item.setEleveur(null);
                                                }
                        
                    }
                }

                                        {
                                        List<InfoAccess> list = getContext()
                                                    .getDAO(InfoAccess.class)
                                                    .findAllByProperties(InfoAccess.PROPERTY_ELEVEUR, entity);
                                            for (InfoAccess item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getEleveur())) {
                                                    item.setEleveur(null);
                                                }
                        
                    }
                }

                                        {
                                        List<Etape> list = getContext()
                                                    .getDAO(Etape.class)
                                                    .findAllByProperties(Etape.PROPERTY_ELEVEUR, entity);
                                            for (Etape item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getEleveur())) {
                                                    item.setEleveur(null);
                                                }
                        
                    }
                }

                                        {
                                        List<Note> list = getContext()
                                                    .getDAO(Note.class)
                                                    .findAllByProperties(Note.PROPERTY_ELEVEUR, entity);
                                            for (Note item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getEleveur())) {
                                                    item.setEleveur(null);
                                                }
                        
                    }
                }

                                        {
                                        List<ActionSecurite> list = getContext()
                                                    .getDAO(ActionSecurite.class)
                                                    .findAllByProperties(ActionSecurite.PROPERTY_ELEVEUR, entity);
                                            for (ActionSecurite item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getEleveur())) {
                                                    item.setEleveur(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByNaturalId(Societe societe, String code) throws TopiaException {
        return findByProperties(Eleveur.PROPERTY_SOCIETE, societe, Eleveur.PROPERTY_CODE, code);
    }

    public boolean existByNaturalId(Societe societe, String code) throws TopiaException {
        return existByProperties(Eleveur.PROPERTY_SOCIETE, societe, Eleveur.PROPERTY_CODE, code);
    }

    /**
     * @deprecated since 2.6.10, prefer use {@link #createByNaturalId}
     * @param societe 
     * @param code 
     * @return 
     * @throws TopiaException
     */
    @Deprecated
    public E create(Societe societe, String code) throws TopiaException {
        return create(Eleveur.PROPERTY_SOCIETE, societe, Eleveur.PROPERTY_CODE, code);
    }

    public E createByNaturalId(Societe societe, String code) throws TopiaException {
        return create(Eleveur.PROPERTY_SOCIETE, societe, Eleveur.PROPERTY_CODE, code);
    }

    public E createByNotNull(Societe societe, String code) throws TopiaException {
        return create(Eleveur.PROPERTY_SOCIETE, societe, Eleveur.PROPERTY_CODE, code);
    }

    public E findByRaisonSociale(String v) throws TopiaException {
        E result = findByProperty(Eleveur.PROPERTY_RAISON_SOCIALE, v);
        return result;
    }

    public List<E> findAllByRaisonSociale(String v) throws TopiaException {
        List<E> result = findAllByProperty(Eleveur.PROPERTY_RAISON_SOCIALE, v);
        return result;
    }

    public E findByTelephone(String v) throws TopiaException {
        E result = findByProperty(Eleveur.PROPERTY_TELEPHONE, v);
        return result;
    }

    public List<E> findAllByTelephone(String v) throws TopiaException {
        List<E> result = findAllByProperty(Eleveur.PROPERTY_TELEPHONE, v);
        return result;
    }

    public E findByMobile(String v) throws TopiaException {
        E result = findByProperty(Eleveur.PROPERTY_MOBILE, v);
        return result;
    }

    public List<E> findAllByMobile(String v) throws TopiaException {
        List<E> result = findAllByProperty(Eleveur.PROPERTY_MOBILE, v);
        return result;
    }

    public E findByAdresse(String v) throws TopiaException {
        E result = findByProperty(Eleveur.PROPERTY_ADRESSE, v);
        return result;
    }

    public List<E> findAllByAdresse(String v) throws TopiaException {
        List<E> result = findAllByProperty(Eleveur.PROPERTY_ADRESSE, v);
        return result;
    }

    public E findByVille(String v) throws TopiaException {
        E result = findByProperty(Eleveur.PROPERTY_VILLE, v);
        return result;
    }

    public List<E> findAllByVille(String v) throws TopiaException {
        List<E> result = findAllByProperty(Eleveur.PROPERTY_VILLE, v);
        return result;
    }

    public E findByCodePostal(String v) throws TopiaException {
        E result = findByProperty(Eleveur.PROPERTY_CODE_POSTAL, v);
        return result;
    }

    public List<E> findAllByCodePostal(String v) throws TopiaException {
        List<E> result = findAllByProperty(Eleveur.PROPERTY_CODE_POSTAL, v);
        return result;
    }

    public E findByNiveauSecurite(int v) throws TopiaException {
        E result = findByProperty(Eleveur.PROPERTY_NIVEAU_SECURITE, v);
        return result;
    }

    public List<E> findAllByNiveauSecurite(int v) throws TopiaException {
        List<E> result = findAllByProperty(Eleveur.PROPERTY_NIVEAU_SECURITE, v);
        return result;
    }

    public E findByEmail(String v) throws TopiaException {
        E result = findByProperty(Eleveur.PROPERTY_EMAIL, v);
        return result;
    }

    public List<E> findAllByEmail(String v) throws TopiaException {
        List<E> result = findAllByProperty(Eleveur.PROPERTY_EMAIL, v);
        return result;
    }

    public E findByCodeINSEE(String v) throws TopiaException {
        E result = findByProperty(Eleveur.PROPERTY_CODE_INSEE, v);
        return result;
    }

    public List<E> findAllByCodeINSEE(String v) throws TopiaException {
        List<E> result = findAllByProperty(Eleveur.PROPERTY_CODE_INSEE, v);
        return result;
    }

    public E findByCommentaire(String v) throws TopiaException {
        E result = findByProperty(Eleveur.PROPERTY_COMMENTAIRE, v);
        return result;
    }

    public List<E> findAllByCommentaire(String v) throws TopiaException {
        List<E> result = findAllByProperty(Eleveur.PROPERTY_COMMENTAIRE, v);
        return result;
    }

    public E findByContrainteHoraire(String v) throws TopiaException {
        E result = findByProperty(Eleveur.PROPERTY_CONTRAINTE_HORAIRE, v);
        return result;
    }

    public List<E> findAllByContrainteHoraire(String v) throws TopiaException {
        List<E> result = findAllByProperty(Eleveur.PROPERTY_CONTRAINTE_HORAIRE, v);
        return result;
    }

    public E findByNbTomTomGPSModif(int v) throws TopiaException {
        E result = findByProperty(Eleveur.PROPERTY_NB_TOM_TOM_GPSMODIF, v);
        return result;
    }

    public List<E> findAllByNbTomTomGPSModif(int v) throws TopiaException {
        List<E> result = findAllByProperty(Eleveur.PROPERTY_NB_TOM_TOM_GPSMODIF, v);
        return result;
    }

    public E findByAccesEleveur(InfoAccess v) throws TopiaException {
        E result = findByProperty(Eleveur.PROPERTY_ACCES_ELEVEUR, v);
        return result;
    }

    public List<E> findAllByAccesEleveur(InfoAccess v) throws TopiaException {
        List<E> result = findAllByProperty(Eleveur.PROPERTY_ACCES_ELEVEUR, v);
        return result;
    }

    public E findContainsAccesSilos(InfoAccess v) throws TopiaException {
        E result = findContains(Eleveur.PROPERTY_ACCES_SILOS, v);
        return result;
    }

    public List<E> findAllContainsAccesSilos(InfoAccess v) throws TopiaException {
        List<E> result = findAllContains(Eleveur.PROPERTY_ACCES_SILOS, v);
        return result;
    }

    public E findBySociete(Societe v) throws TopiaException {
        E result = findByProperty(Eleveur.PROPERTY_SOCIETE, v);
        return result;
    }

    public List<E> findAllBySociete(Societe v) throws TopiaException {
        List<E> result = findAllByProperty(Eleveur.PROPERTY_SOCIETE, v);
        return result;
    }

    public E findContainsNotes(Note v) throws TopiaException {
        E result = findContains(Eleveur.PROPERTY_NOTES, v);
        return result;
    }

    public List<E> findAllContainsNotes(Note v) throws TopiaException {
        List<E> result = findAllContains(Eleveur.PROPERTY_NOTES, v);
        return result;
    }

    public E findContainsActionSecurite(ActionSecurite v) throws TopiaException {
        E result = findContains(Eleveur.PROPERTY_ACTION_SECURITE, v);
        return result;
    }

    public List<E> findAllContainsActionSecurite(ActionSecurite v) throws TopiaException {
        List<E> result = findAllContains(Eleveur.PROPERTY_ACTION_SECURITE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == InfoAccess.class) {
            InfoAccessDAO dao = (InfoAccessDAO)
                getContext().getDAO(InfoAccess.class);
            tmp = dao.findAllByEleveur(entity);
            result.addAll(tmp);
        }

        if (type == Note.class) {
            NoteDAO dao = (NoteDAO)
                getContext().getDAO(Note.class);
            tmp = dao.findAllByEleveur(entity);
            result.addAll(tmp);
        }

        if (type == Etape.class) {
            EtapeDAO dao = (EtapeDAO)
                getContext().getDAO(Etape.class);
            tmp = dao.findAllByEleveur(entity);
            result.addAll(tmp);
        }

        if (type == ActionSecurite.class) {
            ActionSecuriteDAO dao = (ActionSecuriteDAO)
                getContext().getDAO(ActionSecurite.class);
            tmp = dao.findAllByEleveur(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(4);

        List<? extends TopiaEntity> list;

        list = findUsages(InfoAccess.class, entity);
        if (!list.isEmpty()) {
            result.put(InfoAccess.class, list);
        }

        list = findUsages(Note.class, entity);
        if (!list.isEmpty()) {
            result.put(Note.class, list);
        }

        list = findUsages(Etape.class, entity);
        if (!list.isEmpty()) {
            result.put(Etape.class, list);
        }

        list = findUsages(ActionSecurite.class, entity);
        if (!list.isEmpty()) {
            result.put(ActionSecurite.class, list);
        }

        return result;
    }

} //EleveurDAOAbstract<E extends Eleveur>
