package com.cybelia.sandra.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class CamionAbstract extends TopiaEntityAbstract implements Camion {

    /**
     * The id of the camion is the concatenation of the society and code. Only the id is unique.
     * Nom de l'attribut en BD : code
     */
    protected String code;

    /**
     * Nom de l'attribut en BD : nombreCompartiments
     */
    protected int nombreCompartiments;

    /**
     * Nom de l'attribut en BD : actif
     */
    protected boolean actif;

    /**
     * Nom de l'attribut en BD : camionsAssocies
     */
    protected List<Camion> camionsAssocies;

    /**
     * Nom de l'attribut en BD : defautChauffeurs
     */
    protected Collection<Chauffeur> defautChauffeurs;

    /**
     * Nom de l'attribut en BD : transporteur
     */
    protected Transporteur transporteur;

    /**
     * Nom de l'attribut en BD : societe
     */
    protected Societe societe;

    /**
     * Nom de l'attribut en BD : userIndicateurs
     */
    protected UserIndicateurs userIndicateurs;

    private static final long serialVersionUID = 3991652949140977977L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_CODE, String.class, code);
        visitor.visit(this, PROPERTY_NOMBRE_COMPARTIMENTS, int.class, nombreCompartiments);
        visitor.visit(this, PROPERTY_ACTIF, boolean.class, actif);
        visitor.visit(this, PROPERTY_CAMIONS_ASSOCIES, List.class, Camion.class, camionsAssocies);
        visitor.visit(this, PROPERTY_DEFAUT_CHAUFFEURS, Collection.class, Chauffeur.class, defautChauffeurs);
        visitor.visit(this, PROPERTY_TRANSPORTEUR, Transporteur.class, transporteur);
        visitor.visit(this, PROPERTY_SOCIETE, Societe.class, societe);
        visitor.visit(this, PROPERTY_USER_INDICATEURS, UserIndicateurs.class, userIndicateurs);
        visitor.end(this);
    }

    @Override
    public void setCode(String code) {
        String oldValue = this.code;
        fireOnPreWrite(PROPERTY_CODE, oldValue, code);
        this.code = code;
        fireOnPostWrite(PROPERTY_CODE, oldValue, code);
    }

    @Override
    public String getCode() {
        fireOnPreRead(PROPERTY_CODE, code);
        String result = this.code;
        fireOnPostRead(PROPERTY_CODE, code);
        return result;
    }

    @Override
    public void setNombreCompartiments(int nombreCompartiments) {
        int oldValue = this.nombreCompartiments;
        fireOnPreWrite(PROPERTY_NOMBRE_COMPARTIMENTS, oldValue, nombreCompartiments);
        this.nombreCompartiments = nombreCompartiments;
        fireOnPostWrite(PROPERTY_NOMBRE_COMPARTIMENTS, oldValue, nombreCompartiments);
    }

    @Override
    public int getNombreCompartiments() {
        fireOnPreRead(PROPERTY_NOMBRE_COMPARTIMENTS, nombreCompartiments);
        int result = this.nombreCompartiments;
        fireOnPostRead(PROPERTY_NOMBRE_COMPARTIMENTS, nombreCompartiments);
        return result;
    }

    @Override
    public void setActif(boolean actif) {
        boolean oldValue = this.actif;
        fireOnPreWrite(PROPERTY_ACTIF, oldValue, actif);
        this.actif = actif;
        fireOnPostWrite(PROPERTY_ACTIF, oldValue, actif);
    }

    @Override
    public boolean isActif() {
        fireOnPreRead(PROPERTY_ACTIF, actif);
        boolean result = this.actif;
        fireOnPostRead(PROPERTY_ACTIF, actif);
        return result;
    }

    @Override
    public boolean getActif() {
        fireOnPreRead(PROPERTY_ACTIF, actif);
        boolean result = this.actif;
        fireOnPostRead(PROPERTY_ACTIF, actif);
        return result;
    }

    @Override
    public void addCamionsAssocies(Camion camionsAssocies) {
        fireOnPreWrite(PROPERTY_CAMIONS_ASSOCIES, null, camionsAssocies);
        if (this.camionsAssocies == null) {
            this.camionsAssocies = new ArrayList<Camion>();
        }

        this.camionsAssocies.add(camionsAssocies);
        fireOnPostWrite(PROPERTY_CAMIONS_ASSOCIES, this.camionsAssocies.size(), null, camionsAssocies);
    }

    @Override
    public void addAllCamionsAssocies(List<Camion> camionsAssocies) {
        if (camionsAssocies == null) {
            return;
        }
        for (Camion item : camionsAssocies) {
            addCamionsAssocies(item);
        }
    }

    @Override
    public void setCamionsAssocies(List<Camion> camionsAssocies) {
        // Copy elements to keep data for fire with new reference
        List<Camion> oldValue = this.camionsAssocies != null ? new ArrayList<Camion>(this.camionsAssocies) : null;
        fireOnPreWrite(PROPERTY_CAMIONS_ASSOCIES, oldValue, camionsAssocies);
        this.camionsAssocies = camionsAssocies;
        fireOnPostWrite(PROPERTY_CAMIONS_ASSOCIES, oldValue, camionsAssocies);
    }

    @Override
    public void removeCamionsAssocies(Camion camionsAssocies) {
        fireOnPreWrite(PROPERTY_CAMIONS_ASSOCIES, camionsAssocies, null);
        if (this.camionsAssocies == null || !this.camionsAssocies.remove(camionsAssocies)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_CAMIONS_ASSOCIES, this.camionsAssocies.size() + 1, camionsAssocies, null);
    }

    @Override
    public void clearCamionsAssocies() {
        if (this.camionsAssocies == null) {
            return;
        }
        List<Camion> oldValue = new ArrayList<Camion>(this.camionsAssocies);
        fireOnPreWrite(PROPERTY_CAMIONS_ASSOCIES, oldValue, this.camionsAssocies);
        this.camionsAssocies.clear();
        fireOnPostWrite(PROPERTY_CAMIONS_ASSOCIES, oldValue, this.camionsAssocies);
    }

    @Override
    public List<Camion> getCamionsAssocies() {
        return camionsAssocies;
    }

    @Override
    public Camion getCamionsAssociesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(camionsAssocies, topiaId);
    }

    @Override
    public int sizeCamionsAssocies() {
        if (camionsAssocies == null) {
            return 0;
        }
        return camionsAssocies.size();
    }

    @Override
    public boolean isCamionsAssociesEmpty() {
        int size = sizeCamionsAssocies();
        return size == 0;
    }

    @Override
    public void addDefautChauffeurs(Chauffeur defautChauffeurs) {
        fireOnPreWrite(PROPERTY_DEFAUT_CHAUFFEURS, null, defautChauffeurs);
        if (this.defautChauffeurs == null) {
            this.defautChauffeurs = new ArrayList<Chauffeur>();
        }

        if (defautChauffeurs.getCamions() == null) {
            defautChauffeurs.setCamions(new ArrayList<Camion>());
        }
        defautChauffeurs.getCamions().add(this);

        this.defautChauffeurs.add(defautChauffeurs);
        fireOnPostWrite(PROPERTY_DEFAUT_CHAUFFEURS, this.defautChauffeurs.size(), null, defautChauffeurs);
    }

    @Override
    public void addAllDefautChauffeurs(Collection<Chauffeur> defautChauffeurs) {
        if (defautChauffeurs == null) {
            return;
        }
        for (Chauffeur item : defautChauffeurs) {
            addDefautChauffeurs(item);
        }
    }

    @Override
    public void setDefautChauffeurs(Collection<Chauffeur> defautChauffeurs) {
        // Copy elements to keep data for fire with new reference
        Collection<Chauffeur> oldValue = this.defautChauffeurs != null ? new ArrayList<Chauffeur>(this.defautChauffeurs) : null;
        fireOnPreWrite(PROPERTY_DEFAUT_CHAUFFEURS, oldValue, defautChauffeurs);
        this.defautChauffeurs = defautChauffeurs;
        fireOnPostWrite(PROPERTY_DEFAUT_CHAUFFEURS, oldValue, defautChauffeurs);
    }

    @Override
    public void removeDefautChauffeurs(Chauffeur defautChauffeurs) {
        fireOnPreWrite(PROPERTY_DEFAUT_CHAUFFEURS, defautChauffeurs, null);
        if (this.defautChauffeurs == null || !this.defautChauffeurs.remove(defautChauffeurs)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        defautChauffeurs.getCamions().remove(this);

        fireOnPostWrite(PROPERTY_DEFAUT_CHAUFFEURS, this.defautChauffeurs.size() + 1, defautChauffeurs, null);
    }

    @Override
    public void clearDefautChauffeurs() {
        if (this.defautChauffeurs == null) {
            return;
        }
        for (Chauffeur item : this.defautChauffeurs) {
            item.getCamions().remove(this);
        }
        Collection<Chauffeur> oldValue = new ArrayList<Chauffeur>(this.defautChauffeurs);
        fireOnPreWrite(PROPERTY_DEFAUT_CHAUFFEURS, oldValue, this.defautChauffeurs);
        this.defautChauffeurs.clear();
        fireOnPostWrite(PROPERTY_DEFAUT_CHAUFFEURS, oldValue, this.defautChauffeurs);
    }

    @Override
    public Collection<Chauffeur> getDefautChauffeurs() {
        return defautChauffeurs;
    }

    @Override
    public Chauffeur getDefautChauffeursByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(defautChauffeurs, topiaId);
    }

    @Override
    public int sizeDefautChauffeurs() {
        if (defautChauffeurs == null) {
            return 0;
        }
        return defautChauffeurs.size();
    }

    @Override
    public boolean isDefautChauffeursEmpty() {
        int size = sizeDefautChauffeurs();
        return size == 0;
    }

    @Override
    public void setTransporteur(Transporteur transporteur) {
        Transporteur oldValue = this.transporteur;
        fireOnPreWrite(PROPERTY_TRANSPORTEUR, oldValue, transporteur);
        this.transporteur = transporteur;
        fireOnPostWrite(PROPERTY_TRANSPORTEUR, oldValue, transporteur);
    }

    @Override
    public Transporteur getTransporteur() {
        fireOnPreRead(PROPERTY_TRANSPORTEUR, transporteur);
        Transporteur result = this.transporteur;
        fireOnPostRead(PROPERTY_TRANSPORTEUR, transporteur);
        return result;
    }

    @Override
    public void setSociete(Societe societe) {
        Societe oldValue = this.societe;
        fireOnPreWrite(PROPERTY_SOCIETE, oldValue, societe);
        this.societe = societe;
        fireOnPostWrite(PROPERTY_SOCIETE, oldValue, societe);
    }

    @Override
    public Societe getSociete() {
        fireOnPreRead(PROPERTY_SOCIETE, societe);
        Societe result = this.societe;
        fireOnPostRead(PROPERTY_SOCIETE, societe);
        return result;
    }

    @Override
    public void setUserIndicateurs(UserIndicateurs userIndicateurs) {
        UserIndicateurs oldValue = this.userIndicateurs;
        fireOnPreWrite(PROPERTY_USER_INDICATEURS, oldValue, userIndicateurs);
        this.userIndicateurs = userIndicateurs;
        fireOnPostWrite(PROPERTY_USER_INDICATEURS, oldValue, userIndicateurs);
    }

    @Override
    public UserIndicateurs getUserIndicateurs() {
        fireOnPreRead(PROPERTY_USER_INDICATEURS, userIndicateurs);
        UserIndicateurs result = this.userIndicateurs;
        fireOnPostRead(PROPERTY_USER_INDICATEURS, userIndicateurs);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_CODE, this.code).
            append(PROPERTY_NOMBRE_COMPARTIMENTS, this.nombreCompartiments).
            append(PROPERTY_ACTIF, this.actif).
            append(PROPERTY_CAMIONS_ASSOCIES, this.camionsAssocies).
            append(PROPERTY_TRANSPORTEUR, this.transporteur).
            append(PROPERTY_SOCIETE, this.societe).
            append(PROPERTY_USER_INDICATEURS, this.userIndicateurs).
         toString();
        return result;
    }

} //CamionAbstract
