/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie.services.service;

import com.franciaflex.magalie.persistence.StoredArticles;
import com.franciaflex.magalie.persistence.entity.Location;
import com.franciaflex.magalie.persistence.entity.StoredArticle;
import com.franciaflex.magalie.services.service.ReceptionLocation;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class ReceptionTask {
    protected StoredArticle storedArticle;
    protected double quantity;
    protected Iterable<Location> fixedLocations;
    protected Iterable<StoredArticle> alreadyUsedLocations;
    protected Iterable<Location> extraLocations;

    public ReceptionTask(StoredArticle storedArticle, double quantity) {
        this.storedArticle = storedArticle;
        this.quantity = quantity;
    }

    public StoredArticle getStoredArticle() {
        return this.storedArticle;
    }

    public Set<ReceptionLocation> getLocations() {
        ImmutableMap locationToStoredArticle = Maps.uniqueIndex(this.alreadyUsedLocations, (Function)StoredArticles.getLocationFunction());
        LinkedHashSet receptionLocations = Sets.newLinkedHashSet();
        ImmutableSet allLocations = ImmutableSet.builder().addAll(this.fixedLocations).addAll(Iterables.transform(this.alreadyUsedLocations, (Function)StoredArticles.getLocationFunction())).addAll(this.extraLocations).build();
        for (Location location : allLocations) {
            ReceptionLocation receptionLocation = new ReceptionLocation(location);
            StoredArticle storedArticleInLocation = (StoredArticle)locationToStoredArticle.get((Object)location);
            if (storedArticleInLocation == null) {
                receptionLocation.setAlreadyStoredQuantity(0.0);
            } else {
                receptionLocation.setAlreadyStoredQuantity(storedArticleInLocation.getQuantity());
            }
            receptionLocations.add(receptionLocation);
        }
        return receptionLocations;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public boolean isUserMustChooseExtraLocation() {
        return Iterables.isEmpty(this.fixedLocations) && Iterables.isEmpty(this.alreadyUsedLocations);
    }

    public void setFixedLocations(Iterable<Location> fixedLocations) {
        this.fixedLocations = fixedLocations;
    }

    public void setAlreadyUsedLocations(Iterable<StoredArticle> alreadyUsedLocations) {
        this.alreadyUsedLocations = alreadyUsedLocations;
    }

    public void setExtraLocations(Iterable<Location> extraLocations) {
        this.extraLocations = extraLocations;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }
}

