/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie.services.service;

import com.franciaflex.magalie.persistence.JpaMagaliePersistenceContext;
import com.franciaflex.magalie.persistence.dao.KanbanJpaDao;
import com.franciaflex.magalie.persistence.dao.WarehouseJpaDao;
import com.franciaflex.magalie.persistence.entity.Article;
import com.franciaflex.magalie.persistence.entity.Building;
import com.franciaflex.magalie.persistence.entity.Company;
import com.franciaflex.magalie.persistence.entity.Kanban;
import com.franciaflex.magalie.persistence.entity.Location;
import com.franciaflex.magalie.persistence.entity.MagalieUser;
import com.franciaflex.magalie.persistence.entity.Warehouse;
import com.franciaflex.magalie.services.MagalieService;
import com.franciaflex.magalie.services.MagalieServiceContext;
import com.franciaflex.magalie.services.exception.ArticleNotAvailableForKanbanException;
import com.franciaflex.magalie.services.exception.InvalidMagalieBarcodeException;
import com.franciaflex.magalie.services.service.ArticleStorageService;
import com.franciaflex.magalie.services.service.MagalieBarcodeService;
import com.franciaflex.magalie.services.service.RealTimeStorageMovementTask;
import com.franciaflex.magalie.services.service.SimpleWithdrawItemService;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FulfilKanbanService
implements MagalieService {
    private static final Log log = LogFactory.getLog(FulfilKanbanService.class);
    protected MagalieServiceContext serviceContext;

    @Override
    public void setServiceContext(MagalieServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public Warehouse getStore(String storeId) {
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        WarehouseJpaDao warehouseDao = persistenceContext.getWarehouseDao();
        Warehouse warehouse = (Warehouse)warehouseDao.findById(storeId);
        return warehouse;
    }

    public double getDefinedQuantity(Article article, Warehouse destinationStore) throws ArticleNotAvailableForKanbanException {
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        KanbanJpaDao dao = persistenceContext.getKanbanDao();
        Kanban kanban = dao.find(article, destinationStore);
        if (kanban == null) {
            throw new ArticleNotAvailableForKanbanException(article);
        }
        double quantityInKanban = kanban.getRequiredQuantity();
        return quantityInKanban;
    }

    public List<Warehouse> getDestinationWarehouses(Building building) {
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        WarehouseJpaDao warehouseDao = persistenceContext.getWarehouseDao();
        List destinationWarehouses = warehouseDao.findAllWithoutLocations(building);
        return destinationWarehouses;
    }

    public Article getArticle(String articleBarcode, Company company) throws InvalidMagalieBarcodeException {
        MagalieBarcodeService magalieBarcodeService = this.serviceContext.newService(MagalieBarcodeService.class);
        Article article = magalieBarcodeService.getArticle(articleBarcode, company);
        return article;
    }

    public Location getDestinationLocation(Warehouse destinationWarehouse) {
        SimpleWithdrawItemService simpleWithdrawItemService = this.serviceContext.newService(SimpleWithdrawItemService.class);
        Location destinationLocation = simpleWithdrawItemService.getDestinationLocation(destinationWarehouse);
        return destinationLocation;
    }

    public RealTimeStorageMovementTask getRealTimeStorageMovementTask(Building building, MagalieUser magalieUser, String articleId) {
        ArticleStorageService articleStorageService = this.serviceContext.newService(ArticleStorageService.class);
        RealTimeStorageMovementTask realTimeStorageMovementTask = articleStorageService.getRealTimeStorageMovementTask(building, magalieUser, articleId);
        return realTimeStorageMovementTask;
    }
}

