/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie.services.service;

import com.franciaflex.magalie.persistence.JpaMagaliePersistenceContext;
import com.franciaflex.magalie.persistence.StorageMovements;
import com.franciaflex.magalie.persistence.StoredArticles;
import com.franciaflex.magalie.persistence.dao.ArticleJpaDao;
import com.franciaflex.magalie.persistence.dao.LocationJpaDao;
import com.franciaflex.magalie.persistence.dao.StorageMovementJpaDao;
import com.franciaflex.magalie.persistence.dao.StoredArticleJpaDao;
import com.franciaflex.magalie.persistence.dao.UnavailableArticleJpaDao;
import com.franciaflex.magalie.persistence.entity.Article;
import com.franciaflex.magalie.persistence.entity.Building;
import com.franciaflex.magalie.persistence.entity.Location;
import com.franciaflex.magalie.persistence.entity.MagalieUser;
import com.franciaflex.magalie.persistence.entity.StorageMovement;
import com.franciaflex.magalie.persistence.entity.StoredArticle;
import com.franciaflex.magalie.persistence.entity.UnavailableArticle;
import com.franciaflex.magalie.services.MagalieService;
import com.franciaflex.magalie.services.MagalieServiceContext;
import com.franciaflex.magalie.services.StorageMovementConfirmation;
import com.franciaflex.magalie.services.service.LocationErrorsService;
import com.franciaflex.magalie.services.service.RealTimeStorageMovementTask;
import com.franciaflex.magalie.services.service.RequestedArticleService;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jpa.api.JpaEntity;

public class ArticleStorageService
implements MagalieService {
    private static final Log log = LogFactory.getLog(ArticleStorageService.class);
    protected MagalieServiceContext serviceContext;

    @Override
    public void setServiceContext(MagalieServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    protected void updateArticleAvailability(Building building, Article article, boolean articleIsAvailable) {
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        UnavailableArticleJpaDao dao = persistenceContext.getUnavailableArticleDao();
        UnavailableArticle unavailableArticle = dao.findByArticle(building, article);
        if (articleIsAvailable) {
            if (unavailableArticle != null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("article " + article + " is no longer considered as unavailable"));
                }
                dao.remove((JpaEntity)unavailableArticle);
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("reporting article " + article + " as unavailable"));
            }
            if (unavailableArticle == null) {
                UnavailableArticle newUnavailableArticle = new UnavailableArticle();
                newUnavailableArticle.setArticle(article);
                newUnavailableArticle.setBuilding(building);
                newUnavailableArticle.setReportDate(this.serviceContext.getNow());
                dao.persist((JpaEntity)newUnavailableArticle);
            }
        }
        persistenceContext.commit();
    }

    protected Set<StoredArticle> sortStoredArticlesByPriority(Iterable<StoredArticle> storedArticles) {
        Ordering orderingByPriority = Ordering.compound((Iterable)Lists.newArrayList((Object[])new Comparator[]{StoredArticles.fixedLocationForArticleComparator(), StoredArticles.locationWithLowestQuantityFirstComparator(), StoredArticles.articleStoredInLocationsRequiringDriverLicenseFirstComparator()}));
        TreeSet storedArticlesByPriority = Sets.newTreeSet((Comparator)orderingByPriority);
        Iterables.addAll((Collection)storedArticlesByPriority, storedArticles);
        return storedArticlesByPriority;
    }

    protected Iterable<StoredArticle> getStoredArticles(Building building, Article article) {
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        StoredArticleJpaDao storedArticleDao = persistenceContext.getStoredArticleDao();
        Iterable<Object> storedArticles = storedArticleDao.findAllForArticleInBuilding(article, building);
        StorageMovementJpaDao storageMovementDao = persistenceContext.getStorageMovementDao();
        List storageMovementsForArticle = storageMovementDao.findAllByArticle(article);
        boolean articleAvailable = !Iterables.isEmpty((Iterable)(storedArticles = this.computeActualQuantities(storedArticles, storageMovementsForArticle)));
        this.updateArticleAvailability(building, article, articleAvailable);
        LocationErrorsService locationErrorsService = this.serviceContext.newService(LocationErrorsService.class);
        storedArticles = locationErrorsService.filterLocationInError(storedArticles);
        return storedArticles;
    }

    protected Iterable<StoredArticle> computeActualQuantities(Iterable<StoredArticle> storedArticles, Iterable<StorageMovement> storageMovements) {
        ImmutableListMultimap storedArticlesByArticles = Multimaps.index(storedArticles, (Function)StoredArticles.getArticleFunction());
        ImmutableListMultimap allStorageMovementsInReceptionByArticle = Multimaps.index(storageMovements, (Function)StorageMovements.getArticleFunction());
        for (Map.Entry articleStored : storedArticlesByArticles.entries()) {
            Article article = (Article)articleStored.getKey();
            StoredArticle storedArticle = (StoredArticle)articleStored.getValue();
            Location location = storedArticle.getLocation();
            for (StorageMovement storageMovement : allStorageMovementsInReceptionByArticle.get((Object)article)) {
                double actualQuantity;
                if (storageMovement.getOriginLocation().equals((Object)location)) {
                    actualQuantity = storedArticle.getQuantity() - storageMovement.getActualQuantity();
                    storedArticle.setQuantity(actualQuantity);
                }
                if (!storageMovement.getDestinationLocation().equals((Object)location)) continue;
                actualQuantity = storedArticle.getQuantity() + storageMovement.getActualQuantity();
                storedArticle.setQuantity(actualQuantity);
            }
        }
        Iterable result = Iterables.filter(storedArticles, (Predicate)StoredArticles.notEmpty());
        return result;
    }

    public void confirmStorageMovement(StorageMovementConfirmation confirmation, MagalieUser magalieUser) {
        Preconditions.checkNotNull((Object)confirmation);
        if (log.isDebugEnabled()) {
            log.debug((Object)(magalieUser + " will make confirmation " + confirmation));
        }
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        ArticleJpaDao articleDao = persistenceContext.getArticleDao();
        Article article = (Article)articleDao.findById(confirmation.getArticleId());
        Date confirmDate = this.serviceContext.getNow();
        StorageMovementJpaDao storageMovementDao = persistenceContext.getStorageMovementDao();
        HashSet confirmedStorageMovements = Sets.newHashSet();
        for (String storageMovementId : confirmation.getStorageMovementIds()) {
            StorageMovement storageMovement = (StorageMovement)storageMovementDao.findById(storageMovementId);
            storageMovement.setConfirmDate(confirmDate);
            confirmedStorageMovements.add(storageMovement);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("confirmed storage movement " + storageMovement));
        }
        LocationErrorsService locationErrorsService = this.serviceContext.newService(LocationErrorsService.class);
        LocationJpaDao locationDao = persistenceContext.getLocationDao();
        for (String locationInErrorId : confirmation.getLocationInErrorIds()) {
            Location locationInError = (Location)locationDao.findById(locationInErrorId);
            locationErrorsService.reportError(locationInError, article, magalieUser, confirmDate);
        }
        RequestedArticleService requestedArticleService = this.serviceContext.newService(RequestedArticleService.class);
        requestedArticleService.onStorageMovementConfirmation(magalieUser, confirmation, confirmedStorageMovements);
        persistenceContext.commit();
    }

    public void cancelStorageMovements(MagalieUser magalieUser) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("will make cancellation for " + magalieUser));
        }
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        StorageMovementJpaDao storageMovementDao = persistenceContext.getStorageMovementDao();
        List unconfirmedStorageMovements = storageMovementDao.findAllUnconfirmed(magalieUser);
        for (StorageMovement unconfirmedStorageMovement : unconfirmedStorageMovements) {
            storageMovementDao.remove((JpaEntity)unconfirmedStorageMovement);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("cancelled " + unconfirmedStorageMovements.size() + " storage movements " + unconfirmedStorageMovements));
        }
        persistenceContext.commit();
    }

    public RealTimeStorageMovementTask getRealTimeStorageMovementTask(Building building, MagalieUser magalieUser, String articleId) {
        Preconditions.checkNotNull((Object)magalieUser);
        Preconditions.checkNotNull((Object)building);
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        ArticleJpaDao articleDao = persistenceContext.getArticleDao();
        Article article = (Article)articleDao.findById(articleId);
        Preconditions.checkNotNull((Object)article);
        if (log.isInfoEnabled()) {
            log.info((Object)("will process real time article request in building " + building + " by user " + magalieUser + " for article " + article));
        }
        Iterable storedArticles = this.getStoredArticles(building, article);
        if (log.isTraceEnabled()) {
            log.trace((Object)("found " + Iterables.size(storedArticles) + " stored articles " + storedArticles));
        }
        StorageMovementJpaDao storageMovementDao = persistenceContext.getStorageMovementDao();
        List storageMovements = storageMovementDao.findAllUnconfirmed(magalieUser);
        if (log.isDebugEnabled()) {
            log.debug((Object)("found " + storageMovements.size() + " movements already done " + storageMovements));
        }
        ImmutableSet alreadyUsedLocations = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)storageMovements, (Function)StorageMovements.getOriginFunction()));
        if (log.isTraceEnabled()) {
            log.trace((Object)("already used locations " + alreadyUsedLocations));
        }
        Predicate articleStoredInAlreadyUsedLocation = Predicates.compose((Predicate)Predicates.in((Collection)alreadyUsedLocations), (Function)StoredArticles.getLocationFunction());
        storedArticles = Iterables.filter(storedArticles, (Predicate)Predicates.not((Predicate)articleStoredInAlreadyUsedLocation));
        if (log.isTraceEnabled()) {
            log.trace((Object)("after removing already used locations " + Iterables.size((Iterable)storedArticles) + " stored articles remaining " + storedArticles));
        }
        Set<StoredArticle> sortedStoredArticles = this.sortStoredArticlesByPriority(storedArticles);
        RealTimeStorageMovementTask realTimeStorageMovementTask = new RealTimeStorageMovementTask();
        if (sortedStoredArticles.isEmpty()) {
            realTimeStorageMovementTask.setArticleUnavailable(true);
        } else {
            Predicate articleStoredInAccessibleLocationPredicate = StoredArticles.articleStoredInAccessibleLocationPredicate((MagalieUser)magalieUser);
            Optional accessibleStoredArticleOptional = Iterables.tryFind(sortedStoredArticles, (Predicate)articleStoredInAccessibleLocationPredicate);
            if (accessibleStoredArticleOptional.isPresent()) {
                StoredArticle accessibleStoredArticle = (StoredArticle)accessibleStoredArticleOptional.get();
                realTimeStorageMovementTask.setStoredArticle(accessibleStoredArticle);
            } else {
                realTimeStorageMovementTask.setDriverLicenseRequired(true);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("will return real time storage movement task " + realTimeStorageMovementTask));
        }
        return realTimeStorageMovementTask;
    }

    public Article getArticle(String articleId) {
        ArticleJpaDao articleDao = this.serviceContext.getPersistenceContext().getArticleDao();
        Article article = (Article)articleDao.findById(articleId);
        return article;
    }

    public StorageMovement saveStorageMovement(MagalieUser magalieUser, String articleId, String originLocationId, String destinationLocationId, double quantity) {
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        ArticleJpaDao articleDao = persistenceContext.getArticleDao();
        Article article = (Article)articleDao.findById(articleId);
        LocationJpaDao locationDao = persistenceContext.getLocationDao();
        Location originLocation = (Location)locationDao.findById(originLocationId);
        Location destinationLocation = (Location)locationDao.findById(destinationLocationId);
        StorageMovementJpaDao storageMovementDao = persistenceContext.getStorageMovementDao();
        HashMap storageMovementProperties = Maps.newHashMap();
        storageMovementProperties.put("magalieUser", magalieUser);
        storageMovementProperties.put("article", article);
        storageMovementProperties.put("originLocation", originLocation);
        storageMovementProperties.put("destinationLocation", destinationLocation);
        storageMovementProperties.put("confirmDate", null);
        StorageMovement storageMovement = (StorageMovement)storageMovementDao.findByProperties((Map)storageMovementProperties);
        if (storageMovement == null) {
            storageMovement = new StorageMovement();
            storageMovement.setOriginLocation(originLocation);
            storageMovement.setDestinationLocation(destinationLocation);
            storageMovement.setMagalieUser(magalieUser);
            storageMovement.setArticle(article);
            storageMovementDao.persist((JpaEntity)storageMovement);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("storage movement already exists, user just want to update quantity " + storageMovement));
        }
        storageMovement.setActualQuantity(Double.valueOf(quantity));
        Date now = this.serviceContext.getNow();
        storageMovement.setMovementDate(now);
        persistenceContext.commit();
        if (log.isInfoEnabled()) {
            log.info((Object)("saved real time storage movement " + storageMovement));
        }
        return storageMovement;
    }
}

