/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie.services.exception;

import com.franciaflex.magalie.persistence.Locations;
import com.franciaflex.magalie.persistence.entity.Location;
import com.franciaflex.magalie.persistence.entity.MagalieUser;
import com.franciaflex.magalie.services.exception.MagalieException;

public class InaccessibleLocationException
extends MagalieException {
    protected Location location;
    protected MagalieUser magalieUser;

    public InaccessibleLocationException(String message, Location location, MagalieUser magalieUser) {
        super(message);
        this.location = location;
        this.magalieUser = magalieUser;
    }

    public static void checkLocationIsAccessible(Location location, MagalieUser magalieUser) throws InaccessibleLocationException {
        if (Locations.inaccessibleLocationPredicate((MagalieUser)magalieUser).apply((Object)location)) {
            InaccessibleLocationException newException = new InaccessibleLocationException("user is not allowed to access given location", location, magalieUser);
            throw newException;
        }
    }

    public Location getLocation() {
        return this.location;
    }

    public MagalieUser getMagalieUser() {
        return this.magalieUser;
    }
}

