/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie.services;

import com.franciaflex.magalie.persistence.entity.Article;
import com.franciaflex.magalie.persistence.entity.StoredArticle;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;

public class SimpleWithdrawItemTask {
    protected Article article;
    protected List<StoredArticle> storedArticles;
    protected boolean driverLicenseRequired;
    protected boolean articleUnavailable;

    public SimpleWithdrawItemTask(Article article, Iterable<StoredArticle> storedArticles, boolean driverLicenseRequired, boolean articleUnavailable) {
        this.article = article;
        this.storedArticles = Lists.newArrayList(storedArticles);
        this.driverLicenseRequired = driverLicenseRequired;
        this.articleUnavailable = articleUnavailable;
    }

    public Article getArticle() {
        return this.article;
    }

    public List<StoredArticle> getStoredArticles() {
        return this.storedArticles;
    }

    public boolean isDriverLicenseRequired() {
        if (this.driverLicenseRequired) {
            Preconditions.checkState((!this.articleUnavailable ? 1 : 0) != 0);
        }
        return this.driverLicenseRequired;
    }

    public boolean isArticleUnavailable() {
        if (this.articleUnavailable) {
            Preconditions.checkState((!this.driverLicenseRequired ? 1 : 0) != 0);
        }
        return this.articleUnavailable;
    }
}

