/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie.services;

import com.franciaflex.magalie.MagalieApplicationConfig;
import com.franciaflex.magalie.MagalieTechnicalException;
import com.franciaflex.magalie.persistence.JpaMagaliePersistenceContext;
import com.franciaflex.magalie.services.MagalieService;
import com.franciaflex.magalie.services.MagalieServiceContext;
import com.franciaflex.magalie.services.MagalieUserNotificationContext;
import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;

public class DefaultMagalieServiceContext
implements MagalieServiceContext {
    protected MagalieApplicationConfig magalieApplicationConfig;
    protected JpaMagaliePersistenceContext persistenceContext;
    protected MagalieUserNotificationContext userNotificationContext;

    @Override
    public MagalieApplicationConfig getMagalieApplicationConfig() {
        return this.magalieApplicationConfig;
    }

    public void setMagalieApplicationConfig(MagalieApplicationConfig magalieApplicationConfig) {
        this.magalieApplicationConfig = magalieApplicationConfig;
    }

    @Override
    public <E extends MagalieService> E newService(Class<E> serviceClass) {
        MagalieService service;
        try {
            Constructor<E> constructor = serviceClass.getConstructor(new Class[0]);
            service = (MagalieService)constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new MagalieTechnicalException("all services must provide a non-argument constructor", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new MagalieTechnicalException("unable to instantiate magalie service", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new MagalieTechnicalException("unable to instantiate magalie service", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new MagalieTechnicalException("unable to instantiate magalie service", (Throwable)e);
        }
        service.setServiceContext(this);
        return (E)service;
    }

    @Override
    public Date getNow() {
        Date now = new Date();
        return now;
    }

    @Override
    public JpaMagaliePersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    public void setPersistenceContext(JpaMagaliePersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    @Override
    public MagalieUserNotificationContext getUserNotificationContext() {
        Preconditions.checkState((this.userNotificationContext != null ? 1 : 0) != 0, (Object)"user notification context not provided");
        return this.userNotificationContext;
    }

    public void setUserNotificationContext(MagalieUserNotificationContext userNotificationContext) {
        this.userNotificationContext = userNotificationContext;
    }
}

