/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.bean;

import com.google.common.base.Preconditions;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Set;
import javax.swing.event.EventListenerList;
import org.apache.commons.lang3.ObjectUtils;
import org.nuiton.util.beans.BeanUtil;
import org.nuiton.validator.NuitonValidator;
import org.nuiton.validator.NuitonValidatorModel;
import org.nuiton.validator.NuitonValidatorProvider;
import org.nuiton.validator.NuitonValidatorScope;

public abstract class AbstractValidator<O> {
    public static final String CONTEXT_PROPERTY = "context";
    public static final String SCOPES_PROPERTY = "scopes";
    public static final String VALID_PROPERTY = "valid";
    public static final String CHANGED_PROPERTY = "changed";
    protected boolean changed;
    protected boolean valid = true;
    protected boolean canValidate = true;
    protected final PropertyChangeListener l;
    protected final PropertyChangeSupport pcs;
    protected final EventListenerList listenerList = new EventListenerList();
    protected final NuitonValidatorProvider validatorProvider;

    protected AbstractValidator(NuitonValidatorProvider validatorProvider, Class<O> beanClass) {
        boolean javaBeanCompiliant = BeanUtil.isJavaBeanCompiliant(beanClass);
        Preconditions.checkState((boolean)javaBeanCompiliant, (Object)(beanClass.getName() + " is not JavaBean compiliant (" + "addPropertyChangeListener" + ", or " + "removePropertyChangeListener" + " method not found)."));
        this.validatorProvider = validatorProvider;
        this.pcs = new PropertyChangeSupport(this);
        this.l = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object bean = evt.getSource();
                AbstractValidator.this.doValidate(bean);
            }
        };
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
        this.firePropertyChange(CHANGED_PROPERTY, null, changed);
    }

    public boolean isCanValidate() {
        return this.canValidate;
    }

    public void setCanValidate(boolean canValidate) {
        this.canValidate = canValidate;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
        this.firePropertyChange(VALID_PROPERTY, null, valid);
    }

    public String getContext() {
        return this.getModel().getContext();
    }

    public void setContext(String context) {
        String oldContext = this.getContext();
        if (ObjectUtils.equals((Object)context, (Object)oldContext)) {
            return;
        }
        NuitonValidatorModel<O> model = this.getModel();
        NuitonValidatorScope[] scopes = model.getScopes().toArray(new NuitonValidatorScope[model.getScopes().size()]);
        this.rebuildDelegateValidator(model.getType(), context, scopes);
        this.firePropertyChange(CONTEXT_PROPERTY, oldContext, context);
    }

    public Set<NuitonValidatorScope> getScopes() {
        return this.getModel().getScopes();
    }

    public Set<NuitonValidatorScope> getEffectiveScopes() {
        return this.getDelegate().getEffectiveScopes();
    }

    public Set<String> getEffectiveFields() {
        return this.getDelegate().getEffectiveFields();
    }

    public Set<String> getEffectiveFields(NuitonValidatorScope scope) {
        return this.getDelegate().getEffectiveFields(scope);
    }

    public void setScopes(NuitonValidatorScope ... scopes) {
        Set<NuitonValidatorScope> oldScopes = this.getScopes();
        this.rebuildDelegateValidator(this.getModel().getType(), this.getModel().getContext(), scopes);
        this.firePropertyChange(SCOPES_PROPERTY, oldScopes, scopes);
    }

    public abstract void doValidate();

    public abstract boolean hasFatalErrors();

    public abstract boolean hasErrors();

    public abstract boolean hasWarnings();

    public abstract boolean hasInfos();

    public abstract boolean isValid(String var1);

    public abstract NuitonValidatorScope getHighestScope(String var1);

    public abstract <T> T convert(O var1, String var2, String var3, Class<T> var4);

    protected abstract void doValidate(O var1);

    protected abstract NuitonValidator<O> getDelegate();

    protected abstract void rebuildDelegateValidator(Class<O> var1, String var2, NuitonValidatorScope ... var3);

    public Class<O> getType() {
        return this.getModel().getType();
    }

    public boolean containsField(String fieldName) {
        Set<String> effectiveFields = this.getDelegate().getEffectiveFields();
        boolean result = effectiveFields.contains(fieldName);
        return result;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected NuitonValidatorModel<O> getModel() {
        return this.getDelegate().getModel();
    }
}

