/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import com.twelvemonkeys.io.FileUtil;
import com.twelvemonkeys.lang.StringUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;

public final class ReaderFileSuffixFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private final String description;
    private final Map<String, Boolean> knownSuffixes = new HashMap<String, Boolean>(32);

    public ReaderFileSuffixFilter() {
        this("Images (all supported input formats)");
    }

    public ReaderFileSuffixFilter(String string) {
        this.description = string;
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String string = FileUtil.getExtension((File)file);
        return !StringUtil.isEmpty((String)string) && this.hasReaderForSuffix(string);
    }

    private boolean hasReaderForSuffix(String string) {
        if (this.knownSuffixes.get(string) == Boolean.TRUE) {
            return true;
        }
        try {
            Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix(string);
            if (iterator.hasNext()) {
                this.knownSuffixes.put(string, Boolean.TRUE);
                return true;
            }
            this.knownSuffixes.put(string, Boolean.FALSE);
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public String getDescription() {
        return this.description;
    }
}

