/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.demande;

import com.franciaflex.faxtomail.persistence.entities.Configuration;
import com.franciaflex.faxtomail.persistence.entities.MailAction;
import com.franciaflex.faxtomail.ui.swing.actions.ArchiveAction;
import com.franciaflex.faxtomail.ui.swing.actions.SaveAndOpenChooseAttachmentToPrintAction;
import com.franciaflex.faxtomail.ui.swing.actions.SaveAndOpenMailFolderChooserAction;
import com.franciaflex.faxtomail.ui.swing.actions.SaveAndOpenReplyFormAction;
import com.franciaflex.faxtomail.ui.swing.actions.SaveAndOpenSearchToGroupAction;
import com.franciaflex.faxtomail.ui.swing.actions.SaveDemandeAndExitAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandesUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandesUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandsListener;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailUIHandler;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import jaxx.runtime.validator.swing.SwingValidator;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;
import org.nuiton.jaxx.application.swing.tab.CustomTab;
import org.nuiton.jaxx.application.swing.tab.TabContainerHandler;
import org.nuiton.jaxx.application.swing.tab.TabContentModel;
import org.nuiton.jaxx.application.swing.tab.TabHandler;
import org.nuiton.jaxx.application.swing.util.CloseableUI;

public class DemandesUIHandler
extends AbstractFaxToMailUIHandler<DemandesUIModel, DemandesUI>
implements TabContainerHandler,
CloseableUI {
    protected Configuration config;
    protected final PropertyChangeListener demandEnabledAndValidListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("valid") || evt.getPropertyName().equals("editable") || evt.getPropertyName().equals("archiveDate")) {
                DemandesUI ui = (DemandesUI)DemandesUIHandler.this.getUI();
                ui.processDataBinding("archiveButton.enabled");
                ui.processDataBinding("groupButton.enabled");
                ui.processDataBinding("replyButton.enabled");
                ui.processDataBinding("saveButton.enabled");
                ui.processDataBinding("transmitButton.enabled");
            }
            if (evt.getPropertyName().equals("valid") || evt.getPropertyName().equals("editable") || evt.getPropertyName().equals("waitingState")) {
                DemandesUIHandler.this.updateButtonEnability();
            }
        }
    };

    public void beforeInit(DemandesUI ui) {
        super.beforeInit((ApplicationUI)ui);
        DemandeUIModel currentEmail = this.getContext().getCurrentEmail();
        currentEmail.setCloseable(false);
        DemandesUIModel model = new DemandesUIModel();
        this.config = this.getContext().newServiceContext().getConfigurationService().getConfiguration();
        ((DemandesUI)this.ui).setContextValue(model);
    }

    public void afterInit(DemandesUI demandesUI) {
        this.initUI((DemandesUI)this.ui);
        DemandesUIModel model = (DemandesUIModel)((Object)this.getModel());
        final PropertyChangeListener demandEnabledAndValidListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("valid") || evt.getPropertyName().equals("editable") || evt.getPropertyName().equals("archiveDate")) {
                    DemandesUI ui = (DemandesUI)DemandesUIHandler.this.getUI();
                    ui.processDataBinding("archiveButton.enabled");
                    ui.processDataBinding("groupButton.enabled");
                    ui.processDataBinding("replyButton.enabled");
                    ui.processDataBinding("saveButton.enabled");
                    ui.processDataBinding("transmitButton.enabled");
                }
                if (evt.getPropertyName().equals("valid") || evt.getPropertyName().equals("editable") || evt.getPropertyName().equals("waitingState")) {
                    DemandesUIHandler.this.updateButtonEnability();
                }
            }
        };
        model.addDemandsListener(new DemandsListener(){

            @Override
            public void onDemandAdded(DemandeUIModel demand, int index, boolean added) {
                JTabbedPane tabPanel = DemandesUIHandler.this.getTabPanel();
                if (added) {
                    DemandeUI demandeUI = new DemandeUI((FaxToMailUI)DemandesUIHandler.this.getUI(), demand);
                    demandeUI.setName("demandPanel" + index);
                    DemandesUIHandler.this.getContext().getSwingSession().add((Component)demandeUI, true);
                    demand.addPropertyChangeListener(demandEnabledAndValidListener);
                    tabPanel.add(demandeUI);
                    DemandesUIHandler.this.setCustomTab(index, demand);
                }
                tabPanel.setSelectedIndex(index);
            }

            @Override
            public void onDemandRemoved(DemandeUIModel demand, int index) {
                demand.removePropertyChangeListener(demandEnabledAndValidListener);
            }
        });
        DemandeUIModel currentEmail = this.getContext().getCurrentEmail();
        model.addDemand(currentEmail);
    }

    protected void updateButtonEnability() {
        DemandeUIModel model = ((DemandesUIModel)((Object)this.getModel())).getCurrentDemand();
        boolean editable = model.isEditable();
        boolean archived = model.getArchiveDate() != null;
        boolean transmitEnabled = editable && this.isActionEnabled(model, MailAction.TRANSMIT, this.config);
        ((DemandesUIModel)((Object)this.getModel())).setTransmitEnabled(transmitEnabled);
        boolean archiveEnabled = editable && this.isActionEnabled(model, MailAction.ARCHIVE, this.config);
        ((DemandesUIModel)((Object)this.getModel())).setArchiveEnabled(archiveEnabled);
        boolean groupEnabled = this.isActionEnabled(model, MailAction.GROUP, this.config);
        ((DemandesUIModel)((Object)this.getModel())).setGroupEnabled(groupEnabled);
        boolean printEnabled = this.isActionEnabled(model, MailAction.PRINT, this.config);
        ((DemandesUIModel)((Object)this.getModel())).setPrintEnabled(printEnabled);
        boolean replyEnabled = (editable || archived) && this.isActionEnabled(model, MailAction.REPLY, this.config);
        ((DemandesUIModel)((Object)this.getModel())).setReplyEnabled(replyEnabled);
    }

    public boolean quitUI() {
        this.closeButtonPopups();
        this.getContext().closeSecondaryFrame();
        JTabbedPane tabPanel = this.getTabPanel();
        int tabCount = tabPanel.getTabCount();
        boolean quit = true;
        int i = 0;
        while (quit && i < tabCount) {
            tabPanel.setSelectedIndex(i);
            DemandeUIHandler tabHandler = (DemandeUIHandler)this.getTabHandler(i++);
            quit = tabHandler.quitUI();
        }
        return quit;
    }

    public void onCloseUI() {
        int tabCount = this.getTabPanel().getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            DemandeUIHandler tabHandler = (DemandeUIHandler)this.getTabHandler(i);
            ((DemandeUIModel)tabHandler.getModel()).removePropertyChangeListener(this.demandEnabledAndValidListener);
            tabHandler.onCloseUI();
        }
        ((DemandesUI)this.ui).getDemandGroupButton().onCloseUI();
    }

    public SwingValidator<DemandesUIModel> getValidator() {
        return null;
    }

    protected JComponent getComponentToFocus() {
        return null;
    }

    public TabHandler getTabHandler(int index) {
        ApplicationUI faxToMailTab;
        AbstractApplicationUIHandler handler;
        Component tab;
        TabHandler tabHandler = null;
        JTabbedPane tabPanel = this.getTabPanel();
        if (index >= 0 && index < tabPanel.getTabCount() && ApplicationUI.class.isInstance(tab = tabPanel.getComponentAt(index)) && TabHandler.class.isInstance(handler = (faxToMailTab = (ApplicationUI)tabPanel.getComponentAt(index)).getHandler())) {
            tabHandler = (TabHandler)handler;
        }
        return tabHandler;
    }

    public void setCustomTab(int index, TabContentModel model) {
        JTabbedPane tabPanel = this.getTabPanel();
        tabPanel.setTabComponentAt(index, (Component)new CustomTab(model, (TabContainerHandler)this));
    }

    public boolean removeTab(int i) {
        TabHandler tabHandler = this.getTabHandler(i);
        boolean remove = tabHandler.onRemoveTab();
        if (remove) {
            this.getTabPanel().removeTabAt(i);
            ((DemandesUIModel)((Object)this.getModel())).removeDemand(i);
        }
        return remove;
    }

    protected void initUI(DemandesUI ui) {
        super.initUI((ApplicationUI)ui);
        this.init();
    }

    public JTabbedPane getTabPanel() {
        return ((DemandesUI)this.getUI()).getDemandsTabPane();
    }

    public void init() {
        this.getTabPanel().setModel(new DefaultSingleSelectionModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void setSelectedIndex(int index) {
                int currentIndex = DemandesUIHandler.this.getTabPanel().getSelectedIndex();
                boolean mustChangeTab = DemandesUIHandler.this.onTabChanged(currentIndex, index);
                if (mustChangeTab) {
                    super.setSelectedIndex(index);
                }
                DemandesUIHandler.this.updateButtonEnability();
            }
        });
    }

    public boolean onTabChanged(int currentIndex, int newIndex) {
        boolean change = true;
        if (currentIndex != newIndex) {
            TabHandler handler = this.getTabHandler(currentIndex);
            if (handler != null) {
                change = handler.onHideTab(currentIndex, newIndex);
            }
            if ((handler = this.getTabHandler(newIndex)) != null) {
                handler.onShowTab(currentIndex, newIndex);
            }
        }
        if (change) {
            ((DemandesUIModel)((Object)this.getModel())).setCurrentIndex(newIndex);
            this.getContext().setCurrentEmail(((DemandesUIModel)((Object)this.getModel())).getCurrentDemand());
        }
        return change;
    }

    protected void closeButtonPopups() {
        ((DemandesUI)this.getUI()).getDemandGroupHighlightDialog().setVisible(false);
        DemandeUI demandeUI = (DemandeUI)this.getTabPanel().getSelectedComponent();
        demandeUI.getHandler().closeButtonPopups();
        ((DemandesUI)this.getUI()).getDemandGroupButton().setSelected(false);
    }

    public void save() {
        this.closeButtonPopups();
        this.getContext().closeSecondaryFrame();
        DemandeUI demandeUI = (DemandeUI)this.getTabPanel().getSelectedComponent();
        SaveDemandeAndExitAction action = new SaveDemandeAndExitAction(demandeUI.getHandler());
        action.setTakeIfNotTaken(true);
        this.getContext().getActionEngine().runAction((AbstractApplicationAction)action);
    }

    public void transmitDemande() {
        this.closeButtonPopups();
        this.runAction(SaveAndOpenMailFolderChooserAction.class);
    }

    public void print() {
        this.closeButtonPopups();
        this.runAction(SaveAndOpenChooseAttachmentToPrintAction.class);
    }

    public void archive() {
        this.closeButtonPopups();
        DemandeUI demandeUI = (DemandeUI)this.getTabPanel().getSelectedComponent();
        ArchiveAction action = new ArchiveAction(demandeUI.getHandler());
        this.getContext().getActionEngine().runAction((AbstractApplicationAction)action);
    }

    public void reply() {
        this.closeButtonPopups();
        this.runAction(SaveAndOpenReplyFormAction.class);
    }

    public void group() {
        this.closeButtonPopups();
        this.runAction(SaveAndOpenSearchToGroupAction.class);
    }

    public DemandeUIHandler getCurrentDemandHandler() {
        DemandeUI demandeUI = (DemandeUI)this.getTabPanel().getSelectedComponent();
        return demandeUI.getHandler();
    }

    public void runAction(Class<? extends AbstractApplicationAction> actionClass) {
        AbstractApplicationAction action = this.getContext().getActionFactory().createLogicAction((AbstractApplicationUIHandler)this, actionClass);
        this.getContext().getActionEngine().runAction(action);
    }

    public void showDemandGroupHighlightDialog() {
        if (((DemandesUIModel)((Object)this.getModel())).getCurrentDemand().getGroupedDemandes().size() > 1) {
            ((DemandesUI)this.getUI()).getDemandGroupHighlightDialog().setVisible(true);
        }
    }
}

