/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import org.jdesktop.swingx.JXFindPanel;
import org.jdesktop.swingx.search.Searchable;

public class JXFindBar
extends JXFindPanel {
    protected Color previousBackgroundColor;
    protected Color previousForegroundColor;
    protected Color notFoundBackgroundColor = Color.decode("#FF6666");
    protected Color notFoundForegroundColor = Color.white;
    protected JButton findNext;
    protected JButton findPrevious;

    public JXFindBar() {
        this((Searchable)null);
    }

    public JXFindBar(Searchable searchable) {
        super(searchable);
        this.getPatternModel().setIncremental(true);
        this.getPatternModel().setWrapping(true);
    }

    @Override
    public void setSearchable(Searchable searchable) {
        super.setSearchable(searchable);
        this.match();
    }

    @Override
    protected void showNotFoundMessage() {
        if (this.searchField == null) {
            return;
        }
        this.searchField.setForeground(this.notFoundForegroundColor);
        this.searchField.setBackground(this.notFoundBackgroundColor);
    }

    @Override
    protected void showFoundMessage() {
        if (this.searchField == null) {
            return;
        }
        this.searchField.setBackground(this.previousBackgroundColor);
        this.searchField.setForeground(this.previousForegroundColor);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.previousBackgroundColor == null) {
            this.previousBackgroundColor = this.searchField.getBackground();
            this.previousForegroundColor = this.searchField.getForeground();
        } else {
            this.searchField.setBackground(this.previousBackgroundColor);
            this.searchField.setForeground(this.previousForegroundColor);
        }
    }

    public void cancel() {
    }

    @Override
    protected void initExecutables() {
        this.getActionMap().put("close", (Action)this.createBoundAction("close", "cancel"));
        super.initExecutables();
    }

    @Override
    protected void bind() {
        super.bind();
        this.searchField.addActionListener((ActionListener)this.getAction("execute"));
        this.findNext.setAction((Action)this.getAction("findNext"));
        this.findPrevious.setAction((Action)this.getAction("findPrevious"));
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        this.getInputMap(1).put(stroke, "close");
    }

    @Override
    protected void build() {
        this.setLayout(new FlowLayout(10));
        this.add(this.searchLabel);
        this.add(new JLabel(":"));
        this.add(new JLabel("  "));
        this.add(this.searchField);
        this.add(this.findNext);
        this.add(this.findPrevious);
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.findNext = new JButton();
        this.findPrevious = new JButton();
    }
}

