/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.pdfeditor;

import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.HistoryType;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.ui.swing.actions.GenerateAnnotatedAttachmentAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorCrossUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorHighlighterUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorLineUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorNoteUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorUIModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailUIHandler;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import com.franciaflex.faxtomail.ui.swing.util.JImagePanel;
import com.itextpdf.text.DocumentException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import jaxx.runtime.swing.ComponentMover;
import jaxx.runtime.swing.ComponentResizer;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;
import org.nuiton.jaxx.application.swing.util.Cancelable;
import org.nuiton.jaxx.application.swing.util.CloseableUI;

public class PDFEditorUIHandler
extends AbstractFaxToMailUIHandler<PDFEditorUIModel, PDFEditorUI>
implements CloseableUI,
Cancelable {
    private static final Log log = LogFactory.getLog(PDFEditorUIHandler.class);
    protected ComponentMover cm = new ComponentMover();
    protected ComponentResizer cr = new ComponentResizer();
    protected PDDocument pdDocument;

    public void afterInit(PDFEditorUI pdfEditorUI) {
        this.initUI(pdfEditorUI);
        this.cm.setDragInsets(this.cr.getDragInsets());
        this.cm.setEdgeInsets(new Insets(0, 0, 0, 0));
        final PDFEditorUIModel model = (PDFEditorUIModel)((Object)this.getModel());
        JAXXButtonGroup actionGroup = ((PDFEditorUI)this.ui).getActionGroup();
        actionGroup.addPropertyChangeListener("selectedValue", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String value = (String)evt.getNewValue();
                model.setSelectedComponent(PDFEditorUIModel.EditionComponent.valueOf(value));
            }
        });
        String value = (String)actionGroup.getSelectedValue();
        model.setSelectedComponent(PDFEditorUIModel.EditionComponent.valueOf(value));
        ((PDFEditorUI)this.ui).getContainer().addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Component child = e.getChild();
                PDFEditorUIModel.Page currentPage = model.getCurrentPage();
                if (child.getClass().isAssignableFrom(PDFEditorNoteUI.class)) {
                    currentPage.addNote((PDFEditorNoteUI)child);
                } else if (child.getClass().isAssignableFrom(PDFEditorCrossUI.class)) {
                    currentPage.addCross((PDFEditorCrossUI)child);
                } else if (child.getClass().isAssignableFrom(PDFEditorLineUI.class)) {
                    currentPage.addLine((PDFEditorLineUI)child);
                } else if (child.getClass().isAssignableFrom(PDFEditorHighlighterUI.class)) {
                    currentPage.addHighlighter((PDFEditorHighlighterUI)child);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Component child = e.getChild();
                PDFEditorUIModel.Page currentPage = model.getCurrentPage();
                if (child.getClass().isAssignableFrom(PDFEditorNoteUI.class)) {
                    currentPage.removeNote((PDFEditorNoteUI)child);
                } else if (child.getClass().isAssignableFrom(PDFEditorCrossUI.class)) {
                    currentPage.removeCross((PDFEditorCrossUI)child);
                } else if (child.getClass().isAssignableFrom(PDFEditorLineUI.class)) {
                    currentPage.removeLine((PDFEditorLineUI)child);
                } else if (child.getClass().isAssignableFrom(PDFEditorHighlighterUI.class)) {
                    currentPage.removeHighlighter((PDFEditorHighlighterUI)child);
                }
            }
        });
        model.addPropertyChangeListener("currentPageIndex", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Integer pageNb = (Integer)evt.getNewValue();
                Integer prevPageNb = (Integer)evt.getOldValue();
                PDFEditorUIHandler.this.updatePageNumber(pageNb, prevPageNb);
            }
        });
        model.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PDFEditorUIModel model;
                AttachmentFile attachmentFile;
                if (("originalFile".equals(evt.getPropertyName()) || "editedFile".equals(evt.getPropertyName())) && (attachmentFile = (model = (PDFEditorUIModel)((Object)evt.getSource())).getNotNullFile()) != null) {
                    File file = attachmentFile.getFile();
                    if (!FaxToMailUIUtil.isFileAPDF(attachmentFile)) {
                        try {
                            file = PDFEditorUIHandler.this.convertFileToPdf(attachmentFile);
                        }
                        catch (IOException e) {
                            if (log.isErrorEnabled()) {
                                log.error((Object)"error while converting file to pdf", (Throwable)e);
                            }
                            PDFEditorUIHandler.this.getContext().getErrorHelper().showErrorDialog(I18n.t((String)"faxtomail.pdfEditor.convertToPdf.error", (Object[])new Object[0]));
                        }
                        catch (DocumentException e) {
                            if (log.isErrorEnabled()) {
                                log.error((Object)"error while converting file to pdf", (Throwable)e);
                            }
                            PDFEditorUIHandler.this.getContext().getErrorHelper().showErrorDialog(I18n.t((String)"faxtomail.pdfEditor.convertToPdf.error", (Object[])new Object[0]));
                        }
                    }
                    if (FaxToMailUIUtil.isFileAPDF(attachmentFile)) {
                        try {
                            PDFEditorUIHandler.this.pdDocument = PDDocument.load((File)file);
                            model.setPageNumber(PDFEditorUIHandler.this.pdDocument.getNumberOfPages());
                            model.setCurrentPageIndex(1);
                        }
                        catch (IOException e) {
                            if (log.isErrorEnabled()) {
                                log.error((Object)"error while converting file to pdf", (Throwable)e);
                            }
                            PDFEditorUIHandler.this.getContext().getErrorHelper().showErrorDialog(I18n.t((String)"faxtomail.pdfEditor.readPdf.error", (Object[])new Object[0]));
                        }
                    }
                    ((PDFEditorUI)PDFEditorUIHandler.this.getUI()).setCursor(Cursor.getDefaultCursor());
                    model.firePropertyChanged("currentPageIndex", null, 1);
                }
            }
        });
        model.addPropertyChangeListener("zoom", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PDFEditorUIHandler.this.displayPage(model.getCurrentPageIndex(), ((Float)evt.getOldValue()).floatValue(), model.getRotation());
            }
        });
        model.addPropertyChangeListener("rotation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PDFEditorUIHandler.this.displayPage(model.getCurrentPageIndex(), model.getZoom(), (Integer)evt.getOldValue());
            }
        });
    }

    protected JComponent getComponentToFocus() {
        return null;
    }

    public SwingValidator<PDFEditorUIModel> getValidator() {
        return null;
    }

    public boolean quitUI() {
        boolean result = this.quitScreen2(true, ((PDFEditorUIModel)((Object)this.getModel())).isModify(), null, I18n.t((String)"faxtomail.pdfEditor.askSaveBeforeLeaving.save", (Object[])new Object[0]), this.getContext().getActionFactory().createLogicAction((AbstractApplicationUIHandler)this, GenerateAnnotatedAttachmentAction.class));
        return result;
    }

    @Override
    public Component getTopestUI() {
        return (Component)this.getUI();
    }

    public void onCloseUI() {
        IOUtils.closeQuietly((Closeable)this.pdDocument);
    }

    public void addEditionComponent(MouseEvent event) {
        PDFEditorUIModel.EditionComponent editionComponent = ((PDFEditorUIModel)((Object)this.getModel())).getSelectedComponent();
        switch (editionComponent) {
            case NOTE: {
                this.addNote(event.getX(), event.getY());
                break;
            }
            case CROSS: {
                this.addCross(event.getX(), event.getY());
                break;
            }
            case HLINE: {
                this.addHLine(event.getX(), event.getY());
                break;
            }
            case VLINE: {
                this.addVLine(event.getX(), event.getY());
                break;
            }
            case HIGHLIGHTER: {
                this.addHighlighter(event.getX(), event.getY());
            }
        }
    }

    public void addNote(int x, int y) {
        PDFEditorNoteUI note = new PDFEditorNoteUI();
        note.setZoom(Float.valueOf(((PDFEditorUIModel)((Object)this.getModel())).getZoom()));
        String title = this.decorate(new Date()) + " - " + this.getContext().getCurrentUser().getTrigraph();
        note.setTitle(title);
        this.addPanel(note, x, y);
    }

    public void addCross(int x, int y) {
        PDFEditorCrossUI cross = new PDFEditorCrossUI();
        this.addPanel(cross, x, y);
        this.cr.registerComponent(new Component[]{cross});
    }

    public void addHLine(int x, int y) {
        PDFEditorLineUI line = new PDFEditorLineUI();
        line.setHorizontal(true);
        this.addPanel(line, x, y);
        this.cr.registerComponent("horizontal", new Component[]{line});
    }

    public void addVLine(int x, int y) {
        PDFEditorLineUI line = new PDFEditorLineUI();
        line.setHorizontal(false);
        this.addPanel(line, x, y);
        this.cr.registerComponent("vertical", new Component[]{line});
    }

    public void addHighlighter(int x, int y) {
        PDFEditorHighlighterUI highlighter = new PDFEditorHighlighterUI();
        this.addPanel(highlighter, x, y);
        this.cr.registerComponent(new Component[]{highlighter});
    }

    protected void addPanel(JPanel panel, int x, int y) {
        JPanel container = ((PDFEditorUI)this.ui).getContainer();
        container.add((Component)panel, 0);
        Insets insets = container.getInsets();
        Dimension size = panel.getPreferredSize();
        panel.setBounds(x + insets.left, y + insets.top, size.width, size.height);
        container.updateUI();
        this.cm.registerComponent(new Component[]{panel});
    }

    protected void updatePageNumber(Integer pageNb, Integer prevPageNb) {
        if (pageNb != null) {
            if (prevPageNb != null) {
                PDFEditorUIModel.Page p = ((PDFEditorUIModel)((Object)this.getModel())).getPage(prevPageNb);
                for (JPanel jPanel : p.getNotes()) {
                    jPanel.setVisible(false);
                }
                for (JPanel jPanel : p.getCrosses()) {
                    jPanel.setVisible(false);
                }
                for (JPanel jPanel : p.getLines()) {
                    jPanel.setVisible(false);
                }
                for (JPanel jPanel : p.getHighlighters()) {
                    jPanel.setVisible(false);
                }
            }
            this.displayPage(pageNb, ((PDFEditorUIModel)((Object)this.getModel())).getZoom(), ((PDFEditorUIModel)((Object)this.getModel())).getRotation());
        }
    }

    protected void displayPage(int pageNb, float previousZoom, int previousRotation) {
        if (pageNb < 1 || pageNb > this.pdDocument.getNumberOfPages()) {
            return;
        }
        PDFRenderer renderer = new PDFRenderer(this.pdDocument);
        float zoom = ((PDFEditorUIModel)((Object)this.getModel())).getZoom();
        int rotation = ((PDFEditorUIModel)((Object)this.getModel())).getRotation();
        try {
            BufferedImage image = renderer.renderImage(pageNb - 1, zoom);
            int width = image.getWidth();
            int height = image.getHeight();
            JPanel container = ((PDFEditorUI)this.getUI()).getContainer();
            Dimension containerSize = new Dimension(rotation % 180 == 0 ? width : height, rotation % 180 == 0 ? height : width);
            container.setPreferredSize(containerSize);
            container.setMinimumSize(containerSize);
            container.setMaximumSize(containerSize);
            container.setSize(containerSize);
            JImagePanel documentPanel = ((PDFEditorUI)this.ui).getDocumentPanel();
            documentPanel.setRotation(rotation);
            documentPanel.setImage(image);
            Insets insets = container.getInsets();
            Rectangle rect = container.getBounds();
            float zoomRatio = zoom / previousZoom;
            int rotationDiff = rotation - previousRotation;
            PDFEditorUIModel.Page p = ((PDFEditorUIModel)((Object)this.getModel())).getPage(pageNb);
            for (PDFEditorNoteUI panel : p.getNotes()) {
                int y;
                int x;
                panel.setVisible(true);
                panel.setZoom(Float.valueOf(zoom));
                Rectangle bounds = panel.getBounds();
                if (rotationDiff == 0) {
                    x = bounds.x;
                    y = bounds.y;
                } else if (rotationDiff == 90 || rotationDiff == -270) {
                    x = rect.width - bounds.height / 2 - bounds.width / 2 - bounds.y;
                    y = bounds.x + bounds.width / 2 - bounds.height / 2;
                } else {
                    x = bounds.y + bounds.height / 2 - bounds.width / 2;
                    y = rect.height - bounds.height / 2 - bounds.width / 2 - bounds.x;
                }
                panel.setBounds((int)(zoomRatio * (float)x) + insets.left, (int)(zoomRatio * (float)y) + insets.top, (int)(zoomRatio * (float)bounds.width), (int)(zoomRatio * (float)bounds.height));
            }
            boolean orientation180 = Math.abs(rotationDiff) % 180 == 0;
            for (PDFEditorCrossUI panel : p.getCrosses()) {
                int y;
                int x;
                int newHeight;
                panel.setVisible(true);
                Rectangle bounds = panel.getBounds();
                int newWidth = orientation180 ? bounds.width : bounds.height;
                int n = newHeight = orientation180 ? bounds.height : bounds.width;
                if (rotationDiff == 0) {
                    x = bounds.x;
                    y = bounds.y;
                } else if (rotationDiff == 90 || rotationDiff == -270) {
                    x = rect.width - newWidth - bounds.y;
                    y = bounds.x;
                } else {
                    x = bounds.y;
                    y = rect.height - newHeight - bounds.x;
                }
                panel.setBounds((int)(zoomRatio * (float)x) + insets.left, (int)(zoomRatio * (float)y) + insets.top, (int)(zoomRatio * (float)newWidth), (int)(zoomRatio * (float)newHeight));
            }
            List<PDFEditorLineUI> lines = p.getLines();
            this.cr.deregisterComponent((Component[])lines.toArray(new PDFEditorLineUI[lines.size()]));
            for (PDFEditorLineUI panel : lines) {
                int y;
                int x;
                int newHeight;
                panel.setVisible(true);
                Rectangle bounds = panel.getBounds();
                boolean horizontal = panel.isHorizontal();
                panel.setHorizontal(orientation180 ? horizontal : !horizontal);
                int newWidth = orientation180 ? bounds.width : bounds.height;
                int n = newHeight = orientation180 ? bounds.height : bounds.width;
                if (rotationDiff == 0) {
                    x = bounds.x;
                    y = bounds.y;
                } else if (rotationDiff == 90 || rotationDiff == -270) {
                    x = rect.width - newWidth - bounds.y;
                    y = bounds.x;
                } else {
                    x = bounds.y;
                    y = rect.height - newHeight - bounds.x;
                }
                panel.setBounds((int)(zoomRatio * (float)x) + insets.left, (int)(zoomRatio * (float)y) + insets.top, (int)(zoomRatio * (float)newWidth), (int)(zoomRatio * (float)newHeight));
                this.cr.registerComponent(panel.isHorizontal() != false ? "horizontal" : "vertical", new Component[]{panel});
            }
            for (PDFEditorHighlighterUI panel : p.getHighlighters()) {
                int y;
                int x;
                int newHeight;
                panel.setVisible(true);
                Rectangle bounds = panel.getBounds();
                int newWidth = orientation180 ? bounds.width : bounds.height;
                int n = newHeight = orientation180 ? bounds.height : bounds.width;
                if (rotationDiff == 0) {
                    x = bounds.x;
                    y = bounds.y;
                } else if (rotationDiff == 90 || rotationDiff == -270) {
                    x = rect.width - newWidth - bounds.y;
                    y = bounds.x;
                } else {
                    x = bounds.y;
                    y = rect.height - newHeight - bounds.x;
                }
                panel.setBounds((int)(zoomRatio * (float)x) + insets.left, (int)(zoomRatio * (float)y) + insets.top, (int)(zoomRatio * (float)newWidth), (int)(zoomRatio * (float)newHeight));
            }
            container.updateUI();
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"error while displaying pdf", (Throwable)e);
            }
            this.getContext().getErrorHelper().showErrorDialog(I18n.t((String)"faxtomail.pdfEditor.readPdf.error", (Object[])new Object[0]));
        }
    }

    public File convertFileToPdf(AttachmentFile attachmentFile) throws IOException, DocumentException {
        File target = FaxToMailUIUtil.convertFileToPdf(attachmentFile);
        FaxToMailServiceContext serviceContext = this.getContext().newServiceContext();
        AttachmentFile attachmentFileNew = serviceContext.getEmailService().getAttachmentFileFromStream((InputStream)new FileInputStream(target));
        attachmentFileNew.setFilename(attachmentFile.getFilename() + ".pdf");
        attachmentFileNew.setRotation(0);
        ((PDFEditorUIModel)((Object)this.getModel())).setEditedFile(attachmentFileNew);
        return target;
    }

    public void zoomOut() {
        PDFEditorUIModel model = (PDFEditorUIModel)((Object)this.getModel());
        float zoom = model.getZoom();
        model.setZoom(zoom - 0.5f);
    }

    public void zoomIn() {
        PDFEditorUIModel model = (PDFEditorUIModel)((Object)this.getModel());
        float zoom = model.getZoom();
        model.setZoom(zoom + 0.5f);
    }

    public void rotateClockwise() {
        int rotation = ((PDFEditorUIModel)((Object)this.getModel())).getRotation();
        ((PDFEditorUIModel)((Object)this.getModel())).setRotation((360 + rotation + 90) % 360);
    }

    public void rotateAntiClockwise() {
        int rotation = ((PDFEditorUIModel)((Object)this.getModel())).getRotation();
        ((PDFEditorUIModel)((Object)this.getModel())).setRotation((360 + rotation - 90) % 360);
    }

    public void print() {
        PDFEditorUIModel model = (PDFEditorUIModel)((Object)this.getModel());
        AttachmentFile attachmentFile = model.getNotNullFile();
        boolean print = FaxToMailUIUtil.print(attachmentFile, false);
        if (print) {
            DemandeUIModel demand = model.getDemand();
            FaxToMailServiceContext serviceContext = this.getContext().newServiceContext();
            Email email = serviceContext.getEmailService().addToHistory(demand.getTopiaId(), HistoryType.PRINTING, this.getContext().getCurrentUser(), new Date(), new String[]{attachmentFile.getFilename()});
            demand.setHistory(email.getHistory());
        }
    }

    public void cancel() {
        this.closeFrame();
    }
}

