/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.demande.demandgroup;

import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import jaxx.runtime.SwingUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.nuiton.i18n.I18n;

public class DemandGroupCellRenderer
extends DefaultTableCellRenderer {
    public static final String TEXT_PATTERN = "<html><body>%s</body></html>";
    private static final long serialVersionUID = 1L;
    private final String noneText;

    public static DemandGroupCellRenderer newRender() {
        return new DemandGroupCellRenderer();
    }

    protected DemandGroupCellRenderer() {
        this.setHorizontalAlignment(0);
        this.setIcon(SwingUtil.createActionIcon((String)"group"));
        this.noneText = I18n.n((String)"faxtomail.demandGroup.empty", (Object[])new Object[0]);
    }

    @Override
    protected void setValue(Object value) {
    }

    @Override
    public JComponent getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String toolTipTextValue;
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        List demands = (List)value;
        if (CollectionUtils.isEmpty((Collection)demands)) {
            toolTipTextValue = "<i>" + I18n.t((String)this.noneText, (Object[])new Object[0]) + "</i>";
        } else {
            StringBuilder sb = new StringBuilder();
            for (DemandeUIModel demand : demands) {
                sb.append("<br/>").append(demand.getTitle());
            }
            toolTipTextValue = sb.substring(5);
        }
        String textValue = I18n.t((String)"faxtomail.demandGroupCellRenderer.text", (Object[])new Object[]{demands != null ? demands.size() : 0});
        boolean editable = table.isCellEditable(row, column);
        toolTipTextValue = String.format(TEXT_PATTERN, toolTipTextValue);
        this.setText(textValue);
        this.setToolTipText(toolTipTextValue);
        return this;
    }
}

