/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.services.service;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFileImpl;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFileTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.AttachmentImpl;
import com.franciaflex.faxtomail.persistence.entities.Client;
import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.EmailFilter;
import com.franciaflex.faxtomail.persistence.entities.EmailGroup;
import com.franciaflex.faxtomail.persistence.entities.EmailGroupTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.EmailTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.History;
import com.franciaflex.faxtomail.persistence.entities.HistoryTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.HistoryType;
import com.franciaflex.faxtomail.persistence.entities.MailField;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.RangeRow;
import com.franciaflex.faxtomail.persistence.entities.RangeRowTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.Reply;
import com.franciaflex.faxtomail.persistence.entities.ReplyTopiaDao;
import com.franciaflex.faxtomail.services.FaxToMailServiceSupport;
import com.franciaflex.faxtomail.services.service.InvalidClientException;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Authenticator;
import javax.mail.MessagingException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntities;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class EmailService
extends FaxToMailServiceSupport {
    private static final Log log = LogFactory.getLog(EmailService.class);
    protected Binder<Attachment, Attachment> attachmentBinder = BinderFactory.newBinder(Attachment.class, Attachment.class);

    public Email getEmailById(String id) {
        Email email = (Email)this.getPersistenceContext().getEmailDao().findByTopiaId(id);
        return email;
    }

    public Email saveEmail(Email email, FaxToMailUser user, String ... modifiedFields) throws InvalidClientException {
        Client client = email.getClient();
        return this.saveEmail(email, null, client != null ? client.getCode() : null, user, modifiedFields);
    }

    public Email saveEmail(Email email, Collection<Attachment> attachments, String clientCode, FaxToMailUser user, String ... modifiedFields) throws InvalidClientException {
        History history;
        History transmissionToEdi;
        Date now = this.getNow();
        EmailTopiaDao dao = this.getPersistenceContext().getEmailDao();
        HistoryTopiaDao historyDao = this.getPersistenceContext().getHistoryDao();
        Client client = null;
        if (StringUtils.isNotBlank((CharSequence)clientCode) && (client = this.getClientService().getClientForCode(clientCode)) == null) {
            String message = I18n.t((String)"faxtomail.service.email.save.clientCode.error", (Object[])new Object[]{clientCode});
            throw new InvalidClientException(message);
        }
        email.setClient(client);
        if (attachments != null) {
            Collection currentAttachments = CollectionUtils.emptyIfNull((Collection)email.getAttachment());
            HashMap currentAttachmentIndex = new HashMap(Maps.uniqueIndex((Iterable)currentAttachments, (Function)TopiaEntities.getTopiaIdFunction()));
            AttachmentFileTopiaDao attachementFileTopiaDao = this.getPersistenceContext().getAttachmentFileDao();
            for (Attachment attachment : attachments) {
                Object currentAttachment = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{attachment.getTopiaId()}) ? (Attachment)currentAttachmentIndex.remove(attachment.getTopiaId()) : new AttachmentImpl();
                this.attachmentBinder.copy((Object)attachment, currentAttachment, new String[0]);
                if (currentAttachment.getEditedFile() != null) {
                    if (!currentAttachment.getEditedFile().isPersisted()) {
                        attachementFileTopiaDao.create((TopiaEntity)currentAttachment.getEditedFile());
                    } else {
                        attachementFileTopiaDao.update((TopiaEntity)currentAttachment.getEditedFile());
                    }
                }
                if (currentAttachment.getOriginalFile() != null) {
                    if (!currentAttachment.getOriginalFile().isPersisted()) {
                        attachementFileTopiaDao.create((TopiaEntity)currentAttachment.getOriginalFile());
                    } else {
                        attachementFileTopiaDao.update((TopiaEntity)currentAttachment.getOriginalFile());
                    }
                }
                if (attachment.isPersisted()) continue;
                email.addAttachment((Attachment)currentAttachment);
            }
            for (Attachment attachment : currentAttachmentIndex.values()) {
                email.removeAttachment(attachment);
            }
        }
        if (email.getRangeRow() != null) {
            RangeRowTopiaDao rangeRowDao = this.getPersistenceContext().getRangeRowDao();
            for (RangeRow rangeRow : email.getRangeRow()) {
                if (!rangeRow.isPersisted()) {
                    rangeRowDao.create((TopiaEntity)rangeRow);
                    continue;
                }
                rangeRowDao.update((TopiaEntity)rangeRow);
            }
        }
        if (!email.isPersisted()) {
            if (email.getHistory() != null) {
                historyDao.createAll((Iterable)email.getHistory());
            }
            email = (Email)dao.create((TopiaEntity)email);
        }
        HashSet fieldSet = Sets.newHashSet((Object[])modifiedFields);
        if (StringUtils.isNotBlank((CharSequence)email.getMailFolder().getEdiFolder()) && (transmissionToEdi = (History)CollectionUtils.find((Iterable)email.getHistory(), (Predicate)new Predicate<History>(){

            public boolean evaluate(History object) {
                return object.getType() == HistoryType.TRANSMISSION_TO_EDI;
            }
        })) == null && email.getClient() != null && email.getDemandType() != null && StringUtils.isNotBlank((CharSequence)email.getProjectReference()) && (!email.getDemandType().containsFields(MailField.RANGE_ROW) || CollectionUtils.isNotEmpty((Collection)email.getRangeRow()))) {
            email.setDemandStatus(DemandStatus.TRANSMITTED_TO_EDI);
            transmissionToEdi = (History)historyDao.create("type", (Object)HistoryType.TRANSMISSION_TO_EDI, new Object[]{"modificationDate", new Date()});
            email.addHistory(transmissionToEdi);
            fieldSet.add("demandStatus");
        }
        if (fieldSet.contains("archiveDate")) {
            history = (History)historyDao.create("type", (Object)HistoryType.ARCHIVED, new Object[]{"faxToMailUser", user, "modificationDate", now});
        } else if (fieldSet.contains("mailFolder")) {
            history = (History)historyDao.create("type", (Object)HistoryType.TRANSMISSION, new Object[]{"faxToMailUser", user, "modificationDate", now});
        } else {
            if (email.getTakenBy() == null && !fieldSet.isEmpty() && !fieldSet.contains("takenBy")) {
                email.setTakenBy(user);
                fieldSet.add("takenBy");
            }
            history = (History)historyDao.create("type", (Object)(email.isHistoryEmpty() ? HistoryType.CREATION : HistoryType.MODIFICATION), new Object[]{"faxToMailUser", user, "fields", fieldSet, "modificationDate", now});
        }
        email.addHistory(history);
        Email result = (Email)dao.update((TopiaEntity)email);
        this.getPersistenceContext().commit();
        return result;
    }

    public void transmitPendingDemandsToEdi() {
        EmailTopiaDao dao = this.getPersistenceContext().getEmailDao();
        List toTransmitToEdi = dao.forDemandStatusEquals(DemandStatus.TRANSMITTED_TO_EDI).findAll();
        for (Email email : toTransmitToEdi) {
            this.transmitDemandToEdi(email);
        }
    }

    protected void transmitDemandToEdi(Email email) {
        Preconditions.checkArgument((email.getDemandStatus() == DemandStatus.TRANSMITTED_TO_EDI ? 1 : 0) != 0);
        if (CollectionUtils.isEmpty((Collection)email.getRangeRow())) {
            return;
        }
        Date now = this.serviceContext.getNow();
        File ediDirectory = this.getApplicationConfig().getEdiDirectory();
        ediDirectory.mkdirs();
        String fileDate = DateFormatUtils.format((Date)now, (String)"yyMMddhhmmss");
        for (RangeRow rangeRow : email.getRangeRow()) {
            String fileName = "ORD_FAX_" + fileDate + "_" + rangeRow.getTopiaId() + ".txt";
            File ediFile = new File(ediDirectory, fileName);
            String separator = ";";
            try {
                BufferedWriter ediWriter = new BufferedWriter(new FileWriter(ediFile));
                Throwable throwable = null;
                try {
                    ediWriter.write("%BEGIN_ENTETE_QUOTE\n");
                    ediWriter.write("E" + separator);
                    ediWriter.write("OARFAX" + separator);
                    ediWriter.write(DateFormatUtils.format((Date)now, (String)"ddMMyy") + separator);
                    ediWriter.write(DateFormatUtils.format((Date)now, (String)"ddMMyy") + separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(Strings.nullToEmpty((String)email.getProjectReference()) + separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write("EUR" + separator);
                    ediWriter.write(separator);
                    ediWriter.write(email.getDemandType().getLabel() + separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(email.getClient().getCode() + separator);
                    ediWriter.write(email.getClient().getCode() + separator);
                    ediWriter.write(rangeRow.getRange().getLabel() + separator);
                    ediWriter.write(rangeRow.getRange().getTopiaId() + "\n");
                    ediWriter.write("%END_ENTETE_QUOTE\n");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ediWriter == null) continue;
                    if (throwable != null) {
                        try {
                            ((Writer)ediWriter).close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    ((Writer)ediWriter).close();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Can't generate EDI file");
            }
        }
    }

    public List<Email> getEmailForFolder(MailFolder folder) {
        EmailTopiaDao dao = this.getPersistenceContext().getEmailDao();
        ArrayList<Email> result = new ArrayList<Email>(dao.forMailFolderEquals(folder).addNull("archiveDate").addNotEquals("demandStatus", (Object)DemandStatus.ARCHIVED).setOrderByArguments(new String[]{"receptionDate"}).findAll());
        return result;
    }

    public List<Email> getEmailForFolderAndSubfolders(MailFolder folder) {
        EmailTopiaDao dao = this.getPersistenceContext().getEmailDao();
        ArrayList<MailFolder> folders = new ArrayList<MailFolder>();
        folders.addAll(this.getChildrenRecursively(folder));
        return new ArrayList<Email>(dao.forMailFolderIn(folders).findAll());
    }

    protected List<MailFolder> getChildrenRecursively(MailFolder folder) {
        ArrayList<MailFolder> folders = new ArrayList<MailFolder>();
        folders.add(folder);
        Collection children = folder.getChildren();
        for (MailFolder child : children) {
            folders.addAll(this.getChildrenRecursively(child));
        }
        return folders;
    }

    public Email addToHistory(String emailId, HistoryType type, FaxToMailUser user, Date date, String ... fields) {
        EmailTopiaDao emailDao = this.getPersistenceContext().getEmailDao();
        Email email = (Email)emailDao.findByTopiaId(emailId);
        HistoryTopiaDao historyDao = this.getPersistenceContext().getHistoryDao();
        History history = (History)historyDao.create("type", (Object)type, new Object[]{"faxToMailUser", user, "fields", Sets.newHashSet((Object[])fields), "modificationDate", date});
        email.addHistory(history);
        email = (Email)emailDao.update((TopiaEntity)email);
        this.getPersistenceContext().commit();
        return email;
    }

    public Email takeEmail(String emailId, FaxToMailUser user) {
        EmailTopiaDao emailDao = this.getPersistenceContext().getEmailDao();
        Email email = (Email)emailDao.findByTopiaId(emailId);
        email.setTakenBy(user);
        HistoryTopiaDao historyDao = this.getPersistenceContext().getHistoryDao();
        History history = (History)historyDao.create("type", (Object)HistoryType.MODIFICATION, new Object[]{"faxToMailUser", user, "fields", Sets.newHashSet((Object[])new String[]{"takenBy"}), "modificationDate", new Date()});
        email.addHistory(history);
        email = (Email)emailDao.update((TopiaEntity)email);
        this.getPersistenceContext().commit();
        return email;
    }

    public List<Email> search(EmailFilter emailFilter) {
        EmailTopiaDao dao = this.getPersistenceContext().getEmailDao();
        List result = dao.search(emailFilter);
        return result;
    }

    public Email groupEmails(Email email1, Email email2, FaxToMailUser user) {
        EmailGroupTopiaDao groupDao = this.getPersistenceContext().getEmailGroupDao();
        EmailGroup group1 = email1.getEmailGroup();
        EmailGroup group2 = email2.getEmailGroup();
        if (group1 == null && group2 == null) {
            EmailGroup group = (EmailGroup)groupDao.create("email", (Object)Lists.newArrayList((Object[])new Email[]{email1, email2}), new Object[0]);
            email1.setEmailGroup(group);
            email2.setEmailGroup(group);
        } else if (group1 == null) {
            email1.setEmailGroup(group2);
            group2.addEmail(email1);
            groupDao.update((TopiaEntity)group2);
        } else if (group2 == null) {
            email2.setEmailGroup(group1);
            group1.addEmail(email2);
            groupDao.update((TopiaEntity)group1);
        } else {
            if (group1.equals(group2)) {
                return email1;
            }
            group1.addAllEmail(group2.getEmail());
            email2.setEmailGroup(group1);
            group2.clearEmail();
            groupDao.delete(group2);
            groupDao.update((TopiaEntity)group1);
        }
        EmailTopiaDao emailDao = this.getPersistenceContext().getEmailDao();
        HistoryTopiaDao historyDao = this.getPersistenceContext().getHistoryDao();
        Date now = new Date();
        email1.addHistory((History)historyDao.create("type", (Object)HistoryType.GROUP, new Object[]{"faxToMailUser", user, "fields", Sets.newHashSet((Object[])new String[]{email2.getObject()}), "modificationDate", now}));
        Email result = (Email)emailDao.update((TopiaEntity)email1);
        email2.addHistory((History)historyDao.create("type", (Object)HistoryType.GROUP, new Object[]{"faxToMailUser", user, "fields", Sets.newHashSet((Object[])new String[]{email1.getObject()}), "modificationDate", now}));
        emailDao.update((TopiaEntity)email2);
        this.getPersistenceContext().commit();
        return result;
    }

    public Email reply(String from, String to, String subject, String content, Collection<AttachmentFile> attachments, String originalEmailId, FaxToMailUser user) throws EmailException, MessagingException, IOException {
        Email email = this.getEmailById(originalEmailId);
        String smtpUser = this.getApplicationConfig().getSmtpUser();
        String password = this.getApplicationConfig().getSmtpPassword();
        boolean useSsl = this.getApplicationConfig().getSmtpUseSsl();
        MultiPartEmail message = new MultiPartEmail();
        message.setHostName(this.getApplicationConfig().getSmtpHost());
        message.setSmtpPort(this.getApplicationConfig().getSmtpPort());
        if (StringUtils.isNotBlank((CharSequence)smtpUser) && password != null) {
            message.setAuthenticator((Authenticator)new DefaultAuthenticator(smtpUser, password));
        }
        message.setSSLOnConnect(useSsl);
        message.setCharset("utf-8");
        message.setFrom(from);
        message.addTo(to);
        message.setSubject(subject);
        message.setMsg(content);
        for (AttachmentFile attachmentFile : attachments) {
            File file = attachmentFile.getFile();
            FileDataSource source = new FileDataSource(file);
            message.attach((DataSource)source, attachmentFile.getFilename(), null);
        }
        String emailId = message.send();
        ReplyTopiaDao replyTopiaDao = this.getPersistenceContext().getReplyDao();
        Date now = new Date();
        StringBuilder emailSource = new StringBuilder();
        Enumeration headerLines = message.getMimeMessage().getAllHeaderLines();
        while (headerLines.hasMoreElements()) {
            String headerLine = (String)headerLines.nextElement();
            emailSource.append(headerLine).append("\n");
        }
        emailSource.append("\n").append(IOUtils.toString((InputStream)message.getMimeMessage().getInputStream()));
        Reply reply = (Reply)replyTopiaDao.create("emailSource", (Object)emailSource.toString(), new Object[]{"sentDate", now, "subject", subject});
        email.addReplies(reply);
        HistoryTopiaDao historyDao = this.getPersistenceContext().getHistoryDao();
        History history = (History)historyDao.create("type", (Object)HistoryType.REPLY, new Object[]{"faxToMailUser", user, "modificationDate", now});
        email.addHistory(history);
        email = this.saveEmail(email, user, new String[0]);
        return email;
    }

    public AttachmentFile getAttachmentFileFromStream(InputStream contentStream) {
        AttachmentFileImpl attachmentFile = new AttachmentFileImpl();
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)contentStream, (OutputStream)output);
            attachmentFile.setContent(output.toByteArray());
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't save content", ex);
        }
        return attachmentFile;
    }
}

