/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class ImmutableSetRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`ImmutableSetRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with `ImmutableSet`s.\n[Source](https://error-prone.picnic.tech/refasterrules/ImmutableSetRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new ImmutableSetBuilderRecipe(), new IterableToImmutableSetRecipe(), new StreamToImmutableSetRecipe(), new ImmutableSetCopyOfSetViewRecipe(), new ImmutableSetOfRecipe(), new ImmutableSetOf1Recipe(), new ImmutableSetOf2Recipe(), new ImmutableSetOf3Recipe(), new ImmutableSetOf4Recipe(), new ImmutableSetOf5Recipe(), new SetsDifferenceRecipe(), new SetsDifferenceMapRecipe(), new SetsDifferenceMultimapRecipe(), new SetsIntersectionRecipe(), new SetsIntersectionMapRecipe(), new SetsIntersectionMultimapRecipe(), new SetsUnionRecipe()});
    }

    @NullMarked
    public static class ImmutableSetBuilderRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableSetRules.ImmutableSetBuilder`";
        }

        public String getDescription() {
            return "Prefer `ImmutableSet#builder()` over the associated constructor.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"new com.google.common.collect.ImmutableSet.Builder<>()").bindType("com.google.common.collect.ImmutableSet.Builder<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.builder()").bindType("com.google.common.collect.ImmutableSet.Builder<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("com.google.common.collect.ImmutableSet.Builder <init>(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IterableToImmutableSetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableSetRules.IterableToImmutableSet`";
        }

        public String getDescription() {
            return "Prefer `ImmutableSet#copyOf(Iterable)` and variants over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before0$0;
                JavaTemplate before0$1;
                JavaTemplate before1$0;
                JavaTemplate before1$1;
                JavaTemplate before2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.<T>builder().add(#{iterable:any(T[])}).build()").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.copyOf(#{iterable:any(java.lang.Iterable<T>)})").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.Arrays.stream(#{iterable:any(T[])}).collect(com.google.common.collect.ImmutableSet.toImmutableSet())").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Arrays");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.copyOf(#{iterable:any(java.lang.Iterable<T>)})").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0$0 == null) {
                        this.before0$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.<T>builder().addAll(#{iterable:any(java.util.Iterator<T>)}).build()").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Iterator");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.copyOf(#{iterable:any(java.lang.Iterable<T>)})").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0$1 == null) {
                        this.before0$1 = JavaTemplate.builder((String)"com.google.common.collect.Streams.stream(#{iterable:any(java.util.Iterator<T>)}).collect(com.google.common.collect.ImmutableSet.toImmutableSet())").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Iterator");
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.copyOf(#{iterable:any(java.lang.Iterable<T>)})").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before1$0 == null) {
                        this.before1$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.<T>builder().addAll(#{iterable:any(java.lang.Iterable<T>)}).build()").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before1$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.copyOf(#{iterable:any(java.lang.Iterable<T>)})").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before1$1 == null) {
                        this.before1$1 = JavaTemplate.builder((String)"com.google.common.collect.Streams.stream(#{iterable:any(java.lang.Iterable<T>)}).collect(com.google.common.collect.ImmutableSet.toImmutableSet())").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before1$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.copyOf(#{iterable:any(java.lang.Iterable<T>)})").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before2 == null) {
                        this.before2 = JavaTemplate.builder((String)"#{iterable:any(java.util.Collection<T>)}.stream().collect(com.google.common.collect.ImmutableSet.toImmutableSet())").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Collection");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.copyOf(#{iterable:any(java.lang.Iterable<T>)})").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableSet", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.google.common.collect.ImmutableSet builder(..)", true), new UsesMethod("com.google.common.collect.ImmutableSet.Builder add(..)", true), new UsesMethod("com.google.common.collect.ImmutableSet.Builder build(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.google.common.collect.ImmutableSet builder(..)", true), new UsesMethod("com.google.common.collect.ImmutableSet.Builder addAll(..)", true), new UsesMethod("com.google.common.collect.ImmutableSet.Builder build(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSet toImmutableSet(..)", true), new UsesMethod("com.google.common.collect.Streams stream(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesType("java.util.Iterator", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSet toImmutableSet(..)", true), new UsesMethod("com.google.common.collect.Streams stream(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Arrays", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSet toImmutableSet(..)", true), new UsesMethod("java.util.Arrays stream(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSet toImmutableSet(..)", true), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Iterator", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSet builder(..)", true), new UsesMethod("com.google.common.collect.ImmutableSet.Builder addAll(..)", true), new UsesMethod("com.google.common.collect.ImmutableSet.Builder build(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamToImmutableSetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableSetRules.StreamToImmutableSet`";
        }

        public String getDescription() {
            return "Prefer `ImmutableSet#toImmutableSet()` over less idiomatic alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.copyOf(#{stream:any(java.util.stream.Stream<T>)}.iterator())").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.collect(com.google.common.collect.ImmutableSet.toImmutableSet())").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.distinct().collect(com.google.common.collect.ImmutableSet.toImmutableSet())").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.collect(com.google.common.collect.ImmutableSet.toImmutableSet())").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableSet", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.google.common.collect.ImmutableSet copyOf(..)", true), new UsesMethod("java.util.stream.BaseStream iterator(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.google.common.collect.ImmutableSet toImmutableSet(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("java.util.stream.Stream distinct(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableSetCopyOfSetViewRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableSetRules.ImmutableSetCopyOfSetView`";
        }

        public String getDescription() {
            return "Prefer `SetView#immutableCopy()` over the more verbose alternative.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.copyOf(#{set:any(com.google.common.collect.Sets.SetView<T>)})").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{set:any(com.google.common.collect.Sets.SetView<T>)}.immutableCopy()").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableSet", Boolean.valueOf(true)), new UsesType("com.google.common.collect.Sets.SetView", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSet copyOf(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableSetOfRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableSetRules.ImmutableSetOf`";
        }

        public String getDescription() {
            return "Prefer `ImmutableSet#of()` over more contrived alternatives or alternatives that don't communicate the immutability of the resulting set at the type level.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.<T>builder().build()").bindType("java.util.Set<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Set");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.of()").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.stream.Stream.<T>empty().collect(com.google.common.collect.ImmutableSet.toImmutableSet())").bindType("java.util.Set<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Stream");
                        this.maybeRemoveImport("java.util.Set");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.of()").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"java.util.Collections.emptySet()").bindType("java.util.Set<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Set");
                        this.maybeRemoveImport("java.util.Collections");
                        this.maybeRemoveImport("java.util.Collections.emptySet");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.of()").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$3 == null) {
                        this.before$3 = JavaTemplate.builder((String)"java.util.Set.of()").bindType("java.util.Set<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$3.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Set");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.of()").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Set", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Collections emptySet(..)", true), new UsesMethod("java.util.Set of(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableSet", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSet builder(..)", true), new UsesMethod("com.google.common.collect.ImmutableSet.Builder build(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSet toImmutableSet(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("java.util.stream.Stream empty(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableSetOf1Recipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableSetRules.ImmutableSetOf1`";
        }

        public String getDescription() {
            return "Prefer `ImmutableSet#of(Object)` over more contrived alternatives or alternatives that don't communicate the immutability of the resulting set at the type level.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.<T>builder().add(#{e1:any(T)}).build()").bindType("java.util.Set<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Set");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.of(#{e1:any(T)})").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.Collections.singleton(#{e1:any(T)})").bindType("java.util.Set<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Set");
                        this.maybeRemoveImport("java.util.Collections");
                        this.maybeRemoveImport("java.util.Collections.singleton");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.of(#{e1:any(T)})").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"java.util.Set.of(#{e1:any(T)})").bindType("java.util.Set<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Set");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.of(#{e1:any(T)})").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Set", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Collections singleton(..)", true), new UsesMethod("java.util.Set of(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableSet", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSet builder(..)", true), new UsesMethod("com.google.common.collect.ImmutableSet.Builder add(..)", true), new UsesMethod("com.google.common.collect.ImmutableSet.Builder build(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableSetOf2Recipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableSetRules.ImmutableSetOf2`";
        }

        public String getDescription() {
            return "Prefer `ImmutableSet#of(Object, Object)` over alternatives that don't communicate the immutability of the resulting set at the type level.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.util.Set.of(#{e1:any(T)}, #{e2:any(T)})").bindType("java.util.Set<T>").genericTypes(new String[]{"T"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Set");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.of(#{e1:any(T)}, #{e2:any(T)})").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Set", Boolean.valueOf(true)), new UsesMethod("java.util.Set of(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableSetOf3Recipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableSetRules.ImmutableSetOf3`";
        }

        public String getDescription() {
            return "Prefer `ImmutableSet#of(Object, Object, Object)` over alternatives that don't communicate the immutability of the resulting set at the type level.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.util.Set.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)})").bindType("java.util.Set<T>").genericTypes(new String[]{"T"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Set");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)})").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Set", Boolean.valueOf(true)), new UsesMethod("java.util.Set of(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableSetOf4Recipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableSetRules.ImmutableSetOf4`";
        }

        public String getDescription() {
            return "Prefer `ImmutableSet#of(Object, Object, Object, Object)` over alternatives that don't communicate the immutability of the resulting set at the type level.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.util.Set.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}, #{e4:any(T)})").bindType("java.util.Set<T>").genericTypes(new String[]{"T"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Set");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}, #{e4:any(T)})").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Set", Boolean.valueOf(true)), new UsesMethod("java.util.Set of(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableSetOf5Recipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableSetRules.ImmutableSetOf5`";
        }

        public String getDescription() {
            return "Prefer `ImmutableSet#of(Object, Object, Object, Object, Object)` over alternatives that don't communicate the immutability of the resulting set at the type level.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.util.Set.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}, #{e4:any(T)}, #{e5:any(T)})").bindType("java.util.Set<T>").genericTypes(new String[]{"T"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Set");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}, #{e4:any(T)}, #{e5:any(T)})").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3), matcher.parameter(4)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Set", Boolean.valueOf(true)), new UsesMethod("java.util.Set of(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class SetsDifferenceRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableSetRules.SetsDifference`";
        }

        public String getDescription() {
            return "Prefer an immutable copy of `Sets#difference(Set, Set)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitLambda(J.Lambda elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{set1:any(java.util.Set<S>)}.stream().filter(java.util.function.Predicate.not(#{set2:any(java.util.Set<T>)}::contains)).collect(com.google.common.collect.ImmutableSet.toImmutableSet())").bindType("com.google.common.collect.ImmutableSet<S>").genericTypes(new String[]{"S", "T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.function.Predicate");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        this.maybeRemoveImport("java.util.function.Predicate.not");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.Sets.difference(#{set1:any(java.util.Set<S>)}, #{set2:any(java.util.Set<T>)}).immutableCopy()").bindType("com.google.common.collect.ImmutableSet<S>").genericTypes(new String[]{"S", "T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{set1:any(java.util.Set<S>)}.stream().filter((e)->!#{set2:any(java.util.Set<T>)}.contains(e)).collect(com.google.common.collect.ImmutableSet.toImmutableSet())").bindType("com.google.common.collect.ImmutableSet<S>").genericTypes(new String[]{"S", "T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.Sets.difference(#{set1:any(java.util.Set<S>)}, #{set2:any(java.util.Set<T>)}).immutableCopy()").bindType("com.google.common.collect.ImmutableSet<S>").genericTypes(new String[]{"S", "T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitLambda(elem, (Object)ctx);
                }

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{set1:any(java.util.Set<S>)}.stream().filter(java.util.function.Predicate.not(#{set2:any(java.util.Set<T>)}::contains)).collect(com.google.common.collect.ImmutableSet.toImmutableSet())").bindType("com.google.common.collect.ImmutableSet<S>").genericTypes(new String[]{"S", "T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.function.Predicate");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        this.maybeRemoveImport("java.util.function.Predicate.not");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.Sets.difference(#{set1:any(java.util.Set<S>)}, #{set2:any(java.util.Set<T>)}).immutableCopy()").bindType("com.google.common.collect.ImmutableSet<S>").genericTypes(new String[]{"S", "T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{set1:any(java.util.Set<S>)}.stream().filter((e)->!#{set2:any(java.util.Set<T>)}.contains(e)).collect(com.google.common.collect.ImmutableSet.toImmutableSet())").bindType("com.google.common.collect.ImmutableSet<S>").genericTypes(new String[]{"S", "T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.Sets.difference(#{set1:any(java.util.Set<S>)}, #{set2:any(java.util.Set<T>)}).immutableCopy()").bindType("com.google.common.collect.ImmutableSet<S>").genericTypes(new String[]{"S", "T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableSet", Boolean.valueOf(true)), new UsesType("java.util.Set", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSet toImmutableSet(..)", true), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("java.util.stream.Stream filter(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Set contains(..)", true), new UsesMethod("java.util.function.Predicate not(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class SetsDifferenceMapRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableSetRules.SetsDifferenceMap`";
        }

        public String getDescription() {
            return "Prefer an immutable copy of `Sets#difference(Set, Set)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitLambda(J.Lambda elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{set:any(java.util.Set<T>)}.stream().filter(java.util.function.Predicate.not(#{map:any(java.util.Map<K, V>)}::containsKey)).collect(com.google.common.collect.ImmutableSet.toImmutableSet())").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T", "K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.function.Predicate");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        this.maybeRemoveImport("java.util.function.Predicate.not");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.Sets.difference(#{set:any(java.util.Set<K>)}, #{map:any(java.util.Map<K, V>)}.keySet()).immutableCopy()").bindType("com.google.common.collect.ImmutableSet<K>").genericTypes(new String[]{"T", "K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{set:any(java.util.Set<T>)}.stream().filter((e)->!#{map:any(java.util.Map<K, V>)}.containsKey(e)).collect(com.google.common.collect.ImmutableSet.toImmutableSet())").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T", "K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.Sets.difference(#{set:any(java.util.Set<K>)}, #{map:any(java.util.Map<K, V>)}.keySet()).immutableCopy()").bindType("com.google.common.collect.ImmutableSet<K>").genericTypes(new String[]{"T", "K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitLambda(elem, (Object)ctx);
                }

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{set:any(java.util.Set<T>)}.stream().filter(java.util.function.Predicate.not(#{map:any(java.util.Map<K, V>)}::containsKey)).collect(com.google.common.collect.ImmutableSet.toImmutableSet())").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T", "K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.function.Predicate");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        this.maybeRemoveImport("java.util.function.Predicate.not");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.Sets.difference(#{set:any(java.util.Set<K>)}, #{map:any(java.util.Map<K, V>)}.keySet()).immutableCopy()").bindType("com.google.common.collect.ImmutableSet<K>").genericTypes(new String[]{"T", "K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{set:any(java.util.Set<T>)}.stream().filter((e)->!#{map:any(java.util.Map<K, V>)}.containsKey(e)).collect(com.google.common.collect.ImmutableSet.toImmutableSet())").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T", "K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.Sets.difference(#{set:any(java.util.Set<K>)}, #{map:any(java.util.Map<K, V>)}.keySet()).immutableCopy()").bindType("com.google.common.collect.ImmutableSet<K>").genericTypes(new String[]{"T", "K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableSet", Boolean.valueOf(true)), new UsesType("java.util.Map", Boolean.valueOf(true)), new UsesType("java.util.Set", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSet toImmutableSet(..)", true), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("java.util.stream.Stream filter(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Map containsKey(..)", true), new UsesMethod("java.util.function.Predicate not(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class SetsDifferenceMultimapRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableSetRules.SetsDifferenceMultimap`";
        }

        public String getDescription() {
            return "Prefer an immutable copy of `Sets#difference(Set, Set)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitLambda(J.Lambda elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{set:any(java.util.Set<T>)}.stream().filter(java.util.function.Predicate.not(#{multimap:any(com.google.common.collect.Multimap<K, V>)}::containsKey)).collect(com.google.common.collect.ImmutableSet.toImmutableSet())").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T", "K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.function.Predicate");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        this.maybeRemoveImport("java.util.function.Predicate.not");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.Sets.difference(#{set:any(java.util.Set<T>)}, #{multimap:any(com.google.common.collect.Multimap<K, V>)}.keySet()).immutableCopy()").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T", "K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{set:any(java.util.Set<T>)}.stream().filter((e)->!#{multimap:any(com.google.common.collect.Multimap<K, V>)}.containsKey(e)).collect(com.google.common.collect.ImmutableSet.toImmutableSet())").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T", "K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.Sets.difference(#{set:any(java.util.Set<T>)}, #{multimap:any(com.google.common.collect.Multimap<K, V>)}.keySet()).immutableCopy()").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T", "K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitLambda(elem, (Object)ctx);
                }

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{set:any(java.util.Set<T>)}.stream().filter(java.util.function.Predicate.not(#{multimap:any(com.google.common.collect.Multimap<K, V>)}::containsKey)).collect(com.google.common.collect.ImmutableSet.toImmutableSet())").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T", "K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.function.Predicate");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        this.maybeRemoveImport("java.util.function.Predicate.not");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.Sets.difference(#{set:any(java.util.Set<T>)}, #{multimap:any(com.google.common.collect.Multimap<K, V>)}.keySet()).immutableCopy()").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T", "K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{set:any(java.util.Set<T>)}.stream().filter((e)->!#{multimap:any(com.google.common.collect.Multimap<K, V>)}.containsKey(e)).collect(com.google.common.collect.ImmutableSet.toImmutableSet())").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T", "K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.Sets.difference(#{set:any(java.util.Set<T>)}, #{multimap:any(com.google.common.collect.Multimap<K, V>)}.keySet()).immutableCopy()").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T", "K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableSet", Boolean.valueOf(true)), new UsesType("com.google.common.collect.Multimap", Boolean.valueOf(true)), new UsesType("java.util.Set", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSet toImmutableSet(..)", true), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("java.util.stream.Stream filter(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.google.common.collect.Multimap containsKey(..)", true), new UsesMethod("java.util.function.Predicate not(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class SetsIntersectionRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableSetRules.SetsIntersection`";
        }

        public String getDescription() {
            return "Prefer an immutable copy of `Sets#intersection(Set, Set)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{set1:any(java.util.Set<S>)}.stream().filter(#{set2:any(java.util.Set<T>)}::contains).collect(com.google.common.collect.ImmutableSet.toImmutableSet())").bindType("com.google.common.collect.ImmutableSet<S>").genericTypes(new String[]{"S", "T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.Sets.intersection(#{set1:any(java.util.Set<S>)}, #{set2:any(java.util.Set<T>)}).immutableCopy()").bindType("com.google.common.collect.ImmutableSet<S>").genericTypes(new String[]{"S", "T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableSet", Boolean.valueOf(true)), new UsesType("java.util.Set", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSet toImmutableSet(..)", true), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("java.util.stream.Stream filter(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class SetsIntersectionMapRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableSetRules.SetsIntersectionMap`";
        }

        public String getDescription() {
            return "Prefer an immutable copy of `Sets#intersection(Set, Set)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{set:any(java.util.Set<T>)}.stream().filter(#{map:any(java.util.Map<K, V>)}::containsKey).collect(com.google.common.collect.ImmutableSet.toImmutableSet())").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T", "K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.Sets.intersection(#{set:any(java.util.Set<T>)}, #{map:any(java.util.Map<K, V>)}.keySet()).immutableCopy()").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T", "K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableSet", Boolean.valueOf(true)), new UsesType("java.util.Map", Boolean.valueOf(true)), new UsesType("java.util.Set", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSet toImmutableSet(..)", true), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("java.util.stream.Stream filter(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class SetsIntersectionMultimapRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableSetRules.SetsIntersectionMultimap`";
        }

        public String getDescription() {
            return "Prefer an immutable copy of `Sets#intersection(Set, Set)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{set:any(java.util.Set<T>)}.stream().filter(#{multimap:any(com.google.common.collect.Multimap<K, V>)}::containsKey).collect(com.google.common.collect.ImmutableSet.toImmutableSet())").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T", "K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.Sets.intersection(#{set:any(java.util.Set<T>)}, #{multimap:any(com.google.common.collect.Multimap<K, V>)}.keySet()).immutableCopy()").bindType("com.google.common.collect.ImmutableSet<T>").genericTypes(new String[]{"T", "K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableSet", Boolean.valueOf(true)), new UsesType("com.google.common.collect.Multimap", Boolean.valueOf(true)), new UsesType("java.util.Set", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSet toImmutableSet(..)", true), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("java.util.stream.Stream filter(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class SetsUnionRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableSetRules.SetsUnion`";
        }

        public String getDescription() {
            return "Prefer an immutable copy of `Sets#union(Set, Set)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.util.stream.Stream.concat(#{set1:any(java.util.Set<T>)}.stream(), #{set2:any(java.util.Set<U>)}.stream()).collect(com.google.common.collect.ImmutableSet.toImmutableSet())").bindType("com.google.common.collect.ImmutableSet<S>").genericTypes(new String[]{"S", "T extends S", "U extends S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Stream");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.Sets.union(#{set1:any(java.util.Set<T>)}, #{set2:any(java.util.Set<U>)}).immutableCopy()").bindType("com.google.common.collect.ImmutableSet<S>").genericTypes(new String[]{"S", "T extends S", "U extends S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableSet", Boolean.valueOf(true)), new UsesType("java.util.Set", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSet toImmutableSet(..)", true), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("java.util.stream.Stream concat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

