/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJFileRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules related to AssertJ assertions over `File`s";
    }

    public String getDescription() {
        return "These rules simplify and improve the readability of tests by using `File`-specific\n AssertJ assertion methods instead of generic assertions.\n[Source](https://error-prone.picnic.tech/refasterrules/AssertJFileRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AssertThatExistsRecipe(), new AssertThatDoesNotExistRecipe(), new AssertThatIsFileRecipe(), new AssertThatIsDirectoryRecipe(), new AssertThatIsAbsoluteRecipe(), new AssertThatIsRelativeRecipe(), new AssertThatIsReadableRecipe(), new AssertThatIsWritableRecipe(), new AssertThatIsExecutableRecipe(), new AssertThatHasFileNameRecipe(), new AssertThatHasParentFileRecipe(), new AssertThatHasParentStringRecipe(), new AssertThatHasNoParentRecipe()});
    }

    @NullMarked
    public static class AssertThatExistsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJFileRules.AssertThatExists`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatExists {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(File actual) {\n        return assertThat(actual.exists()).isTrue();\n    }\n    \n    @AfterTemplate\n    AbstractFileAssert<?> after(File actual) {\n        return assertThat(actual).exists();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.io.File)}.exists()).isTrue()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.io.File)}).exists()").bindType("org.assertj.core.api.AbstractFileAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("java.io.File exists(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatDoesNotExistRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJFileRules.AssertThatDoesNotExist`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatDoesNotExist {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(File actual) {\n        return assertThat(actual.exists()).isFalse();\n    }\n    \n    @AfterTemplate\n    AbstractFileAssert<?> after(File actual) {\n        return assertThat(actual).doesNotExist();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.io.File)}.exists()).isFalse()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.io.File)}).doesNotExist()").bindType("org.assertj.core.api.AbstractFileAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("java.io.File exists(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsFileRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJFileRules.AssertThatIsFile`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsFile {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(File actual) {\n        return assertThat(actual.isFile()).isTrue();\n    }\n    \n    @AfterTemplate\n    AbstractFileAssert<?> after(File actual) {\n        return assertThat(actual).isFile();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.io.File)}.isFile()).isTrue()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.io.File)}).isFile()").bindType("org.assertj.core.api.AbstractFileAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("java.io.File isFile(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsDirectoryRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJFileRules.AssertThatIsDirectory`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsDirectory {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(File actual) {\n        return assertThat(actual.isDirectory()).isTrue();\n    }\n    \n    @AfterTemplate\n    AbstractFileAssert<?> after(File actual) {\n        return assertThat(actual).isDirectory();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.io.File)}.isDirectory()).isTrue()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.io.File)}).isDirectory()").bindType("org.assertj.core.api.AbstractFileAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("java.io.File isDirectory(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsAbsoluteRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJFileRules.AssertThatIsAbsolute`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsAbsolute {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(File actual) {\n        return assertThat(actual.isAbsolute()).isTrue();\n    }\n    \n    @AfterTemplate\n    AbstractFileAssert<?> after(File actual) {\n        return assertThat(actual).isAbsolute();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.io.File)}.isAbsolute()).isTrue()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.io.File)}).isAbsolute()").bindType("org.assertj.core.api.AbstractFileAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("java.io.File isAbsolute(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsRelativeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJFileRules.AssertThatIsRelative`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsRelative {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(File actual) {\n        return assertThat(actual.isAbsolute()).isFalse();\n    }\n    \n    @AfterTemplate\n    AbstractFileAssert<?> after(File actual) {\n        return assertThat(actual).isRelative();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.io.File)}.isAbsolute()).isFalse()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.io.File)}).isRelative()").bindType("org.assertj.core.api.AbstractFileAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("java.io.File isAbsolute(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsReadableRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJFileRules.AssertThatIsReadable`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsReadable {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(File actual) {\n        return assertThat(actual.canRead()).isTrue();\n    }\n    \n    @AfterTemplate\n    AbstractFileAssert<?> after(File actual) {\n        return assertThat(actual).isReadable();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.io.File)}.canRead()).isTrue()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.io.File)}).isReadable()").bindType("org.assertj.core.api.AbstractFileAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("java.io.File canRead(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsWritableRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJFileRules.AssertThatIsWritable`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsWritable {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(File actual) {\n        return assertThat(actual.canWrite()).isTrue();\n    }\n    \n    @AfterTemplate\n    AbstractFileAssert<?> after(File actual) {\n        return assertThat(actual).isWritable();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.io.File)}.canWrite()).isTrue()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.io.File)}).isWritable()").bindType("org.assertj.core.api.AbstractFileAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("java.io.File canWrite(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsExecutableRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJFileRules.AssertThatIsExecutable`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsExecutable {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(File actual) {\n        return assertThat(actual.canExecute()).isTrue();\n    }\n    \n    @AfterTemplate\n    AbstractFileAssert<?> after(File actual) {\n        return assertThat(actual).isExecutable();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.io.File)}.canExecute()).isTrue()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.io.File)}).isExecutable()").bindType("org.assertj.core.api.AbstractFileAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("java.io.File canExecute(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatHasFileNameRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJFileRules.AssertThatHasFileName`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatHasFileName {\n    \n    @BeforeTemplate\n    AbstractStringAssert<?> before(File actual, String fileName) {\n        return assertThat(actual.getName()).isEqualTo(fileName);\n    }\n    \n    @AfterTemplate\n    AbstractFileAssert<?> after(File actual, String fileName) {\n        return assertThat(actual).hasFileName(fileName);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.io.File)}.getName()).isEqualTo(#{fileName:any(java.lang.String)})").bindType("org.assertj.core.api.AbstractStringAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractStringAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.io.File)}).hasFileName(#{fileName:any(java.lang.String)})").bindType("org.assertj.core.api.AbstractFileAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractStringAssert", Boolean.valueOf(true)), new UsesMethod("java.io.File getName(..)", true), new UsesMethod("org.assertj.core.api.AbstractStringAssert isEqualTo(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatHasParentFileRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJFileRules.AssertThatHasParentFile`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatHasParentFile {\n    \n    @BeforeTemplate\n    AbstractFileAssert<?> before(File actual, File expected) {\n        return assertThat(actual.getParentFile()).isEqualTo(expected);\n    }\n    \n    @AfterTemplate\n    AbstractFileAssert<?> after(File actual, File expected) {\n        return assertThat(actual).hasParent(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.io.File)}.getParentFile()).isEqualTo(#{expected:any(java.io.File)})").bindType("org.assertj.core.api.AbstractFileAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.io.File)}).hasParent(#{expected:any(java.io.File)})").bindType("org.assertj.core.api.AbstractFileAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractFileAssert", Boolean.valueOf(true)), new UsesMethod("java.io.File getParentFile(..)", true), new UsesMethod("org.assertj.core.api.AbstractAssert isEqualTo(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatHasParentStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJFileRules.AssertThatHasParentString`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatHasParentString {\n    \n    @BeforeTemplate\n    AbstractFileAssert<?> before(File actual, String expected) {\n        return assertThat(actual.getParentFile()).hasFileName(expected);\n    }\n    \n    @AfterTemplate\n    AbstractFileAssert<?> after(File actual, String expected) {\n        return assertThat(actual).hasParent(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.io.File)}.getParentFile()).hasFileName(#{expected:any(java.lang.String)})").bindType("org.assertj.core.api.AbstractFileAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.io.File)}).hasParent(#{expected:any(java.lang.String)})").bindType("org.assertj.core.api.AbstractFileAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractFileAssert", Boolean.valueOf(true)), new UsesMethod("java.io.File getParentFile(..)", true), new UsesMethod("org.assertj.core.api.AbstractFileAssert hasFileName(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatHasNoParentRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJFileRules.AssertThatHasNoParent`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatHasNoParent {\n    \n    @BeforeTemplate\n    void before(File actual) {\n        assertThat(actual.getParent()).isNull();\n    }\n    \n    @AfterTemplate\n    void after(File actual) {\n        assertThat(actual).hasNoParent();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.io.File)}.getParent()).isNull();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.io.File)}).hasNoParent();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesMethod("java.io.File getParent(..)", true), new UsesMethod("org.assertj.core.api.AbstractAssert isNull(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

