/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssooidc.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDeviceAuthorizationResponse extends SsoOidcResponse implements
        ToCopyableBuilder<StartDeviceAuthorizationResponse.Builder, StartDeviceAuthorizationResponse> {
    private static final SdkField<String> DEVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceCode").getter(getter(StartDeviceAuthorizationResponse::deviceCode))
            .setter(setter(Builder::deviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceCode").build()).build();

    private static final SdkField<String> USER_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userCode").getter(getter(StartDeviceAuthorizationResponse::userCode)).setter(setter(Builder::userCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userCode").build()).build();

    private static final SdkField<String> VERIFICATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("verificationUri").getter(getter(StartDeviceAuthorizationResponse::verificationUri))
            .setter(setter(Builder::verificationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verificationUri").build()).build();

    private static final SdkField<String> VERIFICATION_URI_COMPLETE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("verificationUriComplete").getter(getter(StartDeviceAuthorizationResponse::verificationUriComplete))
            .setter(setter(Builder::verificationUriComplete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verificationUriComplete").build())
            .build();

    private static final SdkField<Integer> EXPIRES_IN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("expiresIn").getter(getter(StartDeviceAuthorizationResponse::expiresIn))
            .setter(setter(Builder::expiresIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresIn").build()).build();

    private static final SdkField<Integer> INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("interval").getter(getter(StartDeviceAuthorizationResponse::interval)).setter(setter(Builder::interval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interval").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_CODE_FIELD,
            USER_CODE_FIELD, VERIFICATION_URI_FIELD, VERIFICATION_URI_COMPLETE_FIELD, EXPIRES_IN_FIELD, INTERVAL_FIELD));

    private final String deviceCode;

    private final String userCode;

    private final String verificationUri;

    private final String verificationUriComplete;

    private final Integer expiresIn;

    private final Integer interval;

    private StartDeviceAuthorizationResponse(BuilderImpl builder) {
        super(builder);
        this.deviceCode = builder.deviceCode;
        this.userCode = builder.userCode;
        this.verificationUri = builder.verificationUri;
        this.verificationUriComplete = builder.verificationUriComplete;
        this.expiresIn = builder.expiresIn;
        this.interval = builder.interval;
    }

    /**
     * <p>
     * The short-lived code that is used by the device when polling for a session token.
     * </p>
     * 
     * @return The short-lived code that is used by the device when polling for a session token.
     */
    public final String deviceCode() {
        return deviceCode;
    }

    /**
     * <p>
     * A one-time user verification code. This is needed to authorize an in-use device.
     * </p>
     * 
     * @return A one-time user verification code. This is needed to authorize an in-use device.
     */
    public final String userCode() {
        return userCode;
    }

    /**
     * <p>
     * The URI of the verification page that takes the <code>userCode</code> to authorize the device.
     * </p>
     * 
     * @return The URI of the verification page that takes the <code>userCode</code> to authorize the device.
     */
    public final String verificationUri() {
        return verificationUri;
    }

    /**
     * <p>
     * An alternate URL that the client can use to automatically launch a browser. This process skips the manual step in
     * which the user visits the verification page and enters their code.
     * </p>
     * 
     * @return An alternate URL that the client can use to automatically launch a browser. This process skips the manual
     *         step in which the user visits the verification page and enters their code.
     */
    public final String verificationUriComplete() {
        return verificationUriComplete;
    }

    /**
     * <p>
     * Indicates the number of seconds in which the verification code will become invalid.
     * </p>
     * 
     * @return Indicates the number of seconds in which the verification code will become invalid.
     */
    public final Integer expiresIn() {
        return expiresIn;
    }

    /**
     * <p>
     * Indicates the number of seconds the client must wait between attempts when polling for a session.
     * </p>
     * 
     * @return Indicates the number of seconds the client must wait between attempts when polling for a session.
     */
    public final Integer interval() {
        return interval;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(userCode());
        hashCode = 31 * hashCode + Objects.hashCode(verificationUri());
        hashCode = 31 * hashCode + Objects.hashCode(verificationUriComplete());
        hashCode = 31 * hashCode + Objects.hashCode(expiresIn());
        hashCode = 31 * hashCode + Objects.hashCode(interval());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDeviceAuthorizationResponse)) {
            return false;
        }
        StartDeviceAuthorizationResponse other = (StartDeviceAuthorizationResponse) obj;
        return Objects.equals(deviceCode(), other.deviceCode()) && Objects.equals(userCode(), other.userCode())
                && Objects.equals(verificationUri(), other.verificationUri())
                && Objects.equals(verificationUriComplete(), other.verificationUriComplete())
                && Objects.equals(expiresIn(), other.expiresIn()) && Objects.equals(interval(), other.interval());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartDeviceAuthorizationResponse").add("DeviceCode", deviceCode()).add("UserCode", userCode())
                .add("VerificationUri", verificationUri()).add("VerificationUriComplete", verificationUriComplete())
                .add("ExpiresIn", expiresIn()).add("Interval", interval()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deviceCode":
            return Optional.ofNullable(clazz.cast(deviceCode()));
        case "userCode":
            return Optional.ofNullable(clazz.cast(userCode()));
        case "verificationUri":
            return Optional.ofNullable(clazz.cast(verificationUri()));
        case "verificationUriComplete":
            return Optional.ofNullable(clazz.cast(verificationUriComplete()));
        case "expiresIn":
            return Optional.ofNullable(clazz.cast(expiresIn()));
        case "interval":
            return Optional.ofNullable(clazz.cast(interval()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDeviceAuthorizationResponse, T> g) {
        return obj -> g.apply((StartDeviceAuthorizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoOidcResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartDeviceAuthorizationResponse> {
        /**
         * <p>
         * The short-lived code that is used by the device when polling for a session token.
         * </p>
         * 
         * @param deviceCode
         *        The short-lived code that is used by the device when polling for a session token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceCode(String deviceCode);

        /**
         * <p>
         * A one-time user verification code. This is needed to authorize an in-use device.
         * </p>
         * 
         * @param userCode
         *        A one-time user verification code. This is needed to authorize an in-use device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userCode(String userCode);

        /**
         * <p>
         * The URI of the verification page that takes the <code>userCode</code> to authorize the device.
         * </p>
         * 
         * @param verificationUri
         *        The URI of the verification page that takes the <code>userCode</code> to authorize the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationUri(String verificationUri);

        /**
         * <p>
         * An alternate URL that the client can use to automatically launch a browser. This process skips the manual
         * step in which the user visits the verification page and enters their code.
         * </p>
         * 
         * @param verificationUriComplete
         *        An alternate URL that the client can use to automatically launch a browser. This process skips the
         *        manual step in which the user visits the verification page and enters their code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationUriComplete(String verificationUriComplete);

        /**
         * <p>
         * Indicates the number of seconds in which the verification code will become invalid.
         * </p>
         * 
         * @param expiresIn
         *        Indicates the number of seconds in which the verification code will become invalid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresIn(Integer expiresIn);

        /**
         * <p>
         * Indicates the number of seconds the client must wait between attempts when polling for a session.
         * </p>
         * 
         * @param interval
         *        Indicates the number of seconds the client must wait between attempts when polling for a session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interval(Integer interval);
    }

    static final class BuilderImpl extends SsoOidcResponse.BuilderImpl implements Builder {
        private String deviceCode;

        private String userCode;

        private String verificationUri;

        private String verificationUriComplete;

        private Integer expiresIn;

        private Integer interval;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDeviceAuthorizationResponse model) {
            super(model);
            deviceCode(model.deviceCode);
            userCode(model.userCode);
            verificationUri(model.verificationUri);
            verificationUriComplete(model.verificationUriComplete);
            expiresIn(model.expiresIn);
            interval(model.interval);
        }

        public final String getDeviceCode() {
            return deviceCode;
        }

        public final void setDeviceCode(String deviceCode) {
            this.deviceCode = deviceCode;
        }

        @Override
        public final Builder deviceCode(String deviceCode) {
            this.deviceCode = deviceCode;
            return this;
        }

        public final String getUserCode() {
            return userCode;
        }

        public final void setUserCode(String userCode) {
            this.userCode = userCode;
        }

        @Override
        public final Builder userCode(String userCode) {
            this.userCode = userCode;
            return this;
        }

        public final String getVerificationUri() {
            return verificationUri;
        }

        public final void setVerificationUri(String verificationUri) {
            this.verificationUri = verificationUri;
        }

        @Override
        public final Builder verificationUri(String verificationUri) {
            this.verificationUri = verificationUri;
            return this;
        }

        public final String getVerificationUriComplete() {
            return verificationUriComplete;
        }

        public final void setVerificationUriComplete(String verificationUriComplete) {
            this.verificationUriComplete = verificationUriComplete;
        }

        @Override
        public final Builder verificationUriComplete(String verificationUriComplete) {
            this.verificationUriComplete = verificationUriComplete;
            return this;
        }

        public final Integer getExpiresIn() {
            return expiresIn;
        }

        public final void setExpiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
        }

        @Override
        public final Builder expiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public final Integer getInterval() {
            return interval;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        @Override
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        @Override
        public StartDeviceAuthorizationResponse build() {
            return new StartDeviceAuthorizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
