/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When included in a receipt rule, this action calls Amazon WorkMail and, optionally, publishes a notification to
 * Amazon Simple Notification Service (Amazon SNS). It usually isn't necessary to set this up manually, because Amazon
 * WorkMail adds the rule automatically during its setup procedure.
 * </p>
 * <p>
 * For information using a receipt rule to call Amazon WorkMail, see the <a
 * href="https://docs.aws.amazon.com/ses/latest/dg/receiving-email-action-workmail.html">Amazon SES Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkmailAction implements SdkPojo, Serializable, ToCopyableBuilder<WorkmailAction.Builder, WorkmailAction> {
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicArn").getter(getter(WorkmailAction::topicArn)).setter(setter(Builder::topicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()).build();

    private static final SdkField<String> ORGANIZATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationArn").getter(getter(WorkmailAction::organizationArn))
            .setter(setter(Builder::organizationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_ARN_FIELD,
            ORGANIZATION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String topicArn;

    private final String organizationArn;

    private WorkmailAction(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.organizationArn = builder.organizationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the WorkMail action is called. You can find
     * the ARN of a topic by using the <a
     * href="https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html">ListTopics</a> operation in Amazon SNS.
     * </p>
     * <p>
     * For more information about Amazon SNS topics, see the <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the WorkMail action is called. You
     *         can find the ARN of a topic by using the <a
     *         href="https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html">ListTopics</a> operation in Amazon
     *         SNS.</p>
     *         <p>
     *         For more information about Amazon SNS topics, see the <a
     *         href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.
     */
    public final String topicArn() {
        return topicArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon WorkMail organization. Amazon WorkMail ARNs use the following
     * format:
     * </p>
     * <p>
     * <code>arn:aws:workmail:&lt;region&gt;:&lt;awsAccountId&gt;:organization/&lt;workmailOrganizationId&gt;</code>
     * </p>
     * <p>
     * You can find the ID of your organization by using the <a
     * href="https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListOrganizations.html">ListOrganizations</a>
     * operation in Amazon WorkMail. Amazon WorkMail organization IDs begin with "<code>m-</code>", followed by a string
     * of alphanumeric characters.
     * </p>
     * <p>
     * For information about Amazon WorkMail organizations, see the <a
     * href="https://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html">Amazon WorkMail
     * Administrator Guide</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon WorkMail organization. Amazon WorkMail ARNs use the
     *         following format:</p>
     *         <p>
     *         <code>arn:aws:workmail:&lt;region&gt;:&lt;awsAccountId&gt;:organization/&lt;workmailOrganizationId&gt;</code>
     *         </p>
     *         <p>
     *         You can find the ID of your organization by using the <a
     *         href="https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListOrganizations.html"
     *         >ListOrganizations</a> operation in Amazon WorkMail. Amazon WorkMail organization IDs begin with "
     *         <code>m-</code>", followed by a string of alphanumeric characters.
     *         </p>
     *         <p>
     *         For information about Amazon WorkMail organizations, see the <a
     *         href="https://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html">Amazon WorkMail
     *         Administrator Guide</a>.
     */
    public final String organizationArn() {
        return organizationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(organizationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkmailAction)) {
            return false;
        }
        WorkmailAction other = (WorkmailAction) obj;
        return Objects.equals(topicArn(), other.topicArn()) && Objects.equals(organizationArn(), other.organizationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkmailAction").add("TopicArn", topicArn()).add("OrganizationArn", organizationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicArn":
            return Optional.ofNullable(clazz.cast(topicArn()));
        case "OrganizationArn":
            return Optional.ofNullable(clazz.cast(organizationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TopicArn", TOPIC_ARN_FIELD);
        map.put("OrganizationArn", ORGANIZATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkmailAction, T> g) {
        return obj -> g.apply((WorkmailAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkmailAction> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the WorkMail action is called. You can
         * find the ARN of a topic by using the <a
         * href="https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html">ListTopics</a> operation in Amazon SNS.
         * </p>
         * <p>
         * For more information about Amazon SNS topics, see the <a
         * href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.
         * </p>
         * 
         * @param topicArn
         *        The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the WorkMail action is called.
         *        You can find the ARN of a topic by using the <a
         *        href="https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html">ListTopics</a> operation in
         *        Amazon SNS.</p>
         *        <p>
         *        For more information about Amazon SNS topics, see the <a
         *        href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon WorkMail organization. Amazon WorkMail ARNs use the following
         * format:
         * </p>
         * <p>
         * <code>arn:aws:workmail:&lt;region&gt;:&lt;awsAccountId&gt;:organization/&lt;workmailOrganizationId&gt;</code>
         * </p>
         * <p>
         * You can find the ID of your organization by using the <a
         * href="https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListOrganizations.html"
         * >ListOrganizations</a> operation in Amazon WorkMail. Amazon WorkMail organization IDs begin with "
         * <code>m-</code>", followed by a string of alphanumeric characters.
         * </p>
         * <p>
         * For information about Amazon WorkMail organizations, see the <a
         * href="https://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html">Amazon WorkMail
         * Administrator Guide</a>.
         * </p>
         * 
         * @param organizationArn
         *        The Amazon Resource Name (ARN) of the Amazon WorkMail organization. Amazon WorkMail ARNs use the
         *        following format:</p>
         *        <p>
         *        <code>arn:aws:workmail:&lt;region&gt;:&lt;awsAccountId&gt;:organization/&lt;workmailOrganizationId&gt;</code>
         *        </p>
         *        <p>
         *        You can find the ID of your organization by using the <a
         *        href="https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListOrganizations.html"
         *        >ListOrganizations</a> operation in Amazon WorkMail. Amazon WorkMail organization IDs begin with "
         *        <code>m-</code>", followed by a string of alphanumeric characters.
         *        </p>
         *        <p>
         *        For information about Amazon WorkMail organizations, see the <a
         *        href="https://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html">Amazon
         *        WorkMail Administrator Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationArn(String organizationArn);
    }

    static final class BuilderImpl implements Builder {
        private String topicArn;

        private String organizationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkmailAction model) {
            topicArn(model.topicArn);
            organizationArn(model.organizationArn);
        }

        public final String getTopicArn() {
            return topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final String getOrganizationArn() {
            return organizationArn;
        }

        public final void setOrganizationArn(String organizationArn) {
            this.organizationArn = organizationArn;
        }

        @Override
        public final Builder organizationArn(String organizationArn) {
            this.organizationArn = organizationArn;
            return this;
        }

        @Override
        public WorkmailAction build() {
            return new WorkmailAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
