/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This data type is used as a response element in the <code>DescribeReservedDBInstancesOfferings</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservedDBInstancesOffering implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservedDBInstancesOffering.Builder, ReservedDBInstancesOffering> {
    private static final SdkField<String> RESERVED_DB_INSTANCES_OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservedDBInstancesOfferingId")
            .getter(getter(ReservedDBInstancesOffering::reservedDBInstancesOfferingId))
            .setter(setter(Builder::reservedDBInstancesOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedDBInstancesOfferingId")
                    .build()).build();

    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceClass").getter(getter(ReservedDBInstancesOffering::dbInstanceClass))
            .setter(setter(Builder::dbInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()).build();

    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Duration").getter(getter(ReservedDBInstancesOffering::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<Double> FIXED_PRICE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("FixedPrice").getter(getter(ReservedDBInstancesOffering::fixedPrice)).setter(setter(Builder::fixedPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedPrice").build()).build();

    private static final SdkField<Double> USAGE_PRICE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("UsagePrice").getter(getter(ReservedDBInstancesOffering::usagePrice)).setter(setter(Builder::usagePrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsagePrice").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode").getter(getter(ReservedDBInstancesOffering::currencyCode))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()).build();

    private static final SdkField<String> PRODUCT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductDescription").getter(getter(ReservedDBInstancesOffering::productDescription))
            .setter(setter(Builder::productDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductDescription").build())
            .build();

    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OfferingType").getter(getter(ReservedDBInstancesOffering::offeringType))
            .setter(setter(Builder::offeringType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingType").build()).build();

    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAZ").getter(getter(ReservedDBInstancesOffering::multiAZ)).setter(setter(Builder::multiAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()).build();

    private static final SdkField<List<RecurringCharge>> RECURRING_CHARGES_FIELD = SdkField
            .<List<RecurringCharge>> builder(MarshallingType.LIST)
            .memberName("RecurringCharges")
            .getter(getter(ReservedDBInstancesOffering::recurringCharges))
            .setter(setter(Builder::recurringCharges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("RecurringCharge")
                            .memberFieldInfo(
                                    SdkField.<RecurringCharge> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecurringCharge::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("RecurringCharge").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESERVED_DB_INSTANCES_OFFERING_ID_FIELD, DB_INSTANCE_CLASS_FIELD, DURATION_FIELD, FIXED_PRICE_FIELD,
            USAGE_PRICE_FIELD, CURRENCY_CODE_FIELD, PRODUCT_DESCRIPTION_FIELD, OFFERING_TYPE_FIELD, MULTI_AZ_FIELD,
            RECURRING_CHARGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String reservedDBInstancesOfferingId;

    private final String dbInstanceClass;

    private final Integer duration;

    private final Double fixedPrice;

    private final Double usagePrice;

    private final String currencyCode;

    private final String productDescription;

    private final String offeringType;

    private final Boolean multiAZ;

    private final List<RecurringCharge> recurringCharges;

    private ReservedDBInstancesOffering(BuilderImpl builder) {
        this.reservedDBInstancesOfferingId = builder.reservedDBInstancesOfferingId;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.usagePrice = builder.usagePrice;
        this.currencyCode = builder.currencyCode;
        this.productDescription = builder.productDescription;
        this.offeringType = builder.offeringType;
        this.multiAZ = builder.multiAZ;
        this.recurringCharges = builder.recurringCharges;
    }

    /**
     * <p>
     * The offering identifier.
     * </p>
     * 
     * @return The offering identifier.
     */
    public final String reservedDBInstancesOfferingId() {
        return reservedDBInstancesOfferingId;
    }

    /**
     * <p>
     * The DB instance class for the reserved DB instance.
     * </p>
     * 
     * @return The DB instance class for the reserved DB instance.
     */
    public final String dbInstanceClass() {
        return dbInstanceClass;
    }

    /**
     * <p>
     * The duration of the offering in seconds.
     * </p>
     * 
     * @return The duration of the offering in seconds.
     */
    public final Integer duration() {
        return duration;
    }

    /**
     * <p>
     * The fixed price charged for this offering.
     * </p>
     * 
     * @return The fixed price charged for this offering.
     */
    public final Double fixedPrice() {
        return fixedPrice;
    }

    /**
     * <p>
     * The hourly price charged for this offering.
     * </p>
     * 
     * @return The hourly price charged for this offering.
     */
    public final Double usagePrice() {
        return usagePrice;
    }

    /**
     * <p>
     * The currency code for the reserved DB instance offering.
     * </p>
     * 
     * @return The currency code for the reserved DB instance offering.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * The database engine used by the offering.
     * </p>
     * 
     * @return The database engine used by the offering.
     */
    public final String productDescription() {
        return productDescription;
    }

    /**
     * <p>
     * The offering type.
     * </p>
     * 
     * @return The offering type.
     */
    public final String offeringType() {
        return offeringType;
    }

    /**
     * <p>
     * Indicates whether the offering applies to Multi-AZ deployments.
     * </p>
     * 
     * @return Indicates whether the offering applies to Multi-AZ deployments.
     */
    public final Boolean multiAZ() {
        return multiAZ;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecurringCharges property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecurringCharges() {
        return recurringCharges != null && !(recurringCharges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The recurring price charged to run this reserved DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecurringCharges} method.
     * </p>
     * 
     * @return The recurring price charged to run this reserved DB instance.
     */
    public final List<RecurringCharge> recurringCharges() {
        return recurringCharges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reservedDBInstancesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(usagePrice());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(productDescription());
        hashCode = 31 * hashCode + Objects.hashCode(offeringType());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecurringCharges() ? recurringCharges() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedDBInstancesOffering)) {
            return false;
        }
        ReservedDBInstancesOffering other = (ReservedDBInstancesOffering) obj;
        return Objects.equals(reservedDBInstancesOfferingId(), other.reservedDBInstancesOfferingId())
                && Objects.equals(dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(duration(), other.duration())
                && Objects.equals(fixedPrice(), other.fixedPrice()) && Objects.equals(usagePrice(), other.usagePrice())
                && Objects.equals(currencyCode(), other.currencyCode())
                && Objects.equals(productDescription(), other.productDescription())
                && Objects.equals(offeringType(), other.offeringType()) && Objects.equals(multiAZ(), other.multiAZ())
                && hasRecurringCharges() == other.hasRecurringCharges()
                && Objects.equals(recurringCharges(), other.recurringCharges());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReservedDBInstancesOffering")
                .add("ReservedDBInstancesOfferingId", reservedDBInstancesOfferingId()).add("DBInstanceClass", dbInstanceClass())
                .add("Duration", duration()).add("FixedPrice", fixedPrice()).add("UsagePrice", usagePrice())
                .add("CurrencyCode", currencyCode()).add("ProductDescription", productDescription())
                .add("OfferingType", offeringType()).add("MultiAZ", multiAZ())
                .add("RecurringCharges", hasRecurringCharges() ? recurringCharges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedDBInstancesOfferingId":
            return Optional.ofNullable(clazz.cast(reservedDBInstancesOfferingId()));
        case "DBInstanceClass":
            return Optional.ofNullable(clazz.cast(dbInstanceClass()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "FixedPrice":
            return Optional.ofNullable(clazz.cast(fixedPrice()));
        case "UsagePrice":
            return Optional.ofNullable(clazz.cast(usagePrice()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "ProductDescription":
            return Optional.ofNullable(clazz.cast(productDescription()));
        case "OfferingType":
            return Optional.ofNullable(clazz.cast(offeringType()));
        case "MultiAZ":
            return Optional.ofNullable(clazz.cast(multiAZ()));
        case "RecurringCharges":
            return Optional.ofNullable(clazz.cast(recurringCharges()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReservedDBInstancesOfferingId", RESERVED_DB_INSTANCES_OFFERING_ID_FIELD);
        map.put("DBInstanceClass", DB_INSTANCE_CLASS_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("FixedPrice", FIXED_PRICE_FIELD);
        map.put("UsagePrice", USAGE_PRICE_FIELD);
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("ProductDescription", PRODUCT_DESCRIPTION_FIELD);
        map.put("OfferingType", OFFERING_TYPE_FIELD);
        map.put("MultiAZ", MULTI_AZ_FIELD);
        map.put("RecurringCharges", RECURRING_CHARGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReservedDBInstancesOffering, T> g) {
        return obj -> g.apply((ReservedDBInstancesOffering) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservedDBInstancesOffering> {
        /**
         * <p>
         * The offering identifier.
         * </p>
         * 
         * @param reservedDBInstancesOfferingId
         *        The offering identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedDBInstancesOfferingId(String reservedDBInstancesOfferingId);

        /**
         * <p>
         * The DB instance class for the reserved DB instance.
         * </p>
         * 
         * @param dbInstanceClass
         *        The DB instance class for the reserved DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceClass(String dbInstanceClass);

        /**
         * <p>
         * The duration of the offering in seconds.
         * </p>
         * 
         * @param duration
         *        The duration of the offering in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * The fixed price charged for this offering.
         * </p>
         * 
         * @param fixedPrice
         *        The fixed price charged for this offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedPrice(Double fixedPrice);

        /**
         * <p>
         * The hourly price charged for this offering.
         * </p>
         * 
         * @param usagePrice
         *        The hourly price charged for this offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usagePrice(Double usagePrice);

        /**
         * <p>
         * The currency code for the reserved DB instance offering.
         * </p>
         * 
         * @param currencyCode
         *        The currency code for the reserved DB instance offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The database engine used by the offering.
         * </p>
         * 
         * @param productDescription
         *        The database engine used by the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productDescription(String productDescription);

        /**
         * <p>
         * The offering type.
         * </p>
         * 
         * @param offeringType
         *        The offering type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringType(String offeringType);

        /**
         * <p>
         * Indicates whether the offering applies to Multi-AZ deployments.
         * </p>
         * 
         * @param multiAZ
         *        Indicates whether the offering applies to Multi-AZ deployments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZ(Boolean multiAZ);

        /**
         * <p>
         * The recurring price charged to run this reserved DB instance.
         * </p>
         * 
         * @param recurringCharges
         *        The recurring price charged to run this reserved DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(Collection<RecurringCharge> recurringCharges);

        /**
         * <p>
         * The recurring price charged to run this reserved DB instance.
         * </p>
         * 
         * @param recurringCharges
         *        The recurring price charged to run this reserved DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(RecurringCharge... recurringCharges);

        /**
         * <p>
         * The recurring price charged to run this reserved DB instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.RecurringCharge.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rds.model.RecurringCharge#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.RecurringCharge.Builder#build()} is called immediately and
         * its result is passed to {@link #recurringCharges(List<RecurringCharge>)}.
         * 
         * @param recurringCharges
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.RecurringCharge.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recurringCharges(java.util.Collection<RecurringCharge>)
         */
        Builder recurringCharges(Consumer<RecurringCharge.Builder>... recurringCharges);
    }

    static final class BuilderImpl implements Builder {
        private String reservedDBInstancesOfferingId;

        private String dbInstanceClass;

        private Integer duration;

        private Double fixedPrice;

        private Double usagePrice;

        private String currencyCode;

        private String productDescription;

        private String offeringType;

        private Boolean multiAZ;

        private List<RecurringCharge> recurringCharges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedDBInstancesOffering model) {
            reservedDBInstancesOfferingId(model.reservedDBInstancesOfferingId);
            dbInstanceClass(model.dbInstanceClass);
            duration(model.duration);
            fixedPrice(model.fixedPrice);
            usagePrice(model.usagePrice);
            currencyCode(model.currencyCode);
            productDescription(model.productDescription);
            offeringType(model.offeringType);
            multiAZ(model.multiAZ);
            recurringCharges(model.recurringCharges);
        }

        public final String getReservedDBInstancesOfferingId() {
            return reservedDBInstancesOfferingId;
        }

        public final void setReservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
        }

        @Override
        public final Builder reservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
            return this;
        }

        public final String getDbInstanceClass() {
            return dbInstanceClass;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final Integer getDuration() {
            return duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final Double getFixedPrice() {
            return fixedPrice;
        }

        public final void setFixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final Double getUsagePrice() {
            return usagePrice;
        }

        public final void setUsagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
        }

        @Override
        public final Builder usagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final String getProductDescription() {
            return productDescription;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        public final String getOfferingType() {
            return offeringType;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        public final Boolean getMultiAZ() {
            return multiAZ;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final List<RecurringCharge.Builder> getRecurringCharges() {
            List<RecurringCharge.Builder> result = RecurringChargeListCopier.copyToBuilder(this.recurringCharges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copyFromBuilder(recurringCharges);
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge... recurringCharges) {
            recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(Consumer<RecurringCharge.Builder>... recurringCharges) {
            recurringCharges(Stream.of(recurringCharges).map(c -> RecurringCharge.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ReservedDBInstancesOffering build() {
            return new ReservedDBInstancesOffering(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
