/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.maven.plugin.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;

public class BuildContextHolder {
    private static final Logger LOG = LoggerFactory.getLogger(BuildContextHolder.class);
    private static final String ROOT_FOLDER_NAME = ".wro4j";
    private static final String FALLBACK_STORAGE_FILE_NAME = "buildContext.properties";
    private final BuildContext buildContext;
    private final File buildDirectory;
    private Properties fallbackStorage;
    private File fallbackStorageFile;
    private boolean incrementalBuildEnabled;

    BuildContextHolder() {
        this(null, null);
    }

    public BuildContextHolder(BuildContext buildContext, File buildDirectory) {
        this.buildContext = buildContext;
        this.buildDirectory = buildDirectory == null ? FileUtils.getTempDirectory() : buildDirectory;
        try {
            this.initFallbackStorage();
        }
        catch (IOException e) {
            LOG.warn("Cannot use fallback storage: {}.", (Object)this.fallbackStorageFile, (Object)e);
        }
    }

    private void initFallbackStorage() throws IOException {
        this.fallbackStorage = new Properties();
        File rootFolder = new File(this.buildDirectory, ROOT_FOLDER_NAME);
        this.fallbackStorageFile = this.newFallbackStorageFile(rootFolder);
        if (!this.fallbackStorageFile.exists()) {
            this.fallbackStorageFile.getParentFile().mkdirs();
            this.fallbackStorageFile.createNewFile();
            LOG.debug("created fallback storage: {}", (Object)this.fallbackStorageFile);
        } else {
            this.fallbackStorage.load((InputStream)new AutoCloseInputStream((InputStream)new FileInputStream(this.fallbackStorageFile)));
            LOG.debug("loaded fallback storage: {}", (Object)this.fallbackStorage);
        }
    }

    File newFallbackStorageFile(File rootFolder) {
        return new File(rootFolder, FALLBACK_STORAGE_FILE_NAME);
    }

    File getFallbackStorageFile() {
        return this.fallbackStorageFile;
    }

    public String getValue(String key) {
        String value = null;
        if (key != null) {
            if (this.buildContext != null) {
                value = (String)this.buildContext.getValue(key);
            }
            if (value == null) {
                value = this.fallbackStorage.getProperty(key);
            }
        }
        return value;
    }

    public void setValue(String key, String value) {
        LOG.debug("storing key: '{}' and value: '{}'", (Object)key, (Object)value);
        if (key != null) {
            if (this.buildContext != null) {
                this.buildContext.setValue(key, (Object)value);
            }
            if (value != null) {
                this.fallbackStorage.setProperty(key, value);
            } else {
                this.fallbackStorage.remove(key);
            }
        } else {
            LOG.debug("Cannot store null key");
        }
    }

    public void setIncrementalBuildEnabled(boolean incrementalBuildEnabled) {
        this.incrementalBuildEnabled = incrementalBuildEnabled;
    }

    public boolean isIncrementalBuild() {
        return this.buildContext != null ? this.buildContext.isIncremental() || this.incrementalBuildEnabled : this.incrementalBuildEnabled;
    }

    public void destroy() {
        this.fallbackStorage.clear();
        FileUtils.deleteQuietly((File)this.fallbackStorageFile);
    }

    public void persist() {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(this.fallbackStorageFile);
            this.fallbackStorage.store(os, "Generated");
            LOG.debug("fallback storage written to {}", (Object)this.fallbackStorageFile);
        }
        catch (IOException e) {
            try {
                LOG.warn("Cannot persist fallback storage: {}.", (Object)this.fallbackStorageFile, (Object)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)os);
        }
        IOUtils.closeQuietly((OutputStream)os);
    }
}

