/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.mailsender;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.mailsender.MailSenderException;

public class MailMessage {
    public static final String TYPE_HTML = "html";
    public static final String TYPE_TEXT = "text";
    private Address from;
    private List toAddresses = new ArrayList();
    private List ccAddresses = new ArrayList();
    private List bccAddresses = new ArrayList();
    private String subject;
    private String content;
    private String contentType = "text";
    private Map headers = new HashMap();
    private Date sendDate;

    public Address getFrom() {
        return this.from;
    }

    public void setFrom(String mailbox, String name) throws MailSenderException {
        this.from = new Address(mailbox, name);
    }

    public void setFrom(Address from) {
        this.from = from;
    }

    public List getToAddresses() {
        return this.toAddresses;
    }

    public void addTo(String mailbox, String name) throws MailSenderException {
        this.toAddresses.add(new Address(mailbox, name));
    }

    public void addTo(Address to) throws MailSenderException {
        this.toAddresses.add(to);
    }

    public List getCcAddresses() {
        return this.ccAddresses;
    }

    public void addCc(String mailbox, String name) throws MailSenderException {
        this.ccAddresses.add(new Address(mailbox, name));
    }

    public void addCc(Address cc) throws MailSenderException {
        this.ccAddresses.add(cc);
    }

    public List getBccAddresses() {
        return this.bccAddresses;
    }

    public void addBcc(String mailbox, String name) throws MailSenderException {
        this.bccAddresses.add(new Address(mailbox, name));
    }

    public void addBcc(Address bcc) throws MailSenderException {
        this.bccAddresses.add(bcc);
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Date getSendDate() {
        return this.sendDate;
    }

    public void setSendDate(Date sendDate) {
        this.sendDate = sendDate;
    }

    public Map getHeaders() {
        return this.headers;
    }

    public void addHeader(String headerName, String headerValue) {
        this.headers.put(headerName, headerValue);
    }

    public static final class Address {
        private String mailbox;
        private String name;

        public Address(String mailbox, String name) throws MailSenderException {
            this(mailbox);
            this.name = name;
        }

        public Address(String mailbox) throws MailSenderException {
            if (mailbox == null || mailbox.trim().length() == 0) {
                throw new MailSenderException("The mailbox cannot be null.");
            }
            this.mailbox = mailbox;
        }

        public String getMailbox() {
            return this.mailbox;
        }

        public String getName() {
            return this.name;
        }

        public String getRfc2822Address() {
            if (this.name == null || this.name.trim().length() == 0) {
                return "<" + this.mailbox + ">";
            }
            return "\"" + this.name + "\" <" + this.mailbox + ">";
        }

        public String toString() {
            return this.getRfc2822Address();
        }
    }
}

