/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core.cibuild;

import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import pl.project13.core.cibuild.BuildServerDataProvider;
import pl.project13.core.log.LoggerBridge;

public class AwsCodeBuildBuildServerData
extends BuildServerDataProvider {
    AwsCodeBuildBuildServerData(LoggerBridge log, @Nonnull Map<String, String> env) {
        super(log, env);
    }

    public static boolean isActiveServer(Map<String, String> env) {
        return env.containsKey("CODEBUILD_BUILD_ARN");
    }

    @Override
    void loadBuildNumber(@Nonnull Properties properties) {
        String buildNumber = this.env.getOrDefault("CODEBUILD_BUILD_NUMBER", "");
        this.put(properties, "build.number", buildNumber);
        String buildArn = (String)this.env.get("CODEBUILD_BUILD_ID");
        this.put(properties, "build.number.unique", buildArn);
    }

    @Override
    public String getBuildBranch() {
        String environmentBasedBranch = this.env.getOrDefault("CODEBUILD_SOURCE_VERSION", "");
        this.log.info("Using environment variable based branch name. CODEBUILD_SOURCE_VERSION = {}", (Object)environmentBasedBranch);
        return environmentBasedBranch;
    }
}

