/*
 * Decompiled with CFR 0.152.
 */
package org.zkforge.apache.commons.el;

import org.zkforge.apache.commons.el.Coercions;
import org.zkforge.apache.commons.el.Expression;
import org.zkforge.apache.commons.el.Logger;
import org.zkoss.xel.XelContext;
import org.zkoss.xel.XelException;

public class ConditionalExpression
extends Expression {
    Expression mCondition;
    Expression mTrueBranch;
    Expression mFalseBranch;

    public Expression getCondition() {
        return this.mCondition;
    }

    public void setCondition(Expression pCondition) {
        this.mCondition = pCondition;
    }

    public Expression getTrueBranch() {
        return this.mTrueBranch;
    }

    public void setTrueBranch(Expression pTrueBranch) {
        this.mTrueBranch = pTrueBranch;
    }

    public Expression getFalseBranch() {
        return this.mFalseBranch;
    }

    public void setFalseBranch(Expression pFalseBranch) {
        this.mFalseBranch = pFalseBranch;
    }

    public ConditionalExpression(Expression pCondition, Expression pTrueBranch, Expression pFalseBranch) {
        this.mCondition = pCondition;
        this.mTrueBranch = pTrueBranch;
        this.mFalseBranch = pFalseBranch;
    }

    public String getExpressionString() {
        return "( " + this.mCondition.getExpressionString() + " ? " + this.mTrueBranch.getExpressionString() + " : " + this.mFalseBranch.getExpressionString() + " )";
    }

    public Object evaluate(XelContext ctx, Logger l) throws XelException {
        boolean condition = Coercions.coerceToBoolean(this.mCondition.evaluate(ctx, l), l);
        if (condition) {
            return this.mTrueBranch.evaluate(ctx, l);
        }
        return this.mFalseBranch.evaluate(ctx, l);
    }
}

