/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.util.resource;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.zkoss.lang.SystemException;
import org.zkoss.util.resource.Locator;

public class ServletContextLocator
implements Locator {
    private final ServletContext _ctx;
    private final String _dir;
    private final String _prefix;

    public ServletContextLocator(ServletContext ctx) {
        this(ctx, null, null);
    }

    public ServletContextLocator(ServletContext ctx, String dir) {
        this(ctx, dir, null);
    }

    public ServletContextLocator(ServletContext ctx, String dir, String prefix) {
        int len;
        if (ctx == null) {
            throw new IllegalArgumentException("null");
        }
        if (dir != null) {
            len = dir.length();
            if (len == 0) {
                dir = null;
            } else {
                if (dir.charAt(0) != '/') {
                    throw new IllegalArgumentException("Absolute path required: " + dir);
                }
                if (dir.charAt(len - 1) != '/') {
                    dir = dir + '/';
                }
            }
        }
        if (prefix != null) {
            len = prefix.length();
            if (len == 0) {
                prefix = null;
            } else {
                if (prefix.charAt(0) != '/') {
                    throw new IllegalArgumentException("Absolute path required: " + prefix);
                }
                if (len == 1) {
                    prefix = null;
                } else if (prefix.charAt(len - 1) == '/') {
                    prefix = prefix.substring(0, len - 1);
                }
            }
        }
        this._ctx = ctx;
        this._dir = dir;
        this._prefix = prefix;
    }

    public ServletContext getServletContext() {
        return this._ctx;
    }

    private String fixName(String name, boolean prefix) {
        name = name.length() > 0 && name.charAt(0) != '/' ? (this._dir != null ? this._dir + name : (prefix && this._prefix != null ? '/' + name : name)) : name;
        return prefix && this._prefix != null ? this._prefix + name : name;
    }

    public String getDirectory() {
        return this._dir;
    }

    public URL getResource(String name) {
        try {
            URL url = this._ctx.getResource(this.fixName(name, true));
            return url == null && this._prefix != null ? this._ctx.getResource(this.fixName(name, false)) : url;
        }
        catch (MalformedURLException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    public InputStream getResourceAsStream(String name) {
        InputStream is = this._ctx.getResourceAsStream(this.fixName(name, true));
        return is == null && this._prefix != null ? this._ctx.getResourceAsStream(this.fixName(name, false)) : is;
    }

    public int hashCode() {
        return this._ctx.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof ServletContextLocator && ((ServletContextLocator)o)._ctx.equals(this._ctx);
    }
}

