/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet.xel;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.zkoss.web.servlet.xel.AttributesMap;
import org.zkoss.web.servlet.xel.PageContext;
import org.zkoss.web.servlet.xel.StringKeysMap;
import org.zkoss.xel.ExpressionFactory;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.XelException;

public abstract class RequestXelResolver
implements VariableResolver {
    private final ServletContext _ctx;
    private final ServletRequest _request;
    private final ServletResponse _response;
    private HttpSession _sess;
    private Map _reqScope;
    private Map _sessScope;
    private Map _appScope;
    private PageContext _pc;
    private Map _cookies;

    public RequestXelResolver(ServletContext ctx, ServletRequest request, ServletResponse response) {
        this._ctx = ctx;
        this._request = request;
        this._response = response;
    }

    public RequestXelResolver(ServletContext ctx, ServletRequest request) {
        this(ctx, request, null);
    }

    public RequestXelResolver(ServletRequest request) {
        this(null, request, null);
    }

    public abstract ExpressionFactory getExpressionFactory();

    public PageContext getPageContext() {
        if (this._pc == null) {
            this._pc = new PageContextImpl();
        }
        return this._pc;
    }

    public ServletRequest getRequest() {
        return this._request;
    }

    public ServletResponse getResponse() {
        return this._response;
    }

    public ServletContext getServletContext() {
        return this._ctx;
    }

    public Object resolveVariable(String name) throws XelException {
        if ("pageContext".equals(name)) {
            return this.getPageContext();
        }
        if ("pageScope".equals(name)) {
            return Collections.EMPTY_MAP;
        }
        if ("requestScope".equals(name)) {
            return this.getRequestScope();
        }
        if ("sessionScope".equals(name)) {
            return this.getSessionScope();
        }
        if ("applicationScope".equals(name)) {
            return this.getApplicationScope();
        }
        if ("param".equals(name)) {
            return this._request != null ? new ParamMap() : Collections.EMPTY_MAP;
        }
        if ("paramValues".equals(name)) {
            return this._request != null ? this._request.getParameterMap() : Collections.EMPTY_MAP;
        }
        if ("header".equals(name)) {
            if (!(this._request instanceof HttpServletRequest)) {
                return Collections.EMPTY_MAP;
            }
            final HttpServletRequest hreq = (HttpServletRequest)this._request;
            return new AttributesMap(){

                protected Enumeration getKeys() {
                    return hreq.getHeaderNames();
                }

                protected Object getValue(String key) {
                    return hreq.getHeader(key);
                }

                protected void setValue(String key, Object val) {
                    throw new UnsupportedOperationException("readonly");
                }

                protected void removeValue(String key) {
                    throw new UnsupportedOperationException("readonly");
                }
            };
        }
        if ("headerValues".equals(name)) {
            if (!(this._request instanceof HttpServletRequest)) {
                return Collections.EMPTY_MAP;
            }
            final HttpServletRequest hreq = (HttpServletRequest)this._request;
            return new AttributesMap(){
                private final Map _values = new HashMap();

                protected Enumeration getKeys() {
                    return hreq.getHeaderNames();
                }

                protected Object getValue(String key) {
                    Object o = this._values.get(key);
                    if (o == null) {
                        Enumeration e = hreq.getHeaders(key);
                        if (e == null || !e.hasMoreElements()) {
                            return null;
                        }
                        LinkedList l = new LinkedList();
                        do {
                            l.add(e.nextElement());
                        } while (e.hasMoreElements());
                        o = l.toArray(new String[l.size()]);
                        this._values.put(key, o);
                    }
                    return o;
                }

                protected void setValue(String key, Object val) {
                    throw new UnsupportedOperationException("readonly");
                }

                protected void removeValue(String key) {
                    throw new UnsupportedOperationException("readonly");
                }
            };
        }
        if ("initParam".equals(name)) {
            if (this._ctx == null) {
                return Collections.EMPTY_MAP;
            }
            return new AttributesMap(){

                protected Enumeration getKeys() {
                    return RequestXelResolver.this._ctx.getInitParameterNames();
                }

                protected Object getValue(String key) {
                    return RequestXelResolver.this._ctx.getInitParameter(key);
                }

                protected void setValue(String key, Object val) {
                    throw new UnsupportedOperationException("readonly");
                }

                protected void removeValue(String key) {
                    throw new UnsupportedOperationException("readonly");
                }
            };
        }
        if ("cookie".equals(name)) {
            Cookie[] cookies;
            if (this._cookies != null) {
                return this._cookies;
            }
            if (!(this._request instanceof HttpServletRequest) || (cookies = ((HttpServletRequest)this._request).getCookies()) == null || cookies.length == 0) {
                return Collections.EMPTY_MAP;
            }
            this._cookies = new HashMap();
            int j = cookies.length;
            while (--j >= 0) {
                this._cookies.put(cookies[j].getName(), cookies[j]);
            }
        }
        return this.findAttribute(name);
    }

    private HttpSession getSession() {
        if (this._sess != null) {
            return this._sess;
        }
        if (!(this._request instanceof HttpServletRequest)) {
            return null;
        }
        this._sess = ((HttpServletRequest)this._request).getSession(false);
        return this._sess;
    }

    private Object findAttribute(String name) {
        Object o = this.getRequestScope().get(name);
        if (o != null) {
            return o;
        }
        o = this.getSessionScope().get(name);
        return o != null ? o : this.getApplicationScope().get(name);
    }

    private Map getRequestScope() {
        if (this._reqScope != null) {
            return this._reqScope;
        }
        if (this._request == null) {
            return Collections.EMPTY_MAP;
        }
        this._reqScope = new AttributesMap(){

            protected Enumeration getKeys() {
                return RequestXelResolver.this._request.getAttributeNames();
            }

            protected Object getValue(String key) {
                return RequestXelResolver.this._request.getAttribute(key);
            }

            protected void setValue(String key, Object val) {
                RequestXelResolver.this._request.setAttribute(key, val);
            }

            protected void removeValue(String key) {
                RequestXelResolver.this._request.removeAttribute(key);
            }
        };
        return this._reqScope;
    }

    private Map getSessionScope() {
        if (this._sessScope != null) {
            return this._sessScope;
        }
        final HttpSession sess = this.getSession();
        if (sess == null) {
            this._sessScope = Collections.EMPTY_MAP;
            return this._sessScope;
        }
        this._sessScope = new AttributesMap(){

            protected Enumeration getKeys() {
                return sess.getAttributeNames();
            }

            protected Object getValue(String key) {
                return sess.getAttribute(key);
            }

            protected void setValue(String key, Object val) {
                sess.setAttribute(key, val);
            }

            protected void removeValue(String key) {
                sess.removeAttribute(key);
            }
        };
        return this._sessScope;
    }

    private Map getApplicationScope() {
        if (this._appScope != null) {
            return this._appScope;
        }
        if (this._ctx == null) {
            this._appScope = Collections.EMPTY_MAP;
            return this._appScope;
        }
        this._appScope = new AttributesMap(){

            protected Enumeration getKeys() {
                return RequestXelResolver.this._ctx.getAttributeNames();
            }

            protected Object getValue(String key) {
                return RequestXelResolver.this._ctx.getAttribute(key);
            }

            protected void setValue(String key, Object val) {
                RequestXelResolver.this._ctx.setAttribute(key, val);
            }

            protected void removeValue(String key) {
                RequestXelResolver.this._ctx.removeAttribute(key);
            }
        };
        return this._appScope;
    }

    private class PageContextImpl
    implements PageContext {
        private PageContextImpl() {
        }

        public ServletRequest getRequest() {
            return RequestXelResolver.this._request;
        }

        public ServletResponse getResponse() {
            return RequestXelResolver.this._response;
        }

        public ServletConfig getServletConfig() {
            return null;
        }

        public ServletContext getServletContext() {
            return RequestXelResolver.this._ctx;
        }

        public HttpSession getSession() {
            return RequestXelResolver.this.getSession();
        }

        public VariableResolver getVariableResolver() {
            return RequestXelResolver.this;
        }
    }

    private class ParamMap
    extends StringKeysMap {
        private Set _entries;

        private ParamMap() {
        }

        public Set entrySet() {
            if (this._entries == null) {
                this._entries = new AbstractSet(){

                    public int size() {
                        return ParamMap.this.size();
                    }

                    public boolean contains(Object o) {
                        return ParamMap.this.containsKey(o);
                    }

                    public Iterator iterator() {
                        return new StringKeysMap.EntryIter(ParamMap.this);
                    }
                };
            }
            return this._entries;
        }

        public int size() {
            return RequestXelResolver.this._request.getParameterMap().size();
        }

        public boolean containsKey(Object key) {
            return RequestXelResolver.this._request.getParameterMap().containsKey(key);
        }

        protected Object getValue(String key) {
            return RequestXelResolver.this._request.getParameter(key);
        }

        protected Enumeration getKeys() {
            return RequestXelResolver.this._request.getParameterNames();
        }

        protected void setValue(String key, Object value) {
            throw new UnsupportedOperationException("readonly");
        }

        protected void removeValue(String key) {
            throw new UnsupportedOperationException("readonly");
        }
    }
}

