/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.io;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class Serializables {
    private Serializables() {
    }

    public static void smartWrite(ObjectOutputStream s, Map map) throws IOException {
        if (map != null) {
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                Object nm = me.getKey();
                Object val = me.getValue();
                if (!(nm instanceof Serializable) && !(nm instanceof Externalizable) || val != null && !(val instanceof Serializable) && !(val instanceof Externalizable)) continue;
                s.writeObject(nm);
                s.writeObject(val);
            }
        }
        s.writeObject(null);
    }

    public static Map smartRead(ObjectInputStream s, Map map) throws IOException, ClassNotFoundException {
        Object nm;
        while ((nm = s.readObject()) != null) {
            if (map == null) {
                map = new HashMap<Object, Object>();
            }
            map.put(nm, s.readObject());
        }
        return map;
    }

    public static void smartWrite(ObjectOutputStream s, Collection col) throws IOException {
        if (col != null) {
            Iterator it = col.iterator();
            while (it.hasNext()) {
                Object val = it.next();
                if (!(val instanceof Serializable) && !(val instanceof Externalizable)) continue;
                s.writeObject(val);
            }
        }
        s.writeObject(null);
    }

    public static Collection smartRead(ObjectInputStream s, Collection col) throws IOException, ClassNotFoundException {
        Object val;
        while ((val = s.readObject()) != null) {
            if (col == null) {
                col = new LinkedList<Object>();
            }
            col.add(val);
        }
        return col;
    }

    public static void smartWrite(ObjectOutputStream s, Object[] ary) throws IOException {
        if (ary != null) {
            for (int j = 0; j < ary.length; ++j) {
                Object val = ary[j];
                if (!(val instanceof Serializable) && !(val instanceof Externalizable)) continue;
                s.writeObject(val);
            }
        }
        s.writeObject(null);
    }
}

