/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util.media;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.zkoss.lang.Strings;
import org.zkoss.mesg.MCommon;
import org.zkoss.util.logging.Log;

public class ContentTypes {
    private static final Log log = Log.lookup(ContentTypes.class);
    private static final Map _fmt2ct = new HashMap(17);
    private static final Map _ct2fmt = new HashMap(17);

    protected ContentTypes() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getContentType(String format) {
        String ctype;
        format = format.trim().toLowerCase();
        Map map = _fmt2ct;
        synchronized (map) {
            ctype = (String)_fmt2ct.get(format);
        }
        if (ctype == null) {
            log.warning("Unknown format: " + format);
        }
        return ctype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getFormat(String ctype) {
        int j;
        String format;
        ctype = ctype.trim().toLowerCase();
        Map map = _ct2fmt;
        synchronized (map) {
            format = (String)_ct2fmt.get(ctype);
        }
        if (format == null && (j = ctype.indexOf(59)) >= 0) {
            Map map2 = _ct2fmt;
            synchronized (map2) {
                format = (String)_ct2fmt.get(ctype.substring(0, j));
            }
        }
        if (format == null) {
            log.warning("Unknown content type: " + ctype);
        }
        return format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void put(String format, String ctype) {
        if (format == null || ctype == null) {
            throw new NullPointerException("format or ctype");
        }
        Map map = _fmt2ct;
        synchronized (map) {
            _fmt2ct.put(format, ctype);
        }
        map = _ct2fmt;
        synchronized (map) {
            _ct2fmt.put(ctype, format);
        }
    }

    private static final boolean load(String flnm) {
        InputStream strm = ContentTypes.class.getResourceAsStream(flnm);
        if (strm == null) {
            return false;
        }
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(strm));
            while ((line = in.readLine()) != null) {
                int j = line.indexOf(61);
                if (j < 0) {
                    int k = Strings.skipWhitespaces(line, 0);
                    if (k >= line.length() || line.charAt(k) == '#') continue;
                    log.warning("Ignored error;  illgal format: " + line);
                    continue;
                }
                String format = line.substring(0, j).trim();
                String ctype = line.substring(j + 1).trim();
                if (format.length() == 0 || ctype.length() == 0) {
                    log.warning("Ignored error;  illgal format: " + line);
                    continue;
                }
                _fmt2ct.put(format, ctype);
                _ct2fmt.put(ctype, format);
            }
        }
        catch (IOException ex) {
            log.warning("Ingored error: Unable to read " + flnm, (Throwable)ex);
        }
        return true;
    }

    static {
        String flnm = "/metainfo/org/zkoss/util/media/contentTypes.properties";
        if (!ContentTypes.load("/metainfo/org/zkoss/util/media/contentTypes.properties")) {
            log.warning(MCommon.FILE_NOT_FOUND, "/metainfo/org/zkoss/util/media/contentTypes.properties");
        }
        ContentTypes.load("/contentTypes.properties");
    }
}

