/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.resource;

import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Document;
import org.xhtmlrenderer.resource.AbstractResource;
import org.xhtmlrenderer.resource.FSEntityResolver;
import org.xhtmlrenderer.util.Configuration;
import org.xhtmlrenderer.util.XRLog;
import org.xhtmlrenderer.util.XRRuntimeException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLResource
extends AbstractResource {
    private Document document;
    private static final XMLResourceBuilder XML_RESOURCE_BUILDER = new XMLResourceBuilder();
    private static boolean useConfiguredParser = true;

    private XMLResource(InputStream stream) {
        super(stream);
    }

    private XMLResource(InputSource source) {
        super(source);
    }

    public static XMLResource load(InputStream stream) {
        return XML_RESOURCE_BUILDER.createXMLResource(new XMLResource(stream));
    }

    public static XMLResource load(InputSource source) {
        return XML_RESOURCE_BUILDER.createXMLResource(new XMLResource(source));
    }

    public static XMLResource load(Reader reader) {
        return XML_RESOURCE_BUILDER.createXMLResource(new XMLResource(new InputSource(reader)));
    }

    public static XMLResource load(Source source) {
        return XML_RESOURCE_BUILDER.createXMLResource(source);
    }

    public Document getDocument() {
        return this.document;
    }

    void setDocument(Document document) {
        this.document = document;
    }

    public static final XMLReader newXMLReader() {
        String xmlReaderClass;
        XMLReader xmlReader;
        block12: {
            xmlReader = null;
            xmlReaderClass = Configuration.valueFor("xr.load.xml-reader");
            try {
                if (xmlReaderClass == null || xmlReaderClass.toLowerCase().equals("default") || !useConfiguredParser) break block12;
                try {
                    Class.forName(xmlReaderClass);
                }
                catch (Exception ex) {
                    useConfiguredParser = false;
                    XRLog.load(Level.WARNING, "The XMLReader class you specified as a configuration property could not be found. Class.forName() failed on " + xmlReaderClass + ". Please check classpath. Use value 'default' in FS configuration if necessary. Will now try JDK default.");
                }
                if (useConfiguredParser) {
                    xmlReader = XMLReaderFactory.createXMLReader(xmlReaderClass);
                }
            }
            catch (Exception ex) {
                XRLog.load(Level.WARNING, "Could not instantiate custom XMLReader class for XML parsing: " + xmlReaderClass + ". Please check classpath. Use value 'default' in FS configuration if necessary. Will now try JDK default.", ex);
            }
        }
        if (xmlReader == null) {
            try {
                xmlReader = XMLReaderFactory.createXMLReader();
                xmlReaderClass = "{JDK default}";
            }
            catch (Exception ex) {
                XRLog.general(ex.getMessage());
            }
        }
        if (xmlReader == null) {
            try {
                XRLog.load(Level.WARNING, "falling back on the default parser");
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                xmlReader = parser.getXMLReader();
                xmlReaderClass = "SAXParserFactory default";
            }
            catch (Exception ex) {
                XRLog.general(ex.getMessage());
            }
        }
        if (xmlReader == null) {
            throw new XRRuntimeException("Could not instantiate any SAX 2 parser, including JDK default. The name of the class to use should have been read from the org.xml.sax.driver System property, which is set to: ");
        }
        XRLog.load("SAX XMLReader in use (parser): " + xmlReader.getClass().getName());
        return xmlReader;
    }

    private static class XMLResourceBuilder {
        private static ThreadLocal<Reference<DocumentBuilder>> domParser = new ThreadLocal();

        private XMLResourceBuilder() {
        }

        private DocumentBuilder getDocumentBuilder() {
            DocumentBuilder parser = null;
            Reference<DocumentBuilder> ref = domParser.get();
            if (ref != null) {
                parser = ref.get();
            }
            if (parser == null) {
                try {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    dbf.setValidating(false);
                    parser = dbf.newDocumentBuilder();
                }
                catch (Exception ex) {
                    throw new XRRuntimeException("Failed on configuring DOM parser.", ex);
                }
                this.addHandlers(parser);
                domParser.set(new SoftReference<DocumentBuilder>(parser));
            }
            return parser;
        }

        XMLResource createXMLResource(XMLResource target) {
            Document document;
            long st = System.currentTimeMillis();
            DocumentBuilder parser = this.getDocumentBuilder();
            try {
                document = parser.parse(target.getResourceInputSource());
            }
            catch (Exception ex) {
                throw new XRRuntimeException("Can't load the XML resource (using DOM parser). " + ex.getMessage(), ex);
            }
            long end = System.currentTimeMillis();
            target.setElapsedLoadTime(end - st);
            XRLog.load("Loaded document in ~" + target.getElapsedLoadTime() + "ms");
            target.setDocument(document);
            return target;
        }

        private void addHandlers(DocumentBuilder parser) {
            parser.setEntityResolver(FSEntityResolver.instance());
            parser.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException ex) {
                    XRLog.load(ex.getMessage());
                }

                @Override
                public void fatalError(SAXParseException ex) {
                    XRLog.load(ex.getMessage());
                }

                @Override
                public void warning(SAXParseException ex) {
                    XRLog.load(ex.getMessage());
                }
            });
        }

        public XMLResource createXMLResource(Source source) {
            Transformer idTransform;
            DOMResult output = new DOMResult();
            long st = System.currentTimeMillis();
            try {
                TransformerFactory xformFactory = TransformerFactory.newInstance();
                xformFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                xformFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                idTransform = xformFactory.newTransformer();
            }
            catch (Exception ex) {
                throw new XRRuntimeException("Failed on configuring TRaX transformer.", ex);
            }
            try {
                idTransform.transform(source, output);
            }
            catch (Exception ex) {
                throw new XRRuntimeException("Can't load the XML resource (using TRaX transformer). " + ex.getMessage(), ex);
            }
            long end = System.currentTimeMillis();
            XMLResource target = new XMLResource(null);
            target.setElapsedLoadTime(end - st);
            XRLog.load("Loaded document in ~" + target.getElapsedLoadTime() + "ms");
            target.setDocument((Document)output.getNode());
            return target;
        }
    }
}

