/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.context;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import org.xhtmlrenderer.css.extend.StylesheetFactory;
import org.xhtmlrenderer.css.parser.CSSErrorHandler;
import org.xhtmlrenderer.css.parser.CSSParser;
import org.xhtmlrenderer.css.sheet.Ruleset;
import org.xhtmlrenderer.css.sheet.Stylesheet;
import org.xhtmlrenderer.css.sheet.StylesheetInfo;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.resource.CSSResource;
import org.xhtmlrenderer.util.XRLog;
import org.xhtmlrenderer.util.XRRuntimeException;

public class StylesheetFactoryImpl
implements StylesheetFactory {
    private UserAgentCallback _userAgent;
    private int _cacheCapacity = 16;
    private LinkedHashMap _cache = new LinkedHashMap(this._cacheCapacity, 0.75f, true){
        private static final long serialVersionUID = 1L;

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > StylesheetFactoryImpl.this._cacheCapacity;
        }
    };
    private CSSParser _cssParser;

    public StylesheetFactoryImpl(UserAgentCallback userAgent) {
        this._userAgent = userAgent;
        this._cssParser = new CSSParser(new CSSErrorHandler(){

            public void error(String uri, String message) {
                XRLog.cssParse(Level.WARNING, "(" + uri + ") " + message);
            }
        });
    }

    public synchronized Stylesheet parse(Reader reader, StylesheetInfo info) {
        try {
            return this._cssParser.parseStylesheet(info.getUri(), info.getOrigin(), reader);
        }
        catch (IOException e) {
            throw new XRRuntimeException("IOException on parsing style seet from a Reader; don't know the URI.", e);
        }
    }

    private Stylesheet parse(StylesheetInfo info) {
        CSSResource cr = this._userAgent.getCSSResource(info.getUri());
        InputStream is = cr.getResourceInputSource().getByteStream();
        Stylesheet sheet = null;
        try {
            if (is != null) {
                sheet = this.parse(new InputStreamReader(is, "UTF-8"), info);
            }
        }
        catch (Exception e) {
            this.debugBadStyleSheet(info);
            if (e instanceof XRRuntimeException) {
                throw (XRRuntimeException)e;
            }
            throw new XRRuntimeException("Failed on parsing CSS sheet at " + info.getUri(), e);
        }
        return sheet;
    }

    private void debugBadStyleSheet(StylesheetInfo info) {
        InputStream is = this._userAgent.getCSSResource(info.getUri()).getResourceInputSource().getByteStream();
        if (is != null) {
            try {
                InputStreamReader r = new InputStreamReader(is);
                LineNumberReader lnr = new LineNumberReader(new BufferedReader(r));
                StringBuffer sb = new StringBuffer();
                String line = null;
                while ((line = lnr.readLine()) != null) {
                    sb.append(line + "\n");
                }
                XRLog.cssParse(sb.toString());
            }
            catch (Exception ex) {
                XRLog.cssParse("Failed to read CSS sheet at " + info.getUri() + " for debugging.");
            }
        }
    }

    public synchronized Ruleset parseStyleDeclaration(int origin, String styleDeclaration) {
        return this._cssParser.parseDeclaration(origin, styleDeclaration);
    }

    public synchronized void putStylesheet(Object key, Stylesheet sheet) {
        this._cache.put(key, sheet);
    }

    public synchronized boolean containsStylesheet(Object key) {
        return this._cache.containsKey(key);
    }

    public synchronized Stylesheet getCachedStylesheet(Object key) {
        return (Stylesheet)this._cache.get(key);
    }

    public synchronized Object removeCachedStylesheet(Object key) {
        return this._cache.remove(key);
    }

    public synchronized void flushCachedStylesheets() {
        this._cache.clear();
    }

    public Stylesheet getStylesheet(StylesheetInfo info) {
        XRLog.load("Requesting stylesheet: " + info.getUri());
        Stylesheet s = this.getCachedStylesheet(info.getUri());
        if (s == null && !this.containsStylesheet(info.getUri())) {
            s = this.parse(info);
            this.putStylesheet(info.getUri(), s);
        }
        return s;
    }
}

