/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.connector.ByteBufferPool;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.servlet.api.CrawlerSessionManagerConfig;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletStackTraces;
import io.undertow.servlet.api.SessionPersistenceManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.CapabilityServiceTarget;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.AbstractPersistentSessionManager;
import org.wildfly.extension.undertow.AffinityCookieDefinition;
import org.wildfly.extension.undertow.BufferCacheService;
import org.wildfly.extension.undertow.CookieConfig;
import org.wildfly.extension.undertow.CrawlerSessionManagementDefinition;
import org.wildfly.extension.undertow.JSPConfig;
import org.wildfly.extension.undertow.JspDefinition;
import org.wildfly.extension.undertow.MimeMappingDefinition;
import org.wildfly.extension.undertow.PersistentSessionsDefinition;
import org.wildfly.extension.undertow.ServletContainerDefinition;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.SessionCookieDefinition;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.WebsocketsDefinition;
import org.xnio.XnioWorker;

final class ServletContainerAdd
extends AbstractBoottimeAddStepHandler {
    ServletContainerAdd() {
        super(ServletContainerDefinition.ATTRIBUTES);
    }

    protected void performBoottime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ServletContainerAdd.installRuntimeServices(context.getCapabilityServiceTarget(), (ExpressionResolver)context, context.getCurrentAddress(), Resource.Tools.readModel((Resource)resource));
    }

    static void installRuntimeServices(CapabilityServiceTarget target, ExpressionResolver resolver, PathAddress address, ModelNode model) throws OperationFailedException {
        final CookieConfig sessionCookieConfig = SessionCookieDefinition.getConfig(resolver, model.get(SessionCookieDefinition.PATH_ELEMENT.getKeyValuePair()));
        final CookieConfig affinityCookieConfig = AffinityCookieDefinition.getConfig(resolver, model.get(AffinityCookieDefinition.PATH_ELEMENT.getKeyValuePair()));
        final CrawlerSessionManagerConfig crawlerSessionManagerConfig = CrawlerSessionManagementDefinition.getConfig(resolver, model.get(CrawlerSessionManagementDefinition.PATH_ELEMENT.getKeyValuePair()));
        boolean persistentSessions = PersistentSessionsDefinition.isEnabled(model.get(PersistentSessionsDefinition.PATH_ELEMENT.getKeyValuePair()));
        final boolean allowNonStandardWrappers = ServletContainerDefinition.ALLOW_NON_STANDARD_WRAPPERS.resolveModelAttribute(resolver, model).asBoolean();
        final boolean proactiveAuth = ServletContainerDefinition.PROACTIVE_AUTHENTICATION.resolveModelAttribute(resolver, model).asBoolean();
        String bufferCache = ServletContainerDefinition.DEFAULT_BUFFER_CACHE.resolveModelAttribute(resolver, model).asString();
        final boolean disableFileWatchService = ServletContainerDefinition.DISABLE_FILE_WATCH_SERVICE.resolveModelAttribute(resolver, model).asBoolean();
        final boolean disableSessionIdReususe = ServletContainerDefinition.DISABLE_SESSION_ID_REUSE.resolveModelAttribute(resolver, model).asBoolean();
        final JSPConfig jspConfig = JspDefinition.getConfig(resolver, model.get(JspDefinition.PATH_ELEMENT.getKeyValuePair()));
        String stackTracesString = ServletContainerDefinition.STACK_TRACE_ON_ERROR.resolveModelAttribute(resolver, model).asString();
        ModelNode defaultEncodingValue = ServletContainerDefinition.DEFAULT_ENCODING.resolveModelAttribute(resolver, model);
        final String defaultEncoding = defaultEncodingValue.isDefined() ? defaultEncodingValue.asString() : null;
        final boolean useListenerEncoding = ServletContainerDefinition.USE_LISTENER_ENCODING.resolveModelAttribute(resolver, model).asBoolean();
        final boolean ignoreFlush = ServletContainerDefinition.IGNORE_FLUSH.resolveModelAttribute(resolver, model).asBoolean();
        final boolean eagerFilterInit = ServletContainerDefinition.EAGER_FILTER_INIT.resolveModelAttribute(resolver, model).asBoolean();
        final boolean disableCachingForSecuredPages = ServletContainerDefinition.DISABLE_CACHING_FOR_SECURED_PAGES.resolveModelAttribute(resolver, model).asBoolean();
        final int sessionIdLength = ServletContainerDefinition.SESSION_ID_LENGTH.resolveModelAttribute(resolver, model).asInt();
        final int fileCacheMetadataSize = ServletContainerDefinition.FILE_CACHE_METADATA_SIZE.resolveModelAttribute(resolver, model).asInt();
        final int fileCacheMaxFileSize = ServletContainerDefinition.FILE_CACHE_MAX_FILE_SIZE.resolveModelAttribute(resolver, model).asInt();
        ModelNode fileCacheTtlNode = ServletContainerDefinition.FILE_CACHE_TIME_TO_LIVE.resolveModelAttribute(resolver, model);
        final Integer fileCacheTimeToLive = fileCacheTtlNode.isDefined() ? Integer.valueOf(fileCacheTtlNode.asInt()) : null;
        final int defaultCookieVersion = ServletContainerDefinition.DEFAULT_COOKIE_VERSION.resolveModelAttribute(resolver, model).asInt();
        final boolean preservePathOnForward = ServletContainerDefinition.PRESERVE_PATH_ON_FORWARD.resolveModelAttribute(resolver, model).asBoolean();
        final boolean orphanSessionAllowed = ServletContainerDefinition.ORPHAN_SESSION_ALLOWED.resolveModelAttribute(resolver, model).asBoolean();
        final Boolean directoryListingEnabled = ServletContainerDefinition.DIRECTORY_LISTING.resolveModelAttribute(resolver, model).asBooleanOrNull();
        final Integer maxSessions = ServletContainerDefinition.MAX_SESSIONS.resolveModelAttribute(resolver, model).asIntOrNull();
        final int sessionTimeout = ServletContainerDefinition.DEFAULT_SESSION_TIMEOUT.resolveModelAttribute(resolver, model).asInt();
        final WebsocketsDefinition.WebSocketInfo webSocketInfo = WebsocketsDefinition.getConfig(resolver, model.get(WebsocketsDefinition.PATH_ELEMENT.getKeyValuePair()));
        final Map<String, String> mimeMappings = ServletContainerAdd.resolveMimeMappings(resolver, model);
        final List<String> welcomeFiles = ServletContainerAdd.resolveWelcomeFiles(model);
        CapabilityServiceBuilder builder = target.addCapability(ServletContainerDefinition.SERVLET_CONTAINER_CAPABILITY);
        final Supplier sessionPersistenceManager = persistentSessions ? builder.requires(AbstractPersistentSessionManager.SERVICE_NAME) : null;
        final Supplier directBufferCache = bufferCache != null ? builder.requires(BufferCacheService.SERVICE_NAME.append(new String[]{bufferCache})) : null;
        final Supplier byteBufferPool = webSocketInfo != null ? builder.requiresCapability("org.wildfly.undertow.byte-buffer-pool", ByteBufferPool.class, new String[]{webSocketInfo.getBufferPool()}) : null;
        final Supplier xnioWorker = webSocketInfo != null ? builder.requiresCapability("org.wildfly.io.worker", XnioWorker.class, new String[]{webSocketInfo.getWorker()}) : null;
        final ServletStackTraces traces = ServletStackTraces.valueOf((String)stackTracesString.toUpperCase().replace('-', '_'));
        final ServletContainer container = ServletContainer.Factory.newInstance();
        ServletContainerService service = new ServletContainerService(){

            @Override
            public ServletContainer getServletContainer() {
                return container;
            }

            @Override
            public boolean isAllowNonStandardWrappers() {
                return allowNonStandardWrappers;
            }

            @Override
            public JSPConfig getJspConfig() {
                return jspConfig;
            }

            @Override
            public ServletStackTraces getStackTraces() {
                return traces;
            }

            @Override
            public CookieConfig getSessionCookieConfig() {
                return sessionCookieConfig;
            }

            @Override
            public CookieConfig getAffinityCookieConfig() {
                return affinityCookieConfig;
            }

            @Override
            public DirectBufferCache getBufferCache() {
                return directBufferCache != null ? (DirectBufferCache)directBufferCache.get() : null;
            }

            @Override
            public boolean isDisableCachingForSecuredPages() {
                return disableCachingForSecuredPages;
            }

            @Override
            public boolean isDispatchWebsocketInvocationToWorker() {
                return webSocketInfo != null && webSocketInfo.isDispatchToWorker();
            }

            @Override
            public boolean isPerMessageDeflate() {
                return webSocketInfo != null && webSocketInfo.isPerMessageDeflate();
            }

            @Override
            public int getDeflaterLevel() {
                return webSocketInfo != null ? webSocketInfo.getDeflaterLevel() : -1;
            }

            @Override
            public boolean isWebsocketsEnabled() {
                return webSocketInfo != null;
            }

            @Override
            public boolean isDisableSessionIdReuse() {
                return disableSessionIdReususe;
            }

            @Override
            public SessionPersistenceManager getSessionPersistenceManager() {
                return sessionPersistenceManager != null ? (SessionPersistenceManager)sessionPersistenceManager.get() : null;
            }

            @Override
            public XnioWorker getWebsocketsWorker() {
                return xnioWorker != null ? (XnioWorker)xnioWorker.get() : null;
            }

            @Override
            public ByteBufferPool getWebsocketsBufferPool() {
                return byteBufferPool != null ? (ByteBufferPool)byteBufferPool.get() : null;
            }

            @Override
            public String getDefaultEncoding() {
                return defaultEncoding;
            }

            @Override
            public boolean isUseListenerEncoding() {
                return useListenerEncoding;
            }

            @Override
            public boolean isIgnoreFlush() {
                return ignoreFlush;
            }

            @Override
            public boolean isEagerFilterInit() {
                return eagerFilterInit;
            }

            @Override
            public int getDefaultSessionTimeout() {
                return sessionTimeout;
            }

            @Override
            public Map<String, String> getMimeMappings() {
                return mimeMappings;
            }

            @Override
            public List<String> getWelcomeFiles() {
                return welcomeFiles;
            }

            @Override
            public Boolean getDirectoryListingEnabled() {
                return directoryListingEnabled;
            }

            @Override
            public boolean isProactiveAuth() {
                return proactiveAuth;
            }

            @Override
            public int getSessionIdLength() {
                return sessionIdLength;
            }

            @Override
            public Integer getMaxSessions() {
                return maxSessions;
            }

            @Override
            public boolean isDisableFileWatchService() {
                return disableFileWatchService;
            }

            @Override
            public CrawlerSessionManagerConfig getCrawlerSessionManagerConfig() {
                return crawlerSessionManagerConfig;
            }

            @Override
            public int getFileCacheMetadataSize() {
                return fileCacheMetadataSize;
            }

            @Override
            public int getFileCacheMaxFileSize() {
                return fileCacheMaxFileSize;
            }

            @Override
            public Integer getFileCacheTimeToLive() {
                return fileCacheTimeToLive;
            }

            @Override
            public int getDefaultCookieVersion() {
                return defaultCookieVersion;
            }

            @Override
            public boolean isPreservePathOnForward() {
                return preservePathOnForward;
            }

            @Override
            public boolean isOrphanSessionAllowed() {
                return orphanSessionAllowed;
            }
        };
        builder.setInstance(Service.newInstance((Consumer)builder.provides(ServletContainerDefinition.SERVLET_CONTAINER_CAPABILITY, UndertowService.SERVLET_CONTAINER.append(new String[]{address.getLastElement().getValue()}), new ServiceName[0]), (Object)service));
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private static Map<String, String> resolveMimeMappings(ExpressionResolver resolver, ModelNode model) throws OperationFailedException {
        if (!model.hasDefined("mime-mapping")) {
            return Map.of();
        }
        List properties = model.get("mime-mapping").asPropertyList();
        if (properties.size() == 1) {
            Map.Entry<String, String> entry = ServletContainerAdd.resolveMimeMapping(resolver, (Property)properties.get(0));
            return Map.of(entry.getKey(), entry.getValue());
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Property property : properties) {
            Map.Entry<String, String> entry = ServletContainerAdd.resolveMimeMapping(resolver, property);
            result.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    private static Map.Entry<String, String> resolveMimeMapping(ExpressionResolver resolver, Property property) throws OperationFailedException {
        return Map.entry(property.getName(), MimeMappingDefinition.VALUE.resolveModelAttribute(resolver, property.getValue()).asString());
    }

    private static List<String> resolveWelcomeFiles(ModelNode model) {
        if (!model.hasDefined("welcome-file")) {
            return List.of();
        }
        List properties = model.get("welcome-file").asPropertyList();
        if (properties.size() == 1) {
            return List.of(((Property)properties.get(0)).getName());
        }
        ArrayList<String> result = new ArrayList<String>(properties.size());
        for (Property property : properties) {
            result.add(property.getName());
        }
        return Collections.unmodifiableList(result);
    }
}

