/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.dynamic.ssl;

import java.net.URI;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.dynamic.ssl.DynamicSSLContextException;
import org.wildfly.security.dynamic.ssl.DynamicSSLContextSPI;
import org.wildfly.security.dynamic.ssl.ElytronMessages;

public class DynamicSSLContextImpl
implements DynamicSSLContextSPI {
    private final AuthenticationContextConfigurationClient AUTH_CONTEXT_CLIENT = AccessController.doPrivileged(AuthenticationContextConfigurationClient::new);
    private AuthenticationContext authenticationContext;
    private SSLContext configuredDefaultSSLContext;
    private List<SSLContext> configuredSSLContexts;

    public DynamicSSLContextImpl() throws GeneralSecurityException {
    }

    public DynamicSSLContextImpl(AuthenticationContext authenticationContext) throws GeneralSecurityException {
        Assert.checkNotNullParam((String)"authenticationContext", (Object)authenticationContext);
        this.authenticationContext = authenticationContext;
        this.configuredSSLContexts = this.AUTH_CONTEXT_CLIENT.getConfiguredSSLContexts(authenticationContext);
        this.configuredDefaultSSLContext = this.AUTH_CONTEXT_CLIENT.getDefaultSSLContext(authenticationContext);
    }

    @Override
    public SSLContext getConfiguredDefault() throws DynamicSSLContextException {
        if (this.configuredDefaultSSLContext != null) {
            return this.configuredDefaultSSLContext;
        }
        try {
            return this.AUTH_CONTEXT_CLIENT.getDefaultSSLContext(AuthenticationContext.captureCurrent());
        }
        catch (GeneralSecurityException e) {
            throw ElytronMessages.log.cannotObtainDefaultSSLContext(e);
        }
    }

    @Override
    public List<SSLContext> getConfiguredSSLContexts() throws DynamicSSLContextException {
        if (this.configuredSSLContexts != null) {
            return this.configuredSSLContexts;
        }
        try {
            return this.AUTH_CONTEXT_CLIENT.getConfiguredSSLContexts(AuthenticationContext.captureCurrent());
        }
        catch (GeneralSecurityException e) {
            throw ElytronMessages.log.cannotObtainConfiguredSSLContexts(e);
        }
    }

    @Override
    public SSLContext getSSLContext(URI uri) throws DynamicSSLContextException {
        try {
            return this.AUTH_CONTEXT_CLIENT.getSSLContext(uri, this.authenticationContext == null ? AuthenticationContext.captureCurrent() : this.authenticationContext);
        }
        catch (GeneralSecurityException e) {
            throw ElytronMessages.log.cannotObtainSSLContextForGivenURI(e);
        }
    }
}

