/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.boot.actuate;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.EndpointWebExtension;
import org.springframework.lang.Nullable;
import org.togglz.core.Feature;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.metadata.FeatureMetaData;
import org.togglz.core.repository.FeatureState;
import org.togglz.spring.boot.actuate.AbstractTogglzEndpoint;
import org.togglz.spring.boot.actuate.TogglzEndpoint;
import org.togglz.spring.boot.actuate.autoconfigure.TogglzFeature;
import org.togglz.spring.boot.actuate.autoconfigure.TogglzFeatureMetaData;

@EndpointWebExtension(endpoint=TogglzEndpoint.class)
public class TogglzEndpointWebExtension
extends AbstractTogglzEndpoint {
    private final Logger log = LoggerFactory.getLogger(TogglzEndpointWebExtension.class);

    public TogglzEndpointWebExtension(FeatureManager featureManager) {
        super(featureManager);
    }

    @WriteOperation
    public WebEndpointResponse<TogglzFeature> setFeatureState(@Selector String name, @Nullable Boolean enabled, @Nullable String strategy, @Nullable String parameters) {
        Feature feature = this.findFeature(name);
        if (feature == null) {
            return new WebEndpointResponse(404);
        }
        try {
            Map<String, String> parametersMap = this.parseParameterMap(parameters);
            FeatureState featureState = this.changeFeatureStatus(feature, enabled, strategy, parametersMap);
            FeatureMetaData metaData = this.featureManager.getMetaData(feature);
            return new WebEndpointResponse((Object)new TogglzFeature(feature, featureState, new TogglzFeatureMetaData(metaData)));
        }
        catch (IllegalArgumentException exception) {
            this.log.debug("Illegal params format in togglz endpoint.", (Throwable)exception);
            return new WebEndpointResponse(400);
        }
    }
}

