/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.context;

import java.util.concurrent.ConcurrentHashMap;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.spi.FeatureManagerProvider;

public class ContextClassLoaderFeatureManagerProvider
implements FeatureManagerProvider {
    private static final ConcurrentHashMap<ClassLoader, FeatureManager> managerMap = new ConcurrentHashMap();

    @Override
    public int priority() {
        return 100;
    }

    @Override
    public FeatureManager getFeatureManager() {
        return managerMap.get(ContextClassLoaderFeatureManagerProvider.contextClassLoader());
    }

    public static void bind(FeatureManager featureManager) {
        FeatureManager old = managerMap.putIfAbsent(ContextClassLoaderFeatureManagerProvider.contextClassLoader(), featureManager);
        if (old != null) {
            throw new IllegalStateException("There is already a FeatureManager associated with the context ClassLoader of the current thread!");
        }
    }

    public static void release() {
        managerMap.remove(ContextClassLoaderFeatureManagerProvider.contextClassLoader());
    }

    private static ClassLoader contextClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            throw new IllegalStateException("Unable to get the context class loader for the current thread!");
        }
        return classLoader;
    }
}

