/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.jooq.codegen.database;

import java.util.Optional;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.MariaDBContainer;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.jooq.codegen.database.DatabaseProps;
import org.testcontainers.jooq.codegen.database.DatabaseType;
import org.testcontainers.utility.DockerImageName;

public class DatabaseProvider {
    public static JdbcDatabaseContainer<?> getDatabaseContainer(DatabaseProps props) {
        PostgreSQLContainer container;
        DatabaseType dbType = props.getType();
        String image = Optional.ofNullable(props.getContainerImage()).orElse(dbType.getDefaultImage());
        switch (dbType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case POSTGRES: {
                PostgreSQLContainer postgreSQLContainer = new PostgreSQLContainer(DockerImageName.parse((String)image).asCompatibleSubstituteFor("postgres"));
                break;
            }
            case MARIADB: {
                PostgreSQLContainer postgreSQLContainer = new MariaDBContainer(DockerImageName.parse((String)image).asCompatibleSubstituteFor("mariadb"));
                break;
            }
            case MYSQL: {
                PostgreSQLContainer postgreSQLContainer = container = new MySQLContainer(DockerImageName.parse((String)image).asCompatibleSubstituteFor("mysql"));
            }
        }
        if (DatabaseProvider.isNotEmpty(props.getUsername())) {
            container.withUsername(props.getUsername());
        }
        if (DatabaseProvider.isNotEmpty(props.getPassword())) {
            container.withPassword(props.getPassword());
        }
        if (DatabaseProvider.isNotEmpty(props.getDatabaseName())) {
            container.withDatabaseName(props.getDatabaseName());
        }
        return container;
    }

    private static boolean isNotEmpty(String str) {
        return !DatabaseProvider.isEmpty(str);
    }

    private static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }
}

