/*
 * Decompiled with CFR 0.152.
 */
package tachyon.org.jets3t.service.security;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tachyon.org.jets3t.service.Constants;
import tachyon.org.jets3t.service.ServiceException;
import tachyon.org.jets3t.service.security.AWSCredentials;
import tachyon.org.jets3t.service.security.AWSDevPayCredentials;
import tachyon.org.jets3t.service.security.EncryptionUtil;
import tachyon.org.jets3t.service.utils.ServiceUtils;

public abstract class ProviderCredentials {
    protected static final Log log = LogFactory.getLog(ProviderCredentials.class);
    protected static final int CREDENTIALS_STORAGE_VERSION = 3;
    protected static final String V2_KEYS_DELIMITER = "AWSKEYS";
    protected static final String V3_KEYS_DELIMITER = "\n";
    protected String accessKey = null;
    protected String secretKey = null;
    protected String friendlyName = null;

    public ProviderCredentials(String accessKey, String secretKey) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    public ProviderCredentials(String accessKey, String secretKey, String friendlyName) {
        this(accessKey, secretKey);
        this.friendlyName = friendlyName;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public boolean hasFriendlyName() {
        return this.friendlyName != null && this.friendlyName.trim().length() > 0;
    }

    public String getLogString() {
        return this.getAccessKey() + " : " + this.getSecretKey();
    }

    protected String getDataToEncrypt() {
        return this.getAccessKey() + V3_KEYS_DELIMITER + this.getSecretKey();
    }

    protected abstract String getTypeName();

    protected abstract String getVersionPrefix();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String password, File file, String algorithm) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            this.save(password, fos, algorithm);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public void save(String password, File file) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, IOException {
        this.save(password, file, "PBEWithMD5AndDES");
    }

    public void save(String password, OutputStream outputStream, String algorithm) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, IOException {
        BufferedOutputStream bufferedOS = null;
        EncryptionUtil encryptionUtil = new EncryptionUtil(password, algorithm, "2");
        bufferedOS = new BufferedOutputStream(outputStream);
        byte[] encryptedData = encryptionUtil.encrypt(this.getDataToEncrypt());
        bufferedOS.write((this.getVersionPrefix() + 3 + V3_KEYS_DELIMITER).getBytes(Constants.DEFAULT_ENCODING));
        bufferedOS.write((encryptionUtil.getAlgorithm() + V3_KEYS_DELIMITER).getBytes(Constants.DEFAULT_ENCODING));
        bufferedOS.write(((this.friendlyName == null ? "" : this.friendlyName) + V3_KEYS_DELIMITER).getBytes(Constants.DEFAULT_ENCODING));
        bufferedOS.write((this.getTypeName() + V3_KEYS_DELIMITER).getBytes(Constants.DEFAULT_ENCODING));
        bufferedOS.write(encryptedData);
        bufferedOS.flush();
    }

    public void save(String password, OutputStream outputStream) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, IOException {
        this.save(password, outputStream, "PBEWithMD5AndDES");
    }

    public static ProviderCredentials load(String password, File file) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading credentials from file: " + file.getAbsolutePath()));
        }
        BufferedInputStream fileIS = null;
        try {
            fileIS = new BufferedInputStream(new FileInputStream(file));
            ProviderCredentials providerCredentials = ProviderCredentials.load(password, fileIS);
            return providerCredentials;
        }
        catch (Throwable t) {
            throw new ServiceException("Failed to load credentials", t);
        }
        finally {
            if (fileIS != null) {
                try {
                    fileIS.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ProviderCredentials load(String password, BufferedInputStream inputStream) throws ServiceException {
        boolean partialReadOnly;
        boolean bl = partialReadOnly = password == null;
        if (partialReadOnly) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Loading partial information about credentials from input stream");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Loading credentials from input stream");
        }
        try {
            int expectedParts;
            Object credentialsType;
            EncryptionUtil encryptionUtil = null;
            byte[] encryptedKeys = new byte[2048];
            int encryptedDataIndex = 0;
            String version = null;
            int versionNum = 0;
            String algorithm = "";
            String friendlyName = "";
            boolean usingDevPay = false;
            version = ServiceUtils.readInputStreamLineToString(inputStream, Constants.DEFAULT_ENCODING);
            int firstColonOffset = version.indexOf(":");
            String versionString = version.substring(firstColonOffset + 1).trim();
            versionNum = Integer.parseInt(versionString);
            algorithm = ServiceUtils.readInputStreamLineToString(inputStream, Constants.DEFAULT_ENCODING);
            friendlyName = ServiceUtils.readInputStreamLineToString(inputStream, Constants.DEFAULT_ENCODING);
            if (!partialReadOnly) {
                encryptionUtil = new EncryptionUtil(password, algorithm, "2");
            }
            if (3 <= versionNum) {
                credentialsType = ServiceUtils.readInputStreamLineToString(inputStream, Constants.DEFAULT_ENCODING);
                usingDevPay = "devpay".equals(credentialsType);
            }
            if (partialReadOnly) {
                if (usingDevPay) {
                    credentialsType = new AWSDevPayCredentials(null, null, friendlyName);
                    return credentialsType;
                }
                credentialsType = new AWSCredentials(null, null, friendlyName);
                return credentialsType;
            }
            encryptedDataIndex = inputStream.read(encryptedKeys);
            String keys = encryptionUtil.decryptString(encryptedKeys, 0, encryptedDataIndex);
            String[] parts = keys.split(3 <= versionNum ? V3_KEYS_DELIMITER : V2_KEYS_DELIMITER);
            int n = expectedParts = usingDevPay ? 4 : 2;
            if (parts.length != expectedParts) {
                throw new Exception("Number of parts (" + parts.length + ") did not match the expected number of parts (" + expectedParts + ") for this version (" + versionNum + ")");
            }
            if (usingDevPay) {
                AWSDevPayCredentials aWSDevPayCredentials = new AWSDevPayCredentials(parts[0], parts[1], parts[2], parts[3], friendlyName);
                return aWSDevPayCredentials;
            }
            AWSCredentials aWSCredentials = new AWSCredentials(parts[0], parts[1], friendlyName);
            return aWSCredentials;
        }
        catch (BadPaddingException bpe) {
            throw new ServiceException("Unable to decrypt credentials. Is your password correct?", bpe);
        }
        catch (Throwable t) {
            throw new ServiceException("Failed to load credentials", t);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

