/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.core.Ordered;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.ws.server.EndpointInvocationChain;
import org.springframework.ws.server.EndpointMapping;
import org.springframework.ws.server.SmartEndpointInterceptor;

public abstract class AbstractEndpointMapping
extends ApplicationObjectSupport
implements EndpointMapping,
Ordered {
    private int order = Integer.MAX_VALUE;
    private Object defaultEndpoint;
    private EndpointInterceptor[] interceptors;
    private SmartEndpointInterceptor[] smartInterceptors;

    public EndpointInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    public final void setInterceptors(EndpointInterceptor[] interceptors) {
        this.interceptors = interceptors;
    }

    public final int getOrder() {
        return this.order;
    }

    public final void setOrder(int order) {
        this.order = order;
    }

    protected void initApplicationContext() throws BeansException {
        this.initInterceptors();
    }

    protected void initInterceptors() {
        Map smartInterceptors = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), SmartEndpointInterceptor.class, (boolean)true, (boolean)false);
        if (!smartInterceptors.isEmpty()) {
            this.smartInterceptors = smartInterceptors.values().toArray(new SmartEndpointInterceptor[smartInterceptors.size()]);
        }
    }

    public final EndpointInvocationChain getEndpoint(MessageContext messageContext) throws Exception {
        String endpointName;
        Object endpoint = this.getEndpointInternal(messageContext);
        if (endpoint == null) {
            endpoint = this.defaultEndpoint;
        }
        if (endpoint == null) {
            return null;
        }
        if (endpoint instanceof String && (endpoint = this.resolveStringEndpoint(endpointName = (String)endpoint)) == null) {
            return null;
        }
        ArrayList<EndpointInterceptor> interceptors = new ArrayList<EndpointInterceptor>();
        if (this.interceptors != null) {
            interceptors.addAll(Arrays.asList(this.interceptors));
        }
        if (this.smartInterceptors != null) {
            for (SmartEndpointInterceptor smartInterceptor : this.smartInterceptors) {
                if (!smartInterceptor.shouldIntercept(messageContext, endpoint)) continue;
                interceptors.add(smartInterceptor);
            }
        }
        return this.createEndpointInvocationChain(messageContext, endpoint, interceptors.toArray(new EndpointInterceptor[interceptors.size()]));
    }

    protected EndpointInvocationChain createEndpointInvocationChain(MessageContext messageContext, Object endpoint, EndpointInterceptor[] interceptors) {
        return new EndpointInvocationChain(endpoint, interceptors);
    }

    protected final Object getDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    public final void setDefaultEndpoint(Object defaultEndpoint) {
        this.defaultEndpoint = defaultEndpoint;
    }

    protected Object resolveStringEndpoint(String endpointName) {
        if (this.getApplicationContext().containsBean(endpointName)) {
            return this.getApplicationContext().getBean(endpointName);
        }
        return null;
    }

    protected abstract Object getEndpointInternal(MessageContext var1) throws Exception;
}

