/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.interceptor;

import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.ws.server.SmartEndpointInterceptor;

public class DelegatingSmartEndpointInterceptor
implements SmartEndpointInterceptor {
    private final EndpointInterceptor delegate;

    public DelegatingSmartEndpointInterceptor(EndpointInterceptor delegate) {
        Assert.notNull((Object)delegate, (String)"'delegate' must not be null");
        this.delegate = delegate;
    }

    protected EndpointInterceptor getDelegate() {
        return this.delegate;
    }

    public boolean shouldIntercept(MessageContext messageContext, Object endpoint) {
        WebServiceMessage request = messageContext.getRequest();
        return request != null && this.shouldIntercept(request, endpoint);
    }

    protected boolean shouldIntercept(WebServiceMessage request, Object endpoint) {
        return true;
    }

    public boolean handleRequest(MessageContext messageContext, Object endpoint) throws Exception {
        return this.getDelegate().handleRequest(messageContext, endpoint);
    }

    public boolean handleResponse(MessageContext messageContext, Object endpoint) throws Exception {
        return this.getDelegate().handleResponse(messageContext, endpoint);
    }

    public boolean handleFault(MessageContext messageContext, Object endpoint) throws Exception {
        return this.getDelegate().handleFault(messageContext, endpoint);
    }
}

