/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.config;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.ws.server.SmartEndpointInterceptor;
import org.springframework.ws.soap.server.endpoint.interceptor.DelegatingSmartSoapEndpointInterceptor;
import org.springframework.ws.soap.server.endpoint.interceptor.PayloadRootSmartSoapEndpointInterceptor;
import org.springframework.ws.soap.server.endpoint.interceptor.SoapActionSmartEndpointInterceptor;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InterceptorsBeanDefinitionParser
implements BeanDefinitionParser {
    InterceptorsBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        CompositeComponentDefinition compDefinition = new CompositeComponentDefinition(element.getTagName(), parserContext.extractSource((Object)element));
        parserContext.pushContainingComponent(compDefinition);
        List childElements = DomUtils.getChildElements((Element)element);
        for (Element childElement : childElements) {
            BeanReference interceptorRef;
            RootBeanDefinition smartInterceptorDef;
            List refElements;
            BeanDefinitionHolder interceptorDef;
            RootBeanDefinition smartInterceptorDef2;
            List beanElements;
            RootBeanDefinition smartInterceptorDef3;
            if ("bean".equals(childElement.getLocalName())) {
                smartInterceptorDef3 = this.createSmartInterceptorDefinition(DelegatingSmartSoapEndpointInterceptor.class, childElement, parserContext);
                BeanDefinitionHolder interceptorDef2 = this.createInterceptorDefinition(parserContext, childElement);
                smartInterceptorDef3.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)interceptorDef2);
                this.registerSmartInterceptor(parserContext, smartInterceptorDef3);
                continue;
            }
            if ("ref".equals(childElement.getLocalName())) {
                smartInterceptorDef3 = this.createSmartInterceptorDefinition(DelegatingSmartSoapEndpointInterceptor.class, childElement, parserContext);
                BeanReference interceptorRef2 = this.createInterceptorReference(parserContext, childElement);
                smartInterceptorDef3.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)interceptorRef2);
                this.registerSmartInterceptor(parserContext, smartInterceptorDef3);
                continue;
            }
            if ("payloadRoot".equals(childElement.getLocalName())) {
                beanElements = DomUtils.getChildElementsByTagName((Element)childElement, (String)"bean");
                for (Element beanElement : beanElements) {
                    smartInterceptorDef2 = this.createSmartInterceptorDefinition(PayloadRootSmartSoapEndpointInterceptor.class, childElement, parserContext);
                    interceptorDef = this.createInterceptorDefinition(parserContext, beanElement);
                    String namespaceUri = childElement.getAttribute("namespaceUri");
                    String localPart = childElement.getAttribute("localPart");
                    smartInterceptorDef2.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)interceptorDef);
                    smartInterceptorDef2.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)namespaceUri);
                    smartInterceptorDef2.getConstructorArgumentValues().addIndexedArgumentValue(2, (Object)localPart);
                    this.registerSmartInterceptor(parserContext, smartInterceptorDef2);
                }
                refElements = DomUtils.getChildElementsByTagName((Element)childElement, (String)"ref");
                for (Element refElement : refElements) {
                    smartInterceptorDef = this.createSmartInterceptorDefinition(PayloadRootSmartSoapEndpointInterceptor.class, childElement, parserContext);
                    interceptorRef = this.createInterceptorReference(parserContext, refElement);
                    String namespaceUri = childElement.getAttribute("namespaceUri");
                    String localPart = childElement.getAttribute("localPart");
                    smartInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)interceptorRef);
                    smartInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)namespaceUri);
                    smartInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(2, (Object)localPart);
                    this.registerSmartInterceptor(parserContext, smartInterceptorDef);
                }
                continue;
            }
            if (!"soapAction".equals(childElement.getLocalName())) continue;
            beanElements = DomUtils.getChildElementsByTagName((Element)childElement, (String)"bean");
            for (Element beanElement : beanElements) {
                smartInterceptorDef2 = this.createSmartInterceptorDefinition(SoapActionSmartEndpointInterceptor.class, childElement, parserContext);
                interceptorDef = this.createInterceptorDefinition(parserContext, beanElement);
                String soapAction = childElement.getAttribute("value");
                smartInterceptorDef2.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)interceptorDef);
                smartInterceptorDef2.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)soapAction);
                this.registerSmartInterceptor(parserContext, smartInterceptorDef2);
            }
            refElements = DomUtils.getChildElementsByTagName((Element)childElement, (String)"ref");
            for (Element refElement : refElements) {
                smartInterceptorDef = this.createSmartInterceptorDefinition(SoapActionSmartEndpointInterceptor.class, childElement, parserContext);
                interceptorRef = this.createInterceptorReference(parserContext, refElement);
                String soapAction = childElement.getAttribute("value");
                smartInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)interceptorRef);
                smartInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)soapAction);
                this.registerSmartInterceptor(parserContext, smartInterceptorDef);
            }
        }
        parserContext.popAndRegisterContainingComponent();
        return null;
    }

    private void registerSmartInterceptor(ParserContext parserContext, RootBeanDefinition smartInterceptorDef) {
        String mappedInterceptorName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)smartInterceptorDef);
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)smartInterceptorDef, mappedInterceptorName));
    }

    private BeanDefinitionHolder createInterceptorDefinition(ParserContext parserContext, Element element) {
        BeanDefinitionHolder interceptorDef = parserContext.getDelegate().parseBeanDefinitionElement(element);
        interceptorDef = parserContext.getDelegate().decorateBeanDefinitionIfRequired(element, interceptorDef);
        return interceptorDef;
    }

    private BeanReference createInterceptorReference(ParserContext parserContext, Element element) {
        String refName = element.getAttribute("bean");
        if (!StringUtils.hasLength((String)refName) && !StringUtils.hasLength((String)(refName = element.getAttribute("local")))) {
            this.error(parserContext, "Either 'bean' or 'local' is required for <ref> element", element);
            return null;
        }
        if (!StringUtils.hasText((String)refName)) {
            this.error(parserContext, "<ref> element contains empty target attribute", element);
            return null;
        }
        RuntimeBeanReference ref = new RuntimeBeanReference(refName);
        ref.setSource(parserContext.extractSource((Object)element));
        return ref;
    }

    private RootBeanDefinition createSmartInterceptorDefinition(Class<? extends SmartEndpointInterceptor> interceptorClass, Element element, ParserContext parserContext) {
        RootBeanDefinition smartInterceptorDef = new RootBeanDefinition(interceptorClass);
        smartInterceptorDef.setSource(parserContext.extractSource((Object)element));
        smartInterceptorDef.setRole(2);
        return smartInterceptorDef;
    }

    private void error(ParserContext parserContext, String message, Object source) {
        parserContext.getDelegate().getReaderContext().error(message, source);
    }
}

