/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.servlet.resource.ResourceResolverChain;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.springframework.web.servlet.resource.ResourceTransformerChain;

class DefaultResourceTransformerChain
implements ResourceTransformerChain {
    private final ResourceResolverChain resolverChain;
    private final List<ResourceTransformer> transformers = new ArrayList<ResourceTransformer>();
    private int index = -1;

    public DefaultResourceTransformerChain(ResourceResolverChain resolverChain, @Nullable List<ResourceTransformer> transformers) {
        Assert.notNull((Object)resolverChain, (String)"ResourceResolverChain is required");
        this.resolverChain = resolverChain;
        if (transformers != null) {
            this.transformers.addAll(transformers);
        }
    }

    @Override
    public ResourceResolverChain getResolverChain() {
        return this.resolverChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource transform(HttpServletRequest request, Resource resource) throws IOException {
        ResourceTransformer transformer = this.getNext();
        if (transformer == null) {
            return resource;
        }
        try {
            Resource resource2 = transformer.transform(request, resource, this);
            return resource2;
        }
        finally {
            --this.index;
        }
    }

    @Nullable
    private ResourceTransformer getNext() {
        Assert.state((this.index <= this.transformers.size() ? 1 : 0) != 0, (String)"Current index exceeds the number of configured ResourceTransformers");
        if (this.index == this.transformers.size() - 1) {
            return null;
        }
        ++this.index;
        return this.transformers.get(this.index);
    }
}

