/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.script;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.NamedThreadLocal;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.script.ScriptTemplateConfig;

public class ScriptTemplateView
extends AbstractUrlBasedView {
    public static final String DEFAULT_CONTENT_TYPE = "text/html";
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final String DEFAULT_RESOURCE_LOADER_PATH = "classpath:";
    private final ThreadLocal<ScriptEngine> engineHolder = new NamedThreadLocal("ScriptTemplateView engine");
    private ScriptEngine engine;
    private String engineName;
    private Boolean sharedEngine;
    private String[] scripts;
    private String renderObject;
    private String renderFunction;
    private Charset charset;
    private ResourceLoader resourceLoader;
    private String resourceLoaderPath;

    public ScriptTemplateView() {
        this.setContentType(null);
    }

    public ScriptTemplateView(String url) {
        super(url);
        this.setContentType(null);
    }

    public void setEngine(ScriptEngine engine) {
        Assert.isInstanceOf(Invocable.class, (Object)engine);
        this.engine = engine;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public void setSharedEngine(Boolean sharedEngine) {
        this.sharedEngine = sharedEngine;
    }

    public void setScripts(String ... scripts) {
        this.scripts = scripts;
    }

    public void setRenderObject(String renderObject) {
        this.renderObject = renderObject;
    }

    public void setRenderFunction(String functionName) {
        this.renderFunction = functionName;
    }

    @Override
    public void setContentType(String contentType) {
        super.setContentType(contentType);
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setResourceLoaderPath(String resourceLoaderPath) {
        this.resourceLoaderPath = resourceLoaderPath;
    }

    protected void initApplicationContext(ApplicationContext context) {
        super.initApplicationContext(context);
        ScriptTemplateConfig viewConfig = this.autodetectViewConfig();
        if (this.engine == null && viewConfig.getEngine() != null) {
            this.setEngine(viewConfig.getEngine());
        }
        if (this.engineName == null && viewConfig.getEngineName() != null) {
            this.engineName = viewConfig.getEngineName();
        }
        if (this.scripts == null && viewConfig.getScripts() != null) {
            this.scripts = viewConfig.getScripts();
        }
        if (this.renderObject == null && viewConfig.getRenderObject() != null) {
            this.renderObject = viewConfig.getRenderObject();
        }
        if (this.renderFunction == null && viewConfig.getRenderFunction() != null) {
            this.renderFunction = viewConfig.getRenderFunction();
        }
        if (this.getContentType() == null) {
            this.setContentType(viewConfig.getContentType() != null ? viewConfig.getContentType() : DEFAULT_CONTENT_TYPE);
        }
        if (this.charset == null) {
            Charset charset = this.charset = viewConfig.getCharset() != null ? viewConfig.getCharset() : DEFAULT_CHARSET;
        }
        if (this.resourceLoaderPath == null) {
            String string = this.resourceLoaderPath = viewConfig.getResourceLoaderPath() != null ? viewConfig.getResourceLoaderPath() : DEFAULT_RESOURCE_LOADER_PATH;
        }
        if (this.resourceLoader == null) {
            this.resourceLoader = new DefaultResourceLoader(this.createClassLoader());
        }
        if (this.sharedEngine == null && viewConfig.isSharedEngine() != null) {
            this.sharedEngine = viewConfig.isSharedEngine();
        }
        Assert.isTrue((this.engine == null || this.engineName == null ? 1 : 0) != 0, (String)"You should define either 'engine' or 'engineName', not both.");
        Assert.isTrue((this.engine != null || this.engineName != null ? 1 : 0) != 0, (String)"No script engine found, please specify either 'engine' or 'engineName'.");
        if (Boolean.FALSE.equals(this.sharedEngine)) {
            Assert.isTrue((this.engineName != null ? 1 : 0) != 0, (String)"When 'sharedEngine' is set to false, you should specify the script engine using the 'engineName' property, not the 'engine' one.");
        } else if (this.engine != null) {
            this.loadScripts(this.engine);
        } else {
            this.setEngine(this.createEngineFromName());
        }
        Assert.isTrue((this.renderFunction != null ? 1 : 0) != 0, (String)"The 'renderFunction' property must be defined.");
    }

    protected ScriptEngine getEngine() {
        if (Boolean.FALSE.equals(this.sharedEngine)) {
            ScriptEngine engine = this.engineHolder.get();
            if (engine == null) {
                engine = this.createEngineFromName();
                this.engineHolder.set(engine);
            }
            return engine;
        }
        return this.engine;
    }

    protected ScriptEngine createEngineFromName() {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName(this.engineName);
        if (engine == null) {
            throw new IllegalStateException("No engine with name '" + this.engineName + "' found");
        }
        this.loadScripts(engine);
        return engine;
    }

    protected void loadScripts(ScriptEngine engine) {
        if (this.scripts != null) {
            try {
                for (String script : this.scripts) {
                    Resource resource = this.resourceLoader.getResource(script);
                    if (!resource.exists()) {
                        throw new IllegalStateException("Resource " + script + " not found");
                    }
                    engine.eval(new InputStreamReader(resource.getInputStream()));
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to load script", ex);
            }
        }
    }

    protected ClassLoader createClassLoader() {
        String[] paths = StringUtils.commaDelimitedListToStringArray((String)this.resourceLoaderPath);
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (String path : paths) {
                Resource[] resources = this.getApplicationContext().getResources(path);
                if (resources.length <= 0) continue;
                for (Resource resource : resources) {
                    if (!resource.exists()) continue;
                    urls.add(resource.getURL());
                }
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot create class loader: " + ex.getMessage());
        }
        ClassLoader classLoader = this.getApplicationContext().getClassLoader();
        return urls.size() > 0 ? new URLClassLoader(urls.toArray(new URL[urls.size()]), classLoader) : classLoader;
    }

    protected ScriptTemplateConfig autodetectViewConfig() throws BeansException {
        try {
            return (ScriptTemplateConfig)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), ScriptTemplateConfig.class, (boolean)true, (boolean)false);
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new ApplicationContextException("Expected a single ScriptTemplateConfig bean in the current Servlet web application context or the parent root context: ScriptTemplateConfigurer is the usual implementation. This bean may have any name.", (Throwable)ex);
        }
    }

    @Override
    protected void prepareResponse(HttpServletRequest request, HttpServletResponse response) {
        super.prepareResponse(request, response);
        this.setResponseContentType(request, response);
        response.setCharacterEncoding(this.charset.name());
    }

    @Override
    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Object html;
            ScriptEngine engine = this.getEngine();
            Invocable invocable = (Invocable)((Object)engine);
            String template = this.getTemplate(this.getUrl());
            if (this.renderObject != null) {
                Object thiz = engine.eval(this.renderObject);
                html = invocable.invokeMethod(thiz, this.renderFunction, template, model);
            } else {
                html = invocable.invokeFunction(this.renderFunction, template, model);
            }
            response.getWriter().write(String.valueOf(html));
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to render script template", ex);
        }
    }

    protected String getTemplate(String path) throws IOException {
        Resource resource = this.resourceLoader.getResource(path);
        return StreamUtils.copyToString((InputStream)resource.getInputStream(), (Charset)this.charset);
    }
}

