/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.SpringProperties;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.test.context.TestConstructor;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.support.PropertyProvider;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public abstract class TestConstructorUtils {
    private static final Log logger = LogFactory.getLog(TestConstructorUtils.class);
    private static final Set<Class<? extends Annotation>> autowiredAnnotationTypes = CollectionUtils.newLinkedHashSet((int)2);

    private TestConstructorUtils() {
    }

    @Deprecated(since="6.2.13", forRemoval=true)
    public static boolean isAutowirableConstructor(Executable executable, Class<?> testClass) {
        return TestConstructorUtils.isAutowirableConstructor(executable, testClass, null);
    }

    @Deprecated(since="6.2.13", forRemoval=true)
    public static boolean isAutowirableConstructor(Constructor<?> constructor, Class<?> testClass) {
        return TestConstructorUtils.isAutowirableConstructor(constructor, testClass, null);
    }

    @Deprecated(since="6.2.13", forRemoval=true)
    public static boolean isAutowirableConstructor(Executable executable, Class<?> testClass, @Nullable PropertyProvider fallbackPropertyProvider) {
        Constructor constructor;
        return executable instanceof Constructor && TestConstructorUtils.isAutowirableConstructor(constructor = (Constructor)executable, testClass, fallbackPropertyProvider);
    }

    @Deprecated(since="6.2.13", forRemoval=true)
    public static boolean isAutowirableConstructor(Constructor<?> constructor, Class<?> testClass, @Nullable PropertyProvider fallbackPropertyProvider) {
        return TestConstructorUtils.isAutowirableConstructorInternal(constructor, testClass, fallbackPropertyProvider);
    }

    public static boolean isAutowirableConstructor(Executable executable, @Nullable PropertyProvider fallbackPropertyProvider) {
        Constructor constructor;
        return executable instanceof Constructor && TestConstructorUtils.isAutowirableConstructorInternal(constructor = (Constructor)executable, constructor.getDeclaringClass(), fallbackPropertyProvider);
    }

    private static boolean isAutowirableConstructorInternal(Constructor<?> constructor, Class<?> testClass, @Nullable PropertyProvider fallbackPropertyProvider) {
        TestConstructor.AutowireMode autowireMode;
        if (TestConstructorUtils.isAnnotatedWithAutowiredOrInject(constructor)) {
            return true;
        }
        TestConstructor testConstructor = TestContextAnnotationUtils.findMergedAnnotation(testClass, TestConstructor.class);
        if (testConstructor != null) {
            autowireMode = testConstructor.autowireMode();
        } else {
            String value = SpringProperties.getProperty((String)"spring.test.constructor.autowire.mode");
            autowireMode = TestConstructor.AutowireMode.from(value);
            if (autowireMode == null && fallbackPropertyProvider != null) {
                value = fallbackPropertyProvider.get("spring.test.constructor.autowire.mode");
                autowireMode = TestConstructor.AutowireMode.from(value);
            }
        }
        return autowireMode == TestConstructor.AutowireMode.ALL;
    }

    private static boolean isAnnotatedWithAutowiredOrInject(Constructor<?> constructor) {
        return autowiredAnnotationTypes.stream().anyMatch(annotationType -> AnnotatedElementUtils.hasAnnotation((AnnotatedElement)constructor, (Class)annotationType));
    }

    static {
        autowiredAnnotationTypes.add(Autowired.class);
        ClassLoader classLoader = TestConstructorUtils.class.getClassLoader();
        try {
            autowiredAnnotationTypes.add(ClassUtils.forName((String)"jakarta.inject.Inject", (ClassLoader)classLoader));
            logger.trace((Object)"'jakarta.inject.Inject' annotation found and supported for autowiring");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

