/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting.support;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.cglib.asm.Type;
import net.sf.cglib.core.Signature;
import net.sf.cglib.proxy.InterfaceMaker;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.Conventions;
import org.springframework.core.Ordered;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.scripting.ScriptFactory;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.RefreshableScriptTargetSource;
import org.springframework.scripting.support.ResourceScriptSource;
import org.springframework.scripting.support.StaticScriptSource;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ScriptFactoryPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements BeanClassLoaderAware,
BeanFactoryAware,
ResourceLoaderAware,
DisposableBean,
Ordered {
    public static final String INLINE_SCRIPT_PREFIX = "inline:";
    public static final String REFRESH_CHECK_DELAY_ATTRIBUTE = Conventions.getQualifiedAttributeName((Class)(class$org$springframework$scripting$support$ScriptFactoryPostProcessor == null ? (class$org$springframework$scripting$support$ScriptFactoryPostProcessor = ScriptFactoryPostProcessor.class$("org.springframework.scripting.support.ScriptFactoryPostProcessor")) : class$org$springframework$scripting$support$ScriptFactoryPostProcessor), (String)"refreshCheckDelay");
    private static final String SCRIPT_FACTORY_NAME_PREFIX = "scriptFactory.";
    private static final String SCRIPTED_OBJECT_NAME_PREFIX = "scriptedObject.";
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private long defaultRefreshCheckDelay = -1L;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private AbstractBeanFactory beanFactory;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    final DefaultListableBeanFactory scriptBeanFactory = new DefaultListableBeanFactory();
    private final Map scriptSourceCache = new HashMap();
    static /* synthetic */ Class class$org$springframework$scripting$support$ScriptFactoryPostProcessor;
    static /* synthetic */ Class class$org$springframework$scripting$ScriptFactory;
    static /* synthetic */ Class class$org$springframework$aop$TargetSource;

    public void setDefaultRefreshCheckDelay(long defaultRefreshCheckDelay) {
        this.defaultRefreshCheckDelay = defaultRefreshCheckDelay;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (!(beanFactory instanceof AbstractBeanFactory)) {
            throw new IllegalStateException("ScriptFactoryPostProcessor must run in AbstractBeanFactory, not in " + beanFactory);
        }
        this.beanFactory = (AbstractBeanFactory)beanFactory;
        this.scriptBeanFactory.setParentBeanFactory((BeanFactory)this.beanFactory);
        this.scriptBeanFactory.copyConfigurationFrom((ConfigurableBeanFactory)this.beanFactory);
        Iterator it = this.scriptBeanFactory.getBeanPostProcessors().iterator();
        while (it.hasNext()) {
            BeanPostProcessor postProcessor = (BeanPostProcessor)it.next();
            if (!(postProcessor instanceof AopInfrastructureBean)) continue;
            it.remove();
        }
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public Class predictBeanType(Class beanClass, String beanName) {
        Class scriptedType;
        Object[] interfaces;
        String scriptedObjectBeanName;
        RootBeanDefinition bd;
        block6: {
            if (!(class$org$springframework$scripting$ScriptFactory == null ? (class$org$springframework$scripting$ScriptFactory = ScriptFactoryPostProcessor.class$("org.springframework.scripting.ScriptFactory")) : class$org$springframework$scripting$ScriptFactory).isAssignableFrom(beanClass)) {
                return null;
            }
            bd = this.beanFactory.getMergedBeanDefinition(beanName);
            String scriptFactoryBeanName = SCRIPT_FACTORY_NAME_PREFIX + beanName;
            scriptedObjectBeanName = SCRIPTED_OBJECT_NAME_PREFIX + beanName;
            this.prepareScriptBeans(bd, scriptFactoryBeanName, scriptedObjectBeanName);
            ScriptFactory scriptFactory = (ScriptFactory)this.scriptBeanFactory.getBean(scriptFactoryBeanName, class$org$springframework$scripting$ScriptFactory == null ? (class$org$springframework$scripting$ScriptFactory = ScriptFactoryPostProcessor.class$("org.springframework.scripting.ScriptFactory")) : class$org$springframework$scripting$ScriptFactory);
            ScriptSource scriptSource = this.getScriptSource(scriptFactoryBeanName, scriptFactory.getScriptSourceLocator());
            interfaces = scriptFactory.getScriptInterfaces();
            scriptedType = null;
            try {
                scriptedType = scriptFactory.getScriptedObjectType(scriptSource);
            }
            catch (Exception ex) {
                if (!this.logger.isDebugEnabled()) break block6;
                this.logger.debug((Object)("Could not determine the scripted object type for script factory [" + scriptFactory + "]"), (Throwable)ex);
            }
        }
        if (scriptedType != null) {
            return scriptedType;
        }
        if (ObjectUtils.isEmpty((Object[])interfaces)) {
            if (bd.isSingleton()) {
                return this.scriptBeanFactory.getBean(scriptedObjectBeanName).getClass();
            }
            return null;
        }
        return interfaces.length == 1 ? interfaces[0] : this.createCompositeInterface((Class[])interfaces);
    }

    public Object postProcessBeforeInstantiation(Class beanClass, String beanName) {
        if (!(class$org$springframework$scripting$ScriptFactory == null ? (class$org$springframework$scripting$ScriptFactory = ScriptFactoryPostProcessor.class$("org.springframework.scripting.ScriptFactory")) : class$org$springframework$scripting$ScriptFactory).isAssignableFrom(beanClass)) {
            return null;
        }
        RootBeanDefinition bd = this.beanFactory.getMergedBeanDefinition(beanName);
        String scriptFactoryBeanName = SCRIPT_FACTORY_NAME_PREFIX + beanName;
        String scriptedObjectBeanName = SCRIPTED_OBJECT_NAME_PREFIX + beanName;
        this.prepareScriptBeans(bd, scriptFactoryBeanName, scriptedObjectBeanName);
        long refreshCheckDelay = this.resolveRefreshCheckDelay((BeanDefinition)bd);
        if (refreshCheckDelay >= 0L) {
            ScriptFactory scriptFactory = (ScriptFactory)this.scriptBeanFactory.getBean(scriptFactoryBeanName, class$org$springframework$scripting$ScriptFactory == null ? (class$org$springframework$scripting$ScriptFactory = ScriptFactoryPostProcessor.class$("org.springframework.scripting.ScriptFactory")) : class$org$springframework$scripting$ScriptFactory);
            ScriptSource scriptSource = this.getScriptSource(scriptFactoryBeanName, scriptFactory.getScriptSourceLocator());
            Class[] interfaces = scriptFactory.getScriptInterfaces();
            RefreshableScriptTargetSource ts = new RefreshableScriptTargetSource((BeanFactory)this.scriptBeanFactory, scriptedObjectBeanName, scriptSource);
            ts.setRefreshCheckDelay(refreshCheckDelay);
            return this.createRefreshableProxy((TargetSource)ts, interfaces);
        }
        return this.scriptBeanFactory.getBean(scriptedObjectBeanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareScriptBeans(RootBeanDefinition bd, String scriptFactoryBeanName, String scriptedObjectBeanName) {
        DefaultListableBeanFactory defaultListableBeanFactory = this.scriptBeanFactory;
        synchronized (defaultListableBeanFactory) {
            if (!this.scriptBeanFactory.containsBeanDefinition(scriptedObjectBeanName)) {
                Object[] interfaces;
                this.scriptBeanFactory.registerBeanDefinition(scriptFactoryBeanName, (BeanDefinition)this.createScriptFactoryBeanDefinition(bd));
                ScriptFactory scriptFactory = (ScriptFactory)this.scriptBeanFactory.getBean(scriptFactoryBeanName, class$org$springframework$scripting$ScriptFactory == null ? (class$org$springframework$scripting$ScriptFactory = ScriptFactoryPostProcessor.class$("org.springframework.scripting.ScriptFactory")) : class$org$springframework$scripting$ScriptFactory);
                ScriptSource scriptSource = this.getScriptSource(scriptFactoryBeanName, scriptFactory.getScriptSourceLocator());
                Object[] scriptedInterfaces = interfaces = scriptFactory.getScriptInterfaces();
                if (scriptFactory.requiresConfigInterface() && !bd.getPropertyValues().isEmpty()) {
                    Class configInterface = this.createConfigInterface(bd, (Class[])interfaces);
                    scriptedInterfaces = (Class[])ObjectUtils.addObjectToArray((Object[])interfaces, (Object)configInterface);
                }
                RootBeanDefinition objectBd = this.createScriptedObjectBeanDefinition(bd, scriptFactoryBeanName, scriptSource, (Class[])scriptedInterfaces);
                long refreshCheckDelay = this.resolveRefreshCheckDelay((BeanDefinition)bd);
                if (refreshCheckDelay >= 0L) {
                    objectBd.setSingleton(false);
                }
                this.scriptBeanFactory.registerBeanDefinition(scriptedObjectBeanName, (BeanDefinition)objectBd);
            }
        }
    }

    protected long resolveRefreshCheckDelay(BeanDefinition beanDefinition) {
        long refreshCheckDelay = this.defaultRefreshCheckDelay;
        Object attributeValue = beanDefinition.getAttribute(REFRESH_CHECK_DELAY_ATTRIBUTE);
        if (attributeValue instanceof Number) {
            refreshCheckDelay = ((Number)attributeValue).longValue();
        } else if (attributeValue instanceof String) {
            refreshCheckDelay = Long.parseLong((String)attributeValue);
        } else if (attributeValue != null) {
            throw new BeanDefinitionStoreException("Invalid refresh check delay attribute [" + REFRESH_CHECK_DELAY_ATTRIBUTE + "] with value [" + attributeValue + "]: needs to be of type Number or String");
        }
        return refreshCheckDelay;
    }

    protected RootBeanDefinition createScriptFactoryBeanDefinition(RootBeanDefinition bd) {
        RootBeanDefinition scriptBd = new RootBeanDefinition();
        scriptBd.setBeanClassName(bd.getBeanClassName());
        scriptBd.getConstructorArgumentValues().addArgumentValues(bd.getConstructorArgumentValues());
        return scriptBd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScriptSource getScriptSource(String beanName, String scriptSourceLocator) {
        Map map = this.scriptSourceCache;
        synchronized (map) {
            ScriptSource scriptSource = (ScriptSource)this.scriptSourceCache.get(beanName);
            if (scriptSource == null) {
                scriptSource = this.convertToScriptSource(scriptSourceLocator, this.resourceLoader);
                this.scriptSourceCache.put(beanName, scriptSource);
            }
            return scriptSource;
        }
    }

    protected ScriptSource convertToScriptSource(String scriptSourceLocator, ResourceLoader resourceLoader) {
        if (scriptSourceLocator.startsWith(INLINE_SCRIPT_PREFIX)) {
            return new StaticScriptSource(scriptSourceLocator.substring(INLINE_SCRIPT_PREFIX.length()));
        }
        return new ResourceScriptSource(resourceLoader.getResource(scriptSourceLocator));
    }

    protected Class createConfigInterface(RootBeanDefinition bd, Class[] interfaces) {
        InterfaceMaker maker = new InterfaceMaker();
        PropertyValue[] pvs = bd.getPropertyValues().getPropertyValues();
        for (int i = 0; i < pvs.length; ++i) {
            String propertyName = pvs[i].getName();
            Class propertyType = BeanUtils.findPropertyType((String)propertyName, (Class[])interfaces);
            String setterName = "set" + StringUtils.capitalize((String)propertyName);
            Signature signature = new Signature(setterName, Type.VOID_TYPE, new Type[]{Type.getType((Class)propertyType)});
            maker.add(signature, new Type[0]);
        }
        if (bd.getInitMethodName() != null) {
            Signature signature = new Signature(bd.getInitMethodName(), Type.VOID_TYPE, new Type[0]);
            maker.add(signature, new Type[0]);
        }
        if (bd.getDestroyMethodName() != null) {
            Signature signature = new Signature(bd.getDestroyMethodName(), Type.VOID_TYPE, new Type[0]);
            maker.add(signature, new Type[0]);
        }
        return maker.create();
    }

    protected Class createCompositeInterface(Class[] interfaces) {
        return ClassUtils.createCompositeInterface((Class[])interfaces, (ClassLoader)this.beanClassLoader);
    }

    protected RootBeanDefinition createScriptedObjectBeanDefinition(RootBeanDefinition bd, String scriptFactoryBeanName, ScriptSource scriptSource, Class[] interfaces) {
        RootBeanDefinition objectBd = new RootBeanDefinition(bd);
        objectBd.setFactoryBeanName(scriptFactoryBeanName);
        objectBd.setFactoryMethodName("getScriptedObject");
        objectBd.getConstructorArgumentValues().clear();
        objectBd.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)scriptSource);
        objectBd.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)interfaces);
        return objectBd;
    }

    protected Object createRefreshableProxy(TargetSource ts, Class[] interfaces) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTargetSource(ts);
        if (interfaces == null) {
            interfaces = ClassUtils.getAllInterfacesForClass((Class)ts.getTargetClass());
        }
        proxyFactory.setInterfaces(interfaces);
        DelegatingIntroductionInterceptor introduction = new DelegatingIntroductionInterceptor((Object)ts);
        introduction.suppressInterface(class$org$springframework$aop$TargetSource == null ? (class$org$springframework$aop$TargetSource = ScriptFactoryPostProcessor.class$("org.springframework.aop.TargetSource")) : class$org$springframework$aop$TargetSource);
        proxyFactory.addAdvice((Advice)introduction);
        return proxyFactory.getProxy(this.beanClassLoader);
    }

    public void destroy() {
        this.scriptBeanFactory.destroySingletons();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

