/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.target.LazyInitTargetSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Constants;
import org.springframework.jmx.export.MBeanExporterListener;
import org.springframework.jmx.export.assembler.AutodetectCapableMBeanInfoAssembler;
import org.springframework.jmx.export.assembler.MBeanInfoAssembler;
import org.springframework.jmx.export.assembler.SimpleReflectiveMBeanInfoAssembler;
import org.springframework.jmx.export.naming.KeyNamingStrategy;
import org.springframework.jmx.export.naming.ObjectNamingStrategy;
import org.springframework.jmx.export.naming.SelfNaming;
import org.springframework.jmx.support.JmxUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class MBeanExporter
implements BeanFactoryAware,
InitializingBean,
DisposableBean {
    public static final int REGISTRATION_FAIL_ON_EXISTING = 0;
    public static final int REGISTRATION_IGNORE_EXISTING = 1;
    public static final int REGISTRATION_REPLACE_EXISTING = 2;
    private static final String MR_TYPE_OBJECT_REFERENCE = "ObjectReference";
    private static final Constants constants = new Constants(class$org$springframework$jmx$export$MBeanExporter == null ? (class$org$springframework$jmx$export$MBeanExporter = MBeanExporter.class$("org.springframework.jmx.export.MBeanExporter")) : class$org$springframework$jmx$export$MBeanExporter);
    protected final Log logger = LogFactory.getLog(this.getClass());
    private MBeanServer server;
    private Map beans;
    private boolean autodetect = false;
    private Set excludedBeans;
    private MBeanInfoAssembler assembler = new SimpleReflectiveMBeanInfoAssembler();
    private ObjectNamingStrategy namingStrategy = new KeyNamingStrategy();
    private ListableBeanFactory beanFactory;
    private Set registeredBeans;
    private MBeanExporterListener[] listeners;
    private int registrationBehavior = 0;
    static /* synthetic */ Class class$org$springframework$jmx$export$MBeanExporter;

    public void setServer(MBeanServer server) {
        this.server = server;
    }

    public void setBeans(Map beans) {
        this.beans = beans;
    }

    public void setAutodetect(boolean autodetect) {
        this.autodetect = autodetect;
    }

    public void setExcludedBeans(String[] excludedBeans) {
        this.excludedBeans = excludedBeans != null ? new HashSet<String>(Arrays.asList(excludedBeans)) : null;
    }

    public void setAssembler(MBeanInfoAssembler assembler) {
        this.assembler = assembler;
    }

    public void setNamingStrategy(ObjectNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public void setListeners(MBeanExporterListener[] listeners) {
        this.listeners = listeners;
    }

    public void setRegistrationBehaviorName(String registrationBehavior) {
        this.setRegistrationBehavior(constants.asNumber(registrationBehavior).intValue());
    }

    public void setRegistrationBehavior(int registrationBehavior) {
        this.registrationBehavior = registrationBehavior;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ListableBeanFactory) {
            this.beanFactory = (ListableBeanFactory)beanFactory;
        } else {
            this.logger.info((Object)"Not running in a ListableBeanFactory: autodetection of MBeans not available");
        }
    }

    public void afterPropertiesSet() throws JMException {
        this.registerBeans();
    }

    protected void registerBeans() throws JMException {
        if (this.server == null) {
            this.server = JmxUtils.locateMBeanServer();
        }
        if (this.beans == null) {
            this.beans = new HashMap();
        }
        if (this.autodetect) {
            if (this.beanFactory == null) {
                throw new JMException("Cannot autodetect MBeans if not running in a BeanFactory");
            }
            this.logger.info((Object)"Autodetecting user-defined JMX MBeans");
            this.autodetectMBeans();
            if (this.assembler instanceof AutodetectCapableMBeanInfoAssembler) {
                this.autodetectBeans((AutodetectCapableMBeanInfoAssembler)this.assembler);
            }
        }
        if (this.beans.isEmpty()) {
            throw new IllegalArgumentException("Must specify at least one bean for registration");
        }
        this.registeredBeans = new HashSet(this.beans.size());
        try {
            Iterator it = this.beans.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String beanKey = (String)entry.getKey();
                Object value = entry.getValue();
                ObjectName objectName = this.registerBeanNameOrInstance(value, beanKey);
                if (objectName == null) continue;
                this.registeredBeans.add(objectName);
                this.notifyListenersOfRegistration(objectName);
            }
        }
        catch (InvalidTargetObjectTypeException ex) {
            this.unregisterBeans();
            throw new JMException("An invalid object type was used when specifying a managed resource. This is a serious error and points to an error in the Spring JMX code. Root cause: " + ex.getMessage());
        }
        catch (JMException ex) {
            this.unregisterBeans();
            throw ex;
        }
    }

    private ObjectName registerBeanNameOrInstance(Object mapValue, String beanKey) throws JMException, InvalidTargetObjectTypeException {
        if (mapValue instanceof String) {
            if (this.beanFactory == null) {
                throw new JMException("Cannot resolve bean names if not running in a BeanFactory");
            }
            String beanName = (String)mapValue;
            if (this.isBeanDefinitionLazyInit(this.beanFactory, beanName)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Found bean name for lazy init bean with key [" + beanKey + "]. Registering bean with lazy init support."));
                }
                return this.registerLazyInit(beanName, beanKey);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("String value under key [" + beanKey + "] points to a bean that was not " + "registered for lazy initialization. Registering bean normally with JMX server."));
            }
            Object bean = this.beanFactory.getBean(beanName);
            return this.registerBeanInstance(bean, beanKey);
        }
        return this.registerBeanInstance(mapValue, beanKey);
    }

    private ObjectName registerBeanInstance(Object beanInstance, String beanKey) throws JMException, InvalidTargetObjectTypeException {
        if (JmxUtils.isMBean(beanInstance.getClass())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Located MBean under key [" + beanKey + "]: registering with JMX server"));
            }
            return this.registerMBean(beanInstance, beanKey);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Located bean under key [" + beanKey + "] registering with JMX server."));
        }
        return this.registerSimpleBean(beanInstance, beanKey);
    }

    private ObjectName registerMBean(Object mbean, String beanKey) throws JMException {
        try {
            ObjectName objectName = this.getObjectName(mbean, beanKey);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Registering MBean [" + objectName + "]"));
            }
            return this.doRegister(mbean, objectName);
        }
        catch (MalformedObjectNameException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Unable to register MBean [" + mbean + "] with key [" + beanKey + "]"));
            }
            return null;
        }
    }

    private ObjectName registerSimpleBean(Object bean, String beanKey) throws JMException, InvalidTargetObjectTypeException {
        ObjectName objectName = this.getObjectName(bean, beanKey);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Registering and assembling MBean [" + objectName + "]"));
        }
        ModelMBean mbean = this.createModelMBean();
        mbean.setModelMBeanInfo(this.getMBeanInfo(bean, beanKey));
        mbean.setManagedResource(bean, MR_TYPE_OBJECT_REFERENCE);
        return this.doRegister(mbean, objectName);
    }

    private ObjectName registerLazyInit(String beanName, String beanKey) throws JMException, InvalidTargetObjectTypeException {
        LazyInitTargetSource targetSource = new LazyInitTargetSource();
        targetSource.setTargetBeanName(beanName);
        targetSource.setBeanFactory((BeanFactory)this.beanFactory);
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTargetSource((TargetSource)targetSource);
        proxyFactory.setProxyTargetClass(true);
        proxyFactory.setFrozen(true);
        Object proxy = proxyFactory.getProxy();
        ObjectName objectName = this.getObjectName(proxy, beanKey);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Registering lazy-init MBean [" + objectName + "]"));
        }
        ModelMBean mbean = this.createModelMBean();
        mbean.setModelMBeanInfo(this.getMBeanInfo(proxy, beanKey));
        mbean.setManagedResource(proxy, MR_TYPE_OBJECT_REFERENCE);
        return this.doRegister(mbean, objectName);
    }

    private ObjectName doRegister(Object mbean, ObjectName objectName) throws JMException {
        ObjectName actualObjectName;
        ObjectInstance registeredBean = null;
        try {
            registeredBean = this.server.registerMBean(mbean, objectName);
        }
        catch (InstanceAlreadyExistsException ex) {
            if (this.registrationBehavior == 1) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Ignoring existing MBean at [" + objectName + "]"));
                }
            }
            if (this.registrationBehavior == 2) {
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Replacing existing MBean at [" + objectName + "]"));
                    }
                    this.server.unregisterMBean(objectName);
                    registeredBean = this.server.registerMBean(mbean, objectName);
                }
                catch (InstanceNotFoundException ex2) {
                    throw new IllegalStateException("Unable to replace existing MBean at [" + objectName + "]: " + ex.getMessage());
                }
            }
            throw ex;
        }
        ObjectName objectName2 = actualObjectName = registeredBean != null ? registeredBean.getObjectName() : null;
        if (actualObjectName == null) {
            actualObjectName = objectName;
        }
        return actualObjectName;
    }

    private ObjectName getObjectName(Object bean, String beanKey) throws MalformedObjectNameException {
        if (bean instanceof SelfNaming) {
            return ((SelfNaming)bean).getObjectName();
        }
        return this.namingStrategy.getObjectName(bean, beanKey);
    }

    private ModelMBeanInfo getMBeanInfo(Object managedBean, String beanKey) throws JMException {
        ModelMBeanInfo info = this.assembler.getMBeanInfo(managedBean, beanKey);
        if (this.logger.isWarnEnabled() && ObjectUtils.isEmpty((Object[])info.getAttributes()) && ObjectUtils.isEmpty((Object[])info.getOperations())) {
            this.logger.warn((Object)("Bean with key [" + beanKey + "] has been registed as an MBean but has no exposed attributes or operations"));
        }
        return info;
    }

    private void autodetectMBeans() {
        this.autodetect(new AutodetectCallback(){

            public boolean include(Class beanClass, String beanName) {
                return JmxUtils.isMBean(beanClass);
            }
        });
    }

    private void autodetectBeans(final AutodetectCapableMBeanInfoAssembler assembler) {
        this.autodetect(new AutodetectCallback(){

            public boolean include(Class beanClass, String beanName) {
                return assembler.includeBean(beanClass, beanName);
            }
        });
    }

    private void autodetect(AutodetectCallback callback) {
        String[] beanNames = this.beanFactory.getBeanNamesForType(null);
        for (int i = 0; i < beanNames.length; ++i) {
            Object beanInstance;
            Class beanClass;
            String beanName = beanNames[i];
            if (this.isExcluded(beanName) || (beanClass = this.beanFactory.getType(beanName)) == null || !callback.include(beanClass, beanName)) continue;
            boolean lazyInit = this.isBeanDefinitionLazyInit(this.beanFactory, beanName);
            Object object = beanInstance = !lazyInit ? this.beanFactory.getBean(beanName) : null;
            if (!(this.beans.containsValue(beanName) || beanInstance != null && CollectionUtils.containsInstance(this.beans.values(), (Object)beanInstance))) {
                this.beans.put(beanName, beanInstance != null ? beanInstance : beanName);
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info((Object)("Bean with name '" + beanName + "' has been autodetected for JMX exposure"));
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Bean with name '" + beanName + "' is already registered for JMX exposure"));
        }
    }

    protected boolean isBeanDefinitionLazyInit(ListableBeanFactory beanFactory, String beanName) {
        if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
            return false;
        }
        try {
            BeanDefinition bd = ((ConfigurableListableBeanFactory)beanFactory).getBeanDefinition(beanName);
            return bd.isLazyInit();
        }
        catch (NoSuchBeanDefinitionException ex) {
            return false;
        }
    }

    protected ModelMBean createModelMBean() throws MBeanException {
        return new RequiredModelMBean();
    }

    private boolean isExcluded(String beanName) {
        return this.excludedBeans != null && this.excludedBeans.contains(beanName);
    }

    private void notifyListenersOfRegistration(ObjectName objectName) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.length; ++i) {
                MBeanExporterListener listener = this.listeners[i];
                listener.mbeanRegistered(objectName);
            }
        }
    }

    private void notifyListenersOfUnregistration(ObjectName objectName) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.length; ++i) {
                MBeanExporterListener listener = this.listeners[i];
                listener.mbeanUnregistered(objectName);
            }
        }
    }

    public void destroy() {
        this.unregisterBeans();
    }

    private void unregisterBeans() {
        this.logger.info((Object)"Unregistering JMX-exposed beans on shutdown");
        Iterator it = this.registeredBeans.iterator();
        while (it.hasNext()) {
            ObjectName objectName = (ObjectName)it.next();
            try {
                if (this.server.isRegistered(objectName)) {
                    this.server.unregisterMBean(objectName);
                    this.notifyListenersOfUnregistration(objectName);
                    continue;
                }
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn((Object)("Could not unregister MBean [" + objectName + "] as said MBean " + "is not registered (perhaps already unregistered by an external process)"));
            }
            catch (JMException ex) {
                if (!this.logger.isErrorEnabled()) continue;
                this.logger.error((Object)("Could not unregister MBean [" + objectName + "]"), (Throwable)ex);
            }
        }
        this.registeredBeans.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static interface AutodetectCallback {
        public boolean include(Class var1, String var2);
    }
}

