/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.rmi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jndi.JndiObjectLocator;
import org.springframework.remoting.RemoteConnectFailureException;
import org.springframework.remoting.RemoteLookupFailureException;
import org.springframework.remoting.RemoteProxyFailureException;
import org.springframework.remoting.rmi.RmiClientInterceptorUtils;
import org.springframework.remoting.rmi.RmiInvocationHandler;
import org.springframework.remoting.support.DefaultRemoteInvocationFactory;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationFactory;

public class JndiRmiClientInterceptor
extends JndiObjectLocator
implements MethodInterceptor,
InitializingBean {
    private Class serviceInterface;
    private RemoteInvocationFactory remoteInvocationFactory = new DefaultRemoteInvocationFactory();
    private boolean lookupStubOnStartup = true;
    private boolean cacheStub = true;
    private boolean refreshStubOnConnectFailure = false;
    private Remote cachedStub;
    static /* synthetic */ Class class$java$rmi$Remote;

    public void setServiceInterface(Class serviceInterface) {
        if (serviceInterface != null && !serviceInterface.isInterface()) {
            throw new IllegalArgumentException("serviceInterface must be an interface");
        }
        this.serviceInterface = serviceInterface;
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    public void setRemoteInvocationFactory(RemoteInvocationFactory remoteInvocationFactory) {
        this.remoteInvocationFactory = remoteInvocationFactory;
    }

    public RemoteInvocationFactory getRemoteInvocationFactory() {
        return this.remoteInvocationFactory;
    }

    public void setLookupStubOnStartup(boolean lookupStubOnStartup) {
        this.lookupStubOnStartup = lookupStubOnStartup;
    }

    public void setCacheStub(boolean cacheStub) {
        this.cacheStub = cacheStub;
    }

    public void setRefreshStubOnConnectFailure(boolean refreshStubOnConnectFailure) {
        this.refreshStubOnConnectFailure = refreshStubOnConnectFailure;
    }

    public void afterPropertiesSet() throws NamingException {
        super.afterPropertiesSet();
        this.prepare();
    }

    public void prepare() throws NamingException {
        if (this.lookupStubOnStartup) {
            Remote remoteObj = this.lookupStub();
            if (this.logger.isDebugEnabled()) {
                if (remoteObj instanceof RmiInvocationHandler) {
                    this.logger.debug((Object)("JNDI RMI object [" + this.getJndiName() + "] is an RMI invoker"));
                } else if (this.getServiceInterface() != null) {
                    boolean isImpl = this.getServiceInterface().isInstance(remoteObj);
                    this.logger.debug((Object)("Using service interface [" + this.getServiceInterface().getName() + "] for JNDI RMI object [" + this.getJndiName() + "] - " + (!isImpl ? "not " : "") + "directly implemented"));
                }
            }
            if (this.cacheStub) {
                this.cachedStub = remoteObj;
            }
        }
    }

    protected Remote lookupStub() throws NamingException {
        Object stub = this.lookup();
        if (this.getServiceInterface() != null && (class$java$rmi$Remote == null ? (class$java$rmi$Remote = JndiRmiClientInterceptor.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(this.getServiceInterface())) {
            stub = PortableRemoteObject.narrow((Object)stub, (Class)this.getServiceInterface());
        }
        if (!(stub instanceof Remote)) {
            throw new NamingException("Located RMI stub of class [" + stub.getClass().getName() + "], with JNDI name [" + this.getJndiName() + "], does not implement interface [java.rmi.Remote]");
        }
        return (Remote)stub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Remote getStub() throws NamingException {
        if (!this.cacheStub || this.lookupStubOnStartup && !this.refreshStubOnConnectFailure) {
            return this.cachedStub != null ? this.cachedStub : this.lookupStub();
        }
        JndiRmiClientInterceptor jndiRmiClientInterceptor = this;
        synchronized (jndiRmiClientInterceptor) {
            if (this.cachedStub == null) {
                this.cachedStub = this.lookupStub();
            }
            return this.cachedStub;
        }
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Remote stub = null;
        try {
            stub = this.getStub();
        }
        catch (Throwable ex) {
            throw new RemoteLookupFailureException("JNDI lookup for RMI service [" + this.getJndiName() + "] failed", ex);
        }
        try {
            return this.doInvoke(invocation, stub);
        }
        catch (RemoteConnectFailureException ex) {
            return this.handleRemoteConnectFailure(invocation, (Exception)((Object)ex));
        }
        catch (RemoteException ex) {
            if (this.isConnectFailure(ex)) {
                return this.handleRemoteConnectFailure(invocation, ex);
            }
            throw ex;
        }
    }

    protected boolean isConnectFailure(RemoteException ex) {
        return RmiClientInterceptorUtils.isConnectFailure(ex);
    }

    private Object handleRemoteConnectFailure(MethodInvocation invocation, Exception ex) throws Throwable {
        if (this.refreshStubOnConnectFailure) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Could not connect to RMI service [" + this.getJndiName() + "] - retrying"), (Throwable)ex);
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Could not connect to RMI service [" + this.getJndiName() + "] - retrying"));
            }
            return this.refreshAndRetry(invocation);
        }
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object refreshAndRetry(MethodInvocation invocation) throws Throwable {
        Remote freshStub = null;
        JndiRmiClientInterceptor jndiRmiClientInterceptor = this;
        synchronized (jndiRmiClientInterceptor) {
            try {
                freshStub = this.lookupStub();
                if (this.cacheStub) {
                    this.cachedStub = freshStub;
                }
            }
            catch (Throwable ex) {
                throw new RemoteLookupFailureException("JNDI lookup for RMI service [" + this.getJndiName() + "] failed", ex);
            }
        }
        return this.doInvoke(invocation, freshStub);
    }

    protected Object doInvoke(MethodInvocation invocation, Remote stub) throws Throwable {
        if (stub instanceof RmiInvocationHandler) {
            try {
                return this.doInvoke(invocation, (RmiInvocationHandler)stub);
            }
            catch (RemoteException ex) {
                throw RmiClientInterceptorUtils.convertRmiAccessException(invocation.getMethod(), ex, this.isConnectFailure(ex), this.getJndiName());
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
            catch (Throwable ex) {
                throw new RemoteProxyFailureException("Failed to invoke RMI stub for remote service [" + this.getJndiName() + "]", ex);
            }
        }
        try {
            return RmiClientInterceptorUtils.doInvoke(invocation, stub);
        }
        catch (InvocationTargetException ex) {
            Throwable targetEx = ex.getTargetException();
            if (targetEx instanceof RemoteException) {
                RemoteException rex = (RemoteException)targetEx;
                throw RmiClientInterceptorUtils.convertRmiAccessException(invocation.getMethod(), rex, this.isConnectFailure(rex), this.getJndiName());
            }
            throw targetEx;
        }
    }

    protected Object doInvoke(MethodInvocation methodInvocation, RmiInvocationHandler invocationHandler) throws RemoteException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (AopUtils.isToStringMethod((Method)methodInvocation.getMethod())) {
            return "RMI invoker proxy for service URL [" + this.getJndiName() + "]";
        }
        return invocationHandler.invoke(this.createRemoteInvocation(methodInvocation));
    }

    protected RemoteInvocation createRemoteInvocation(MethodInvocation methodInvocation) {
        return this.getRemoteInvocationFactory().createRemoteInvocation(methodInvocation);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

