/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.vendor;

import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.ejb.HibernateEntityManager;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.datasource.ConnectionHandle;
import org.springframework.jdbc.datasource.SimpleConnectionHandle;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.jpa.DefaultJpaDialect;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;

public class HibernateJpaDialect
extends DefaultJpaDialect {
    public Object beginTransaction(EntityManager entityManager, TransactionDefinition definition) throws PersistenceException, SQLException, TransactionException {
        if (definition.getTimeout() != -1) {
            this.getSession(entityManager).getTransaction().setTimeout(definition.getTimeout());
        }
        super.beginTransaction(entityManager, definition);
        return this.prepareTransaction(entityManager, definition.isReadOnly(), definition.getName());
    }

    public Object prepareTransaction(EntityManager entityManager, boolean readOnly, String name) throws PersistenceException {
        Session session = this.getSession(entityManager);
        FlushMode flushMode = session.getFlushMode();
        FlushMode previousFlushMode = null;
        if (readOnly) {
            session.setFlushMode(FlushMode.MANUAL);
            previousFlushMode = flushMode;
        } else if (flushMode.lessThan(FlushMode.COMMIT)) {
            session.setFlushMode(FlushMode.AUTO);
            previousFlushMode = flushMode;
        }
        return new SessionTransactionData(session, previousFlushMode);
    }

    public void cleanupTransaction(Object transactionData) {
        ((SessionTransactionData)transactionData).resetFlushMode();
    }

    public ConnectionHandle getJdbcConnection(EntityManager entityManager, boolean readOnly) throws PersistenceException, SQLException {
        Session session = this.getSession(entityManager);
        Connection con = session.connection();
        return con != null ? new SimpleConnectionHandle(con) : null;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof HibernateException) {
            return SessionFactoryUtils.convertHibernateAccessException((HibernateException)((Object)ex));
        }
        if (ex instanceof PersistenceException && ex.getCause() instanceof HibernateException) {
            return SessionFactoryUtils.convertHibernateAccessException((HibernateException)ex.getCause());
        }
        return EntityManagerFactoryUtils.convertJpaAccessExceptionIfPossible(ex);
    }

    protected Session getSession(EntityManager em) {
        if (em instanceof HibernateEntityManager) {
            return ((HibernateEntityManager)em).getSession();
        }
        Object delegate = em.getDelegate();
        if (delegate instanceof Session) {
            return (Session)delegate;
        }
        throw new IllegalStateException("Cannot obtain native Hibernate Session from given JPA EntityManager: " + em.getClass());
    }

    private static class SessionTransactionData {
        private final Session session;
        private final FlushMode previousFlushMode;

        public SessionTransactionData(Session session, FlushMode previousFlushMode) {
            this.session = session;
            this.previousFlushMode = previousFlushMode;
        }

        public void resetFlushMode() {
            if (this.previousFlushMode != null) {
                this.session.setFlushMode(this.previousFlushMode);
            }
        }
    }
}

