/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.concurrent;

import jakarta.enterprise.concurrent.LastExecution;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.concurrent.ConcurrentTaskExecutor;
import org.springframework.scheduling.concurrent.ReschedulingRunnable;
import org.springframework.scheduling.support.TaskUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ErrorHandler;

public class ConcurrentTaskScheduler
extends ConcurrentTaskExecutor
implements TaskScheduler {
    @Nullable
    private static Class<?> managedScheduledExecutorServiceClass;
    private ScheduledExecutorService scheduledExecutor;
    private boolean enterpriseConcurrentScheduler = false;
    @Nullable
    private ErrorHandler errorHandler;
    private Clock clock = Clock.systemDefaultZone();

    public ConcurrentTaskScheduler() {
        this.initScheduledExecutor(null);
    }

    public ConcurrentTaskScheduler(ScheduledExecutorService scheduledExecutor) {
        super(scheduledExecutor);
        this.initScheduledExecutor(scheduledExecutor);
    }

    public ConcurrentTaskScheduler(Executor concurrentExecutor, ScheduledExecutorService scheduledExecutor) {
        super(concurrentExecutor);
        this.initScheduledExecutor(scheduledExecutor);
    }

    private void initScheduledExecutor(@Nullable ScheduledExecutorService scheduledExecutor) {
        if (scheduledExecutor != null) {
            this.scheduledExecutor = scheduledExecutor;
            this.enterpriseConcurrentScheduler = managedScheduledExecutorServiceClass != null && managedScheduledExecutorServiceClass.isInstance(scheduledExecutor);
        } else {
            this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
            this.enterpriseConcurrentScheduler = false;
        }
    }

    public void setScheduledExecutor(@Nullable ScheduledExecutorService scheduledExecutor) {
        this.initScheduledExecutor(scheduledExecutor);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        Assert.notNull((Object)errorHandler, (String)"ErrorHandler must not be null");
        this.errorHandler = errorHandler;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    @Override
    public Clock getClock() {
        return this.clock;
    }

    @Override
    @Nullable
    public ScheduledFuture<?> schedule(Runnable task, Trigger trigger) {
        try {
            if (this.enterpriseConcurrentScheduler) {
                return new EnterpriseConcurrentTriggerScheduler().schedule(this.decorateTask(task, true), trigger);
            }
            ErrorHandler errorHandler = this.errorHandler != null ? this.errorHandler : TaskUtils.getDefaultErrorHandler(true);
            return new ReschedulingRunnable(task, trigger, this.clock, this.scheduledExecutor, errorHandler).schedule();
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + this.scheduledExecutor + "] did not accept task: " + task, (Throwable)ex);
        }
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable task, Instant startTime) {
        Duration initialDelay = Duration.between(this.clock.instant(), startTime);
        try {
            return this.scheduledExecutor.schedule(this.decorateTask(task, false), initialDelay.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + this.scheduledExecutor + "] did not accept task: " + task, (Throwable)ex);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Instant startTime, Duration period) {
        Duration initialDelay = Duration.between(this.clock.instant(), startTime);
        try {
            return this.scheduledExecutor.scheduleAtFixedRate(this.decorateTask(task, true), initialDelay.toMillis(), period.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + this.scheduledExecutor + "] did not accept task: " + task, (Throwable)ex);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Duration period) {
        try {
            return this.scheduledExecutor.scheduleAtFixedRate(this.decorateTask(task, true), 0L, period.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + this.scheduledExecutor + "] did not accept task: " + task, (Throwable)ex);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Instant startTime, Duration delay) {
        Duration initialDelay = Duration.between(this.clock.instant(), startTime);
        try {
            return this.scheduledExecutor.scheduleWithFixedDelay(this.decorateTask(task, true), initialDelay.toMillis(), delay.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + this.scheduledExecutor + "] did not accept task: " + task, (Throwable)ex);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Duration delay) {
        try {
            return this.scheduledExecutor.scheduleWithFixedDelay(this.decorateTask(task, true), 0L, delay.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + this.scheduledExecutor + "] did not accept task: " + task, (Throwable)ex);
        }
    }

    private Runnable decorateTask(Runnable task, boolean isRepeatingTask) {
        Runnable result = TaskUtils.decorateTaskWithErrorHandler(task, this.errorHandler, isRepeatingTask);
        if (this.enterpriseConcurrentScheduler) {
            result = ConcurrentTaskExecutor.ManagedTaskBuilder.buildManagedTask(result, task.toString());
        }
        return result;
    }

    static {
        try {
            managedScheduledExecutorServiceClass = ClassUtils.forName((String)"jakarta.enterprise.concurrent.ManagedScheduledExecutorService", (ClassLoader)ConcurrentTaskScheduler.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            managedScheduledExecutorServiceClass = null;
        }
    }

    private class EnterpriseConcurrentTriggerScheduler {
        private EnterpriseConcurrentTriggerScheduler() {
        }

        public ScheduledFuture<?> schedule(Runnable task, Trigger trigger) {
            ManagedScheduledExecutorService executor = (ManagedScheduledExecutorService)ConcurrentTaskScheduler.this.scheduledExecutor;
            return executor.schedule(task, (jakarta.enterprise.concurrent.Trigger)new TriggerAdapter(trigger));
        }

        private static class TriggerAdapter
        implements jakarta.enterprise.concurrent.Trigger {
            private final Trigger adaptee;

            public TriggerAdapter(Trigger adaptee) {
                this.adaptee = adaptee;
            }

            @Nullable
            public Date getNextRunTime(@Nullable LastExecution le, Date taskScheduledTime) {
                Instant instant = this.adaptee.nextExecution(new LastExecutionAdapter(le));
                return instant != null ? Date.from(instant) : null;
            }

            public boolean skipRun(LastExecution lastExecutionInfo, Date scheduledRunTime) {
                return false;
            }

            private static class LastExecutionAdapter
            implements TriggerContext {
                @Nullable
                private final LastExecution le;

                public LastExecutionAdapter(@Nullable LastExecution le) {
                    this.le = le;
                }

                @Override
                public Instant lastScheduledExecution() {
                    return this.le != null ? LastExecutionAdapter.toInstant(this.le.getScheduledStart()) : null;
                }

                @Override
                public Instant lastActualExecution() {
                    return this.le != null ? LastExecutionAdapter.toInstant(this.le.getRunStart()) : null;
                }

                @Override
                public Instant lastCompletion() {
                    return this.le != null ? LastExecutionAdapter.toInstant(this.le.getRunEnd()) : null;
                }

                @Nullable
                private static Instant toInstant(@Nullable Date date) {
                    return date != null ? date.toInstant() : null;
                }
            }
        }
    }
}

