/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.config.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.social.UserIdSource;
import org.springframework.social.config.xml.ApiHelper;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.UsersConnectionRepository;
import org.springframework.social.twitter.api.Twitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwitterApiHelper
implements ApiHelper<Twitter> {
    private final UsersConnectionRepository usersConnectionRepository;
    private final UserIdSource userIdSource;
    private static final Log logger = LogFactory.getLog(TwitterApiHelper.class);

    private TwitterApiHelper(UsersConnectionRepository usersConnectionRepository, UserIdSource userIdSource) {
        this.usersConnectionRepository = usersConnectionRepository;
        this.userIdSource = userIdSource;
    }

    public Twitter getApi() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Getting API binding instance for Twitter");
        }
        Connection connection = this.usersConnectionRepository.createConnectionRepository(this.userIdSource.getUserId()).findPrimaryConnection(Twitter.class);
        if (logger.isDebugEnabled() && connection == null) {
            logger.debug((Object)"No current connection; Returning default TwitterTemplate instance.");
        }
        return connection != null ? (Twitter)connection.getApi() : null;
    }
}

