/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.social.DuplicateStatusException;
import org.springframework.social.ExpiredAuthorizationException;
import org.springframework.social.InsufficientPermissionException;
import org.springframework.social.InternalServerErrorException;
import org.springframework.social.InvalidAuthorizationException;
import org.springframework.social.MissingAuthorizationException;
import org.springframework.social.NotAuthorizedException;
import org.springframework.social.OperationNotPermittedException;
import org.springframework.social.RateLimitExceededException;
import org.springframework.social.ResourceNotFoundException;
import org.springframework.social.RevokedAuthorizationException;
import org.springframework.social.UncategorizedApiException;
import org.springframework.social.facebook.api.NotAFriendException;
import org.springframework.social.facebook.api.ResourceOwnershipException;
import org.springframework.web.client.DefaultResponseErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FacebookErrorHandler
extends DefaultResponseErrorHandler {
    private static final Log logger = LogFactory.getLog(FacebookErrorHandler.class);
    private static final String FACEBOOK = "facebook";

    FacebookErrorHandler() {
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        Map<String, String> errorDetails = this.extractErrorDetailsFromResponse(response);
        if (errorDetails == null) {
            this.handleUncategorizedError(response, errorDetails);
        }
        this.handleFacebookError(response.getStatusCode(), errorDetails);
        this.handleUncategorizedError(response, errorDetails);
    }

    void handleFacebookError(HttpStatus statusCode, Map<String, String> errorDetails) {
        String message = errorDetails.get("message");
        if (statusCode == HttpStatus.NOT_FOUND) {
            if (message.contains("Some of the aliases you requested do not exist")) {
                throw new ResourceNotFoundException(FACEBOOK, message);
            }
        } else if (statusCode == HttpStatus.BAD_REQUEST) {
            if (message.contains("Unknown path components")) {
                throw new ResourceNotFoundException(FACEBOOK, message);
            }
            if (message.equals("An access token is required to request this resource.")) {
                throw new MissingAuthorizationException(FACEBOOK);
            }
            if (message.equals("An active access token must be used to query information about the current user.")) {
                throw new MissingAuthorizationException(FACEBOOK);
            }
            if (message.startsWith("Error validating access token")) {
                this.handleInvalidAccessToken(message);
            } else {
                if (message.equals("Invalid access token signature.")) {
                    throw new InvalidAuthorizationException(FACEBOOK, message);
                }
                if (message.contains("Application does not have the capability to make this API call.") || message.contains("App must be on whitelist")) {
                    throw new OperationNotPermittedException(FACEBOOK, message);
                }
                if (message.contains("Invalid fbid") || message.contains("The parameter url is required")) {
                    throw new OperationNotPermittedException(FACEBOOK, "Invalid object for this operation");
                }
                if (message.contains("Duplicate status message")) {
                    throw new DuplicateStatusException(FACEBOOK, message);
                }
                if (message.contains("Feed action request limit reached")) {
                    throw new RateLimitExceededException(FACEBOOK);
                }
                if (message.contains("The status you are trying to publish is a duplicate of, or too similar to, one that we recently posted to Twitter")) {
                    throw new DuplicateStatusException(FACEBOOK, message);
                }
            }
        } else {
            if (statusCode == HttpStatus.UNAUTHORIZED) {
                if (message.startsWith("Error validating access token")) {
                    this.handleInvalidAccessToken(message);
                } else {
                    if (message.equals("Invalid OAuth access token.")) {
                        throw new InvalidAuthorizationException(FACEBOOK, message);
                    }
                    if (message.startsWith("Error validating application.")) {
                        throw new InvalidAuthorizationException(FACEBOOK, message);
                    }
                }
                throw new NotAuthorizedException(FACEBOOK, message);
            }
            if (statusCode == HttpStatus.FORBIDDEN) {
                if (message.contains("Requires extended permission")) {
                    throw new InsufficientPermissionException(FACEBOOK, message.split(": ")[1]);
                }
                if (message.contains("Permissions error")) {
                    throw new InsufficientPermissionException(FACEBOOK);
                }
                if (message.contains("The user hasn't authorized the application to perform this action")) {
                    throw new InsufficientPermissionException(FACEBOOK);
                }
                throw new OperationNotPermittedException(FACEBOOK, message);
            }
            if (statusCode == HttpStatus.NOT_FOUND) {
                throw new ResourceNotFoundException(FACEBOOK, message);
            }
            if (statusCode == HttpStatus.INTERNAL_SERVER_ERROR) {
                if (message.equals("User must be an owner of the friendlist")) {
                    throw new ResourceOwnershipException(message);
                }
                if (message.equals("The member must be a friend of the current user.")) {
                    throw new NotAFriendException(message);
                }
                throw new InternalServerErrorException(FACEBOOK, message);
            }
        }
    }

    private void handleInvalidAccessToken(String message) {
        if (message.contains("Session has expired at unix time")) {
            throw new ExpiredAuthorizationException(FACEBOOK);
        }
        if (message.contains("The session has been invalidated because the user has changed the password.")) {
            throw new RevokedAuthorizationException(FACEBOOK, message);
        }
        if (message.contains("The session is invalid because the user logged out.")) {
            throw new RevokedAuthorizationException(FACEBOOK, message);
        }
        if (message.contains("The session was invalidated explicitly using an API call.")) {
            throw new RevokedAuthorizationException(FACEBOOK, message);
        }
        if (message.contains("Session does not match current stored session.")) {
            throw new RevokedAuthorizationException(FACEBOOK, message);
        }
        throw new InvalidAuthorizationException(FACEBOOK, message);
    }

    private void handleUncategorizedError(ClientHttpResponse response, Map<String, String> errorDetails) {
        try {
            super.handleError(response);
        }
        catch (Exception e) {
            if (errorDetails != null) {
                throw new UncategorizedApiException(FACEBOOK, errorDetails.get("message"), (Throwable)e);
            }
            throw new UncategorizedApiException(FACEBOOK, "No error details from Facebook", (Throwable)e);
        }
    }

    private Map<String, String> extractErrorDetailsFromResponse(ClientHttpResponse response) throws IOException {
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        String json = this.readFully(response.getBody());
        System.out.println(json);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Error from Facebook: " + json));
        }
        if (json.equals("false")) {
            throw new InsufficientPermissionException(FACEBOOK);
        }
        try {
            Map responseMap = (Map)mapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
            if (responseMap.containsKey("error")) {
                return (Map)responseMap.get("error");
            }
        }
        catch (JsonParseException e) {
            return null;
        }
        return null;
    }

    private String readFully(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuilder sb = new StringBuilder();
        while (reader.ready()) {
            sb.append(reader.readLine());
        }
        return sb.toString();
    }
}

