/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import java.util.List;
import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.LikeOperations;
import org.springframework.social.facebook.api.Page;
import org.springframework.social.facebook.api.Reference;
import org.springframework.social.facebook.api.impl.AbstractFacebookOperations;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LikeTemplate
extends AbstractFacebookOperations
implements LikeOperations {
    private final GraphApi graphApi;
    private static final String PAGE_FIELDS = "id,name,category,description,location,website,picture,phone,affiliation,company_overview,likes,checkins";

    public LikeTemplate(GraphApi graphApi, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.graphApi = graphApi;
    }

    @Override
    public void like(String objectId) {
        this.requireAuthorization();
        this.graphApi.post(objectId, "likes", (MultiValueMap<String, String>)new LinkedMultiValueMap());
    }

    @Override
    public void unlike(String objectId) {
        this.requireAuthorization();
        this.graphApi.delete(objectId, "likes");
    }

    @Override
    public List<Reference> getLikes(String objectId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(objectId, "likes", Reference.class, new String[0]);
    }

    @Override
    public List<Page> getPagesLiked() {
        return this.getPagesLiked("me");
    }

    @Override
    public List<Page> getPagesLiked(String userId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(userId, "likes", Page.class, PAGE_FIELDS);
    }

    @Override
    public List<Page> getBooks() {
        return this.getBooks("me");
    }

    @Override
    public List<Page> getBooks(String userId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(userId, "books", Page.class, PAGE_FIELDS);
    }

    @Override
    public List<Page> getMovies() {
        return this.getMovies("me");
    }

    @Override
    public List<Page> getMovies(String userId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(userId, "movies", Page.class, PAGE_FIELDS);
    }

    @Override
    public List<Page> getMusic() {
        return this.getMusic("me");
    }

    @Override
    public List<Page> getMusic(String userId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(userId, "music", Page.class, PAGE_FIELDS);
    }

    @Override
    public List<Page> getTelevision() {
        return this.getTelevision("me");
    }

    @Override
    public List<Page> getTelevision(String userId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(userId, "television", Page.class, PAGE_FIELDS);
    }

    @Override
    public List<Page> getActivities() {
        return this.getActivities("me");
    }

    @Override
    public List<Page> getActivities(String userId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(userId, "activities", Page.class, PAGE_FIELDS);
    }

    @Override
    public List<Page> getInterests() {
        return this.getInterests("me");
    }

    @Override
    public List<Page> getInterests(String userId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(userId, "interests", Page.class, PAGE_FIELDS);
    }
}

